/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.auth.AuthorizationValue;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.refs.RefFormat;
import io.swagger.models.refs.RefType;
import io.swagger.parser.util.DeserializationUtils;
import io.swagger.parser.util.ParseOptions;
import io.swagger.parser.util.PathUtils;
import io.swagger.parser.util.RefUtils;
import io.swagger.parser.util.SwaggerDeserializer;
import io.swagger.v3.parser.urlresolver.PermittedUrlsChecker;
import io.swagger.v3.parser.urlresolver.exceptions.HostDeniedException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ResolverCache {
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("^" + RefType.PARAMETER.getInternalPrefix() + "(?<name>.+)");
    private static final Pattern DEFINITION_PATTERN = Pattern.compile("^" + RefType.DEFINITION.getInternalPrefix() + "(?<name>.+)");
    private static final Pattern RESPONSE_PATTERN = Pattern.compile("^" + RefType.RESPONSE.getInternalPrefix() + "(?<name>.+)");
    private static final Pattern PATHS_PATTERN = Pattern.compile("^" + RefType.PATH.getInternalPrefix() + "(?<name>.+)");
    private final Swagger swagger;
    private final List<AuthorizationValue> auths;
    private final Path parentDirectory;
    private final String parentUrl;
    private final String rootPath;
    private final ParseOptions parseOptions;
    private Map<String, Object> resolutionCache = new HashMap<String, Object>();
    private Map<String, String> externalFileCache = new HashMap<String, String>();
    private Set<String> referencedModelKeys = new HashSet<String>();
    private Map<String, String> renameCache = new ConcurrentHashMap<String, String>();

    public ResolverCache(Swagger swagger, List<AuthorizationValue> auths, String parentFileLocation) {
        this(swagger, auths, parentFileLocation, new ParseOptions());
    }

    public ResolverCache(Swagger swagger, List<AuthorizationValue> auths, String parentFileLocation, ParseOptions parseOptions) {
        this.swagger = swagger;
        this.auths = auths;
        this.rootPath = parentFileLocation;
        this.parseOptions = parseOptions;
        if (parentFileLocation != null) {
            this.parentDirectory = parentFileLocation.startsWith("http") ? null : PathUtils.getParentDirectoryOfFile(parentFileLocation);
        } else {
            File file = new File(".");
            this.parentDirectory = file.toPath();
        }
        this.parentUrl = parentFileLocation;
    }

    public <T> T loadRef(String ref, RefFormat refFormat, Class<T> expectedType) {
        Object result;
        String[] jsonPathElements;
        if (refFormat == RefFormat.INTERNAL) {
            Object loadedRef = this.loadInternalRef(ref);
            try {
                return expectedType.cast(loadedRef);
            }
            catch (Exception e) {
                return null;
            }
        }
        String[] refParts = ref.split("#/");
        if (refParts.length > 2) {
            throw new RuntimeException("Invalid ref format: " + ref);
        }
        String file = refParts[0];
        String definitionPath = refParts.length == 2 ? refParts[1] : null;
        Object previouslyResolvedEntity = this.resolutionCache.get(ref);
        if (previouslyResolvedEntity != null) {
            return expectedType.cast(previouslyResolvedEntity);
        }
        String contents = this.externalFileCache.get(file);
        if (contents == null) {
            if (this.parseOptions.isSafelyResolveURL()) {
                this.checkUrlIsPermitted(file);
            }
            if (this.parentDirectory != null) {
                contents = RefUtils.readExternalRef(file, refFormat, this.auths, this.parentDirectory);
            } else if (this.rootPath != null) {
                contents = RefUtils.readExternalUrlRef(file, refFormat, this.auths, this.rootPath);
            }
            this.externalFileCache.put(file, contents);
        }
        if (definitionPath == null) {
            T result2 = DeserializationUtils.deserialize(contents, file, expectedType);
            this.resolutionCache.put(ref, result2);
            return result2;
        }
        JsonNode tree = this.deserialize(contents, file);
        for (String jsonPathElement : jsonPathElements = definitionPath.split("/")) {
            if ((tree = tree.get(this.unescapePointer(jsonPathElement))) != null) continue;
            throw new RuntimeException("Could not find " + definitionPath + " in contents of " + file);
        }
        if (expectedType.equals(Model.class)) {
            SwaggerDeserializer ser = new SwaggerDeserializer();
            result = ser.definition((ObjectNode)tree, definitionPath.replace("/", "."), null);
        } else {
            result = DeserializationUtils.deserialize(tree, file, expectedType);
        }
        this.updateLocalRefs(file, result);
        this.resolutionCache.put(ref, result);
        if (result instanceof BodyParameter) {
            this.loadRef(ref, refFormat, (BodyParameter)result);
        }
        return result;
    }

    private void loadRef(String ref, RefFormat refFormat, BodyParameter bodyParameter) {
        Model schema = bodyParameter.getSchema();
        if (schema instanceof RefModel && refFormat != RefFormat.INTERNAL) {
            this.loadRef(ref, refFormat, (RefModel)schema);
        }
    }

    private void loadRef(String ref, RefFormat refFormat, RefModel refModel) {
        String rootRef = ref.substring(0, ref.indexOf(35));
        String externalRef = RefUtils.isAnExternalRefFormat(refModel.getRefFormat()) ? refModel.getReference() : rootRef + refModel.getReference();
        Model derefModel = this.loadRef(externalRef, refFormat, Model.class);
        this.swagger.addDefinition(refModel.getSimpleRef(), derefModel);
    }

    protected JsonNode deserialize(String contents, String file) {
        return DeserializationUtils.deserializeIntoTree(contents, file);
    }

    protected <T> void updateLocalRefs(String file, T result) {
        if (result instanceof Response) {
            Response response = (Response)result;
            this.updateLocalRefs(file, response.getResponseSchema());
        } else if (result instanceof RefProperty) {
            RefProperty prop = (RefProperty)result;
            this.updateLocalRefs(file, (Property)prop);
        } else if (result instanceof Model) {
            Model model = (Model)result;
            this.updateLocalRefs(file, model);
        }
    }

    protected <T> void updateLocalRefs(String file, Model schema) {
        ModelImpl impl;
        if (schema instanceof RefModel) {
            RefModel ref = (RefModel)schema;
            String updatedLocation = this.merge(file, ref.get$ref());
            ref.set$ref(updatedLocation);
        } else if (schema instanceof ModelImpl && (impl = (ModelImpl)schema).getProperties() != null) {
            for (Property property : schema.getProperties().values()) {
                this.updateLocalRefs(file, property);
            }
        }
    }

    protected <T> void updateLocalRefs(String file, Property schema) {
        if (schema instanceof RefProperty) {
            RefProperty ref = (RefProperty)schema;
            String updatedLocation = this.merge(file, ref.get$ref());
            ref.set$ref(updatedLocation);
        }
    }

    protected String merge(String host, String ref) {
        if (StringUtils.isBlank((CharSequence)host)) {
            return ref;
        }
        if (ref.startsWith("http:") || ref.startsWith("https:")) {
            return ref;
        }
        if (!host.startsWith("http:") && !host.startsWith("https:")) {
            return ref;
        }
        if (ref.startsWith(".")) {
            return ref;
        }
        if (host.endsWith("/") && ref.startsWith("/")) {
            return host + ref.substring(1);
        }
        return host + ref;
    }

    private String unescapePointer(String jsonPathElement) {
        try {
            jsonPathElement = URLDecoder.decode(jsonPathElement, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        jsonPathElement = jsonPathElement.replaceAll("~1", "/");
        return jsonPathElement.replaceAll("~0", "~");
    }

    private Object loadInternalRef(String ref) {
        Object result = null;
        if (ref.startsWith("#/definitions")) {
            result = this.getFromMap(ref, this.swagger.getParameters(), PARAMETER_PATTERN);
        } else if (ref.startsWith("#/responses")) {
            result = this.getFromMap(ref, this.swagger.getResponses(), RESPONSE_PATTERN);
        } else if (ref.startsWith("#/parameters")) {
            result = this.getFromMap(ref, this.swagger.getParameters(), PARAMETER_PATTERN);
        } else if (ref.startsWith("#/paths")) {
            result = this.getFromMap(ref, this.swagger.getPaths(), PATHS_PATTERN);
        }
        if (result == null) {
            result = this.getFromMap(ref, this.swagger.getDefinitions(), DEFINITION_PATTERN);
        }
        return result;
    }

    private Object getFromMap(String ref, Map map, Pattern pattern) {
        Matcher parameterMatcher = pattern.matcher(ref);
        if (parameterMatcher.matches()) {
            String paramName = this.unescapePointer(parameterMatcher.group("name"));
            if (map != null) {
                return map.get(paramName);
            }
        }
        return null;
    }

    protected void checkUrlIsPermitted(String refSet) {
        try {
            PermittedUrlsChecker permittedUrlsChecker = new PermittedUrlsChecker(this.parseOptions.getRemoteRefAllowList(), this.parseOptions.getRemoteRefBlockList());
            permittedUrlsChecker.verify(refSet);
        }
        catch (HostDeniedException exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public boolean hasReferencedKey(String modelKey) {
        if (this.referencedModelKeys == null) {
            return false;
        }
        return this.referencedModelKeys.contains(modelKey);
    }

    public void addReferencedKey(String modelKey) {
        this.referencedModelKeys.add(modelKey);
    }

    public String getRenamedRef(String originalRef) {
        return this.renameCache.get(originalRef);
    }

    public void putRenamedRef(String originalRef, String newRef) {
        this.renameCache.put(originalRef, newRef);
    }

    public Map<String, Object> getResolutionCache() {
        return Collections.unmodifiableMap(this.resolutionCache);
    }

    public Map<String, String> getExternalFileCache() {
        return Collections.unmodifiableMap(this.externalFileCache);
    }

    public Map<String, String> getRenameCache() {
        return Collections.unmodifiableMap(this.renameCache);
    }
}

