/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.alpn;

import io.undertow.protocols.alpn.ALPNProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import javax.net.ssl.SSLEngine;

public class ALPNManager {
    private final List<ALPNProvider> alpnProviders;
    public static final ALPNManager INSTANCE = new ALPNManager(ALPNManager.class.getClassLoader());

    public ALPNManager(ClassLoader classLoader) {
        ServiceLoader<ALPNProvider> loader = ServiceLoader.load(ALPNProvider.class, classLoader);
        ArrayList<ALPNProvider> provider = new ArrayList<ALPNProvider>();
        for (ALPNProvider prov : loader) {
            provider.add(prov);
        }
        Collections.sort(provider, new Comparator<ALPNProvider>(){

            @Override
            public int compare(ALPNProvider o1, ALPNProvider o2) {
                return Integer.compare(o2.getPriority(), o1.getPriority());
            }
        });
        this.alpnProviders = Collections.unmodifiableList(provider);
    }

    public ALPNProvider getProvider(SSLEngine engine) {
        for (ALPNProvider provider : this.alpnProviders) {
            if (!provider.isEnabled(engine)) continue;
            return provider;
        }
        return null;
    }
}

