/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.Connectors;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.server.protocol.http.HttpContinue;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSourceChannel;

public class RequestBufferingHandler
implements HttpHandler {
    private final HttpHandler next;
    private final int maxBuffers;

    public RequestBufferingHandler(HttpHandler next, int maxBuffers) {
        this.next = next;
        this.maxBuffers = maxBuffers;
    }

    @Override
    public void handleRequest(final HttpServerExchange exchange) throws Exception {
        if (!exchange.isRequestComplete() && !HttpContinue.requiresContinueResponse(exchange.getRequestHeaders())) {
            StreamSourceChannel channel = exchange.getRequestChannel();
            int readBuffers = 0;
            final PooledByteBuffer[] bufferedData = new PooledByteBuffer[this.maxBuffers];
            PooledByteBuffer buffer = exchange.getConnection().getByteBufferPool().allocate();
            try {
                while (true) {
                    ByteBuffer b;
                    int r;
                    if ((r = channel.read(b = buffer.getBuffer())) == -1) {
                        if (b.position() == 0) {
                            buffer.close();
                            break;
                        }
                        b.flip();
                        bufferedData[readBuffers] = buffer;
                        break;
                    }
                    if (r == 0) {
                        final PooledByteBuffer finalBuffer = buffer;
                        final int finalReadBuffers = readBuffers;
                        channel.getReadSetter().set((ChannelListener)new ChannelListener<StreamSourceChannel>(){
                            PooledByteBuffer buffer;
                            int readBuffers;
                            {
                                this.buffer = finalBuffer;
                                this.readBuffers = finalReadBuffers;
                            }

                            public void handleEvent(StreamSourceChannel channel) {
                                try {
                                    while (true) {
                                        ByteBuffer b;
                                        int r;
                                        if ((r = channel.read(b = this.buffer.getBuffer())) == -1) {
                                            if (b.position() == 0) {
                                                this.buffer.close();
                                            } else {
                                                b.flip();
                                                bufferedData[this.readBuffers] = this.buffer;
                                            }
                                            Connectors.ungetRequestBytes(exchange, bufferedData);
                                            Connectors.resetRequestChannel(exchange);
                                            Connectors.executeRootHandler(RequestBufferingHandler.this.next, exchange);
                                            channel.getReadSetter().set(null);
                                            return;
                                        }
                                        if (r == 0) {
                                            return;
                                        }
                                        if (b.hasRemaining()) continue;
                                        b.flip();
                                        bufferedData[this.readBuffers++] = this.buffer;
                                        if (this.readBuffers == RequestBufferingHandler.this.maxBuffers) {
                                            Connectors.ungetRequestBytes(exchange, bufferedData);
                                            Connectors.resetRequestChannel(exchange);
                                            Connectors.executeRootHandler(RequestBufferingHandler.this.next, exchange);
                                            channel.getReadSetter().set(null);
                                            return;
                                        }
                                        this.buffer = exchange.getConnection().getByteBufferPool().allocate();
                                    }
                                }
                                catch (Throwable t) {
                                    if (t instanceof IOException) {
                                        UndertowLogger.REQUEST_IO_LOGGER.ioException((IOException)t);
                                    } else {
                                        UndertowLogger.REQUEST_IO_LOGGER.handleUnexpectedFailure(t);
                                    }
                                    for (int i = 0; i < bufferedData.length; ++i) {
                                        IoUtils.safeClose((Closeable)bufferedData[i]);
                                    }
                                    if (this.buffer != null && this.buffer.isOpen()) {
                                        IoUtils.safeClose((Closeable)this.buffer);
                                    }
                                    exchange.endExchange();
                                    return;
                                }
                            }
                        });
                        channel.resumeReads();
                        return;
                    }
                    if (b.hasRemaining()) continue;
                    b.flip();
                    bufferedData[readBuffers++] = buffer;
                    if (readBuffers == this.maxBuffers) break;
                    buffer = exchange.getConnection().getByteBufferPool().allocate();
                }
                Connectors.ungetRequestBytes(exchange, bufferedData);
                Connectors.resetRequestChannel(exchange);
            }
            catch (Error | Exception e) {
                for (int i = 0; i < bufferedData.length; ++i) {
                    IoUtils.safeClose((Closeable)bufferedData[i]);
                }
                if (buffer != null && buffer.isOpen()) {
                    IoUtils.safeClose((Closeable)buffer);
                }
                throw e;
            }
        }
        this.next.handleRequest(exchange);
    }

    public static final class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "buffer-request";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("buffers", Integer.class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("buffers");
        }

        @Override
        public String defaultParameter() {
            return "buffers";
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper((Integer)config.get("buffers"));
        }
    }

    public static final class Wrapper
    implements HandlerWrapper {
        private final int maxBuffers;

        public Wrapper(int maxBuffers) {
            this.maxBuffers = maxBuffers;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new RequestBufferingHandler(handler, this.maxBuffers);
        }
    }
}

