/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.session.Session;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.servlet.ServletContext;

class SecurityActions {
    SecurityActions() {
    }

    static HttpSessionImpl forSession(final Session session, final ServletContext servletContext, final boolean newSession) {
        if (System.getSecurityManager() == null) {
            return HttpSessionImpl.forSession(session, servletContext, newSession);
        }
        return AccessController.doPrivileged(new PrivilegedAction<HttpSessionImpl>(){

            @Override
            public HttpSessionImpl run() {
                return HttpSessionImpl.forSession(session, servletContext, newSession);
            }
        });
    }

    static ServletRequestContext requireCurrentServletRequestContext() {
        if (System.getSecurityManager() == null) {
            return ServletRequestContext.requireCurrent();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ServletRequestContext>(){

            @Override
            public ServletRequestContext run() {
                return ServletRequestContext.requireCurrent();
            }
        });
    }
}

