/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.X509TrustManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;

public class SSLXMPPConnection
extends XMPPConnection {
    private static SocketFactory socketFactory = new DummySSLSocketFactory();

    public SSLXMPPConnection(String host) throws XMPPException {
        this(host, 5223);
    }

    public SSLXMPPConnection(String host, int port) throws XMPPException {
        super(host, port, socketFactory);
    }

    public boolean isSecureConnection() {
        return true;
    }

    private static class DummyTrustManager
    implements X509TrustManager {
        private DummyTrustManager() {
        }

        public boolean isClientTrusted(X509Certificate[] cert) {
            return true;
        }

        public boolean isServerTrusted(X509Certificate[] cert) {
            try {
                cert[0].checkValidity();
                return true;
            }
            catch (CertificateExpiredException e) {
                return false;
            }
            catch (CertificateNotYetValidException e) {
                return false;
            }
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class DummySSLSocketFactory
    extends SSLSocketFactory {
        private SSLSocketFactory factory;

        public DummySSLSocketFactory() {
            try {
                SSLContext sslcontent = SSLContext.getInstance((String)"TLS");
                sslcontent.init(null, new TrustManager[]{new DummyTrustManager()}, new SecureRandom());
                this.factory = sslcontent.getSocketFactory();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
        }

        public static SocketFactory getDefault() {
            return new DummySSLSocketFactory();
        }

        public Socket createSocket(Socket socket, String s, int i, boolean flag) throws IOException {
            return this.factory.createSocket(socket, s, i, flag);
        }

        public Socket createSocket(InetAddress inaddr, int i, InetAddress inaddr2, int j) throws IOException {
            return this.factory.createSocket(inaddr, i, inaddr2, j);
        }

        public Socket createSocket(InetAddress inaddr, int i) throws IOException {
            return this.factory.createSocket(inaddr, i);
        }

        public Socket createSocket(String s, int i, InetAddress inaddr, int j) throws IOException {
            return this.factory.createSocket(s, i, inaddr, j);
        }

        public Socket createSocket(String s, int i) throws IOException {
            return this.factory.createSocket(s, i);
        }

        public String[] getDefaultCipherSuites() {
            return this.factory.getSupportedCipherSuites();
        }

        public String[] getSupportedCipherSuites() {
            return this.factory.getSupportedCipherSuites();
        }
    }
}

