/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

public final class SmackConfiguration {
    private static final String SMACK_VERSION = "1.5.0";
    private static int packetReplyTimeout = 5000;
    private static int keepAliveInterval = 30000;

    private SmackConfiguration() {
    }

    public static String getVersion() {
        return SMACK_VERSION;
    }

    public static int getPacketReplyTimeout() {
        if (packetReplyTimeout <= 0) {
            packetReplyTimeout = 5000;
        }
        return packetReplyTimeout;
    }

    public static void setPacketReplyTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException();
        }
        packetReplyTimeout = timeout;
    }

    public static int getKeepAliveInterval() {
        return keepAliveInterval;
    }

    public static void setKeepAliveInterval(int interval) {
        keepAliveInterval = interval;
    }

    private static void parseClassToLoad(XmlPullParser parser) throws Exception {
        String className = parser.nextText();
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("Error! A startup class specified in smack-config.xml could not be loaded: " + className);
        }
    }

    private static int parseIntProperty(XmlPullParser parser, int defaultValue) throws Exception {
        try {
            return Integer.parseInt(parser.nextText());
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            return defaultValue;
        }
    }

    private static ClassLoader[] getClassLoaders() {
        ClassLoader[] classLoaders = new ClassLoader[]{new SmackConfiguration().getClass().getClassLoader(), Thread.currentThread().getContextClassLoader()};
        return classLoaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            ClassLoader[] classLoaders = SmackConfiguration.getClassLoaders();
            for (int i = 0; i < classLoaders.length; ++i) {
                Enumeration<URL> configEnum = classLoaders[i].getResources("META-INF/smack-config.xml");
                while (configEnum.hasMoreElements()) {
                    URL url = configEnum.nextElement();
                    InputStream systemStream = null;
                    try {
                        systemStream = url.openStream();
                        MXParser parser = new MXParser();
                        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                        parser.setInput(systemStream, "UTF-8");
                        int eventType = parser.getEventType();
                        do {
                            if (eventType != 2) continue;
                            if (parser.getName().equals("className")) {
                                SmackConfiguration.parseClassToLoad(parser);
                                continue;
                            }
                            if (parser.getName().equals("packetReplyTimeout")) {
                                packetReplyTimeout = SmackConfiguration.parseIntProperty(parser, packetReplyTimeout);
                                continue;
                            }
                            if (!parser.getName().equals("keepAliveInterval")) continue;
                            keepAliveInterval = SmackConfiguration.parseIntProperty(parser, keepAliveInterval);
                        } while ((eventType = parser.next()) != 1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            systemStream.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

