/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.etherscan;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import live.lingting.virtual.currency.core.Contract;
import live.lingting.virtual.currency.core.PlatformService;
import live.lingting.virtual.currency.core.enums.TransactionStatus;
import live.lingting.virtual.currency.core.enums.VirtualCurrencyPlatform;
import live.lingting.virtual.currency.core.exception.AbiMethodNotSupportException;
import live.lingting.virtual.currency.core.jsonrpc.JsonRpcException;
import live.lingting.virtual.currency.core.jsonrpc.http.HttpJsonRpc;
import live.lingting.virtual.currency.core.model.Account;
import live.lingting.virtual.currency.core.model.TransactionGenerate;
import live.lingting.virtual.currency.core.model.TransactionInfo;
import live.lingting.virtual.currency.core.model.TransferParams;
import live.lingting.virtual.currency.core.model.TransferResult;
import live.lingting.virtual.currency.core.util.AbiUtils;
import live.lingting.virtual.currency.etherscan.EtherscanTransactionGenerate;
import live.lingting.virtual.currency.etherscan.contract.EtherscanContract;
import live.lingting.virtual.currency.etherscan.enums.EtherscanReceiptStatus;
import live.lingting.virtual.currency.etherscan.model.Balance;
import live.lingting.virtual.currency.etherscan.model.Block;
import live.lingting.virtual.currency.etherscan.model.BlockEnum;
import live.lingting.virtual.currency.etherscan.model.EtherscanTransaction;
import live.lingting.virtual.currency.etherscan.model.Input;
import live.lingting.virtual.currency.etherscan.model.TransactionByHash;
import live.lingting.virtual.currency.etherscan.model.TransactionReceipt;
import live.lingting.virtual.currency.etherscan.properties.EtherscanProperties;
import live.lingting.virtual.currency.etherscan.util.EtherscanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.FunctionReturnDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.Keys;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.utils.Numeric;

public class EtherscanServiceImpl
implements PlatformService<EtherscanTransactionGenerate> {
    private static final Logger log = LoggerFactory.getLogger(EtherscanServiceImpl.class);
    private static final String EMPTY_ADDRESS = "0x0000000000000000000000000000000000000000";
    private static final Map<String, Integer> CONTRACT_DECIMAL_CACHE = new ConcurrentHashMap<String, Integer>();
    private final EtherscanProperties properties;
    private final HttpJsonRpc client;

    public EtherscanServiceImpl(EtherscanProperties properties) {
        this.properties = properties;
        this.client = properties.getHttpClient();
    }

    public Optional<TransactionInfo> getTransactionByHash(String hash) throws JsonRpcException, AbiMethodNotSupportException {
        TransactionByHash byHash = TransactionByHash.of(this.client, hash);
        if (byHash == null || byHash.getCode() != null) {
            return Optional.empty();
        }
        EtherscanContract contract = EtherscanContract.getByHash(byHash.getTo());
        String contractAddress = contract == null ? byHash.getTo() : contract.getHash();
        Input input = "0x".equals(byHash.getInput()) ? new Input().setTo(byHash.getTo()).setValue(EtherscanUtils.toBigInteger(byHash.getValue())).setContract(EtherscanContract.ETH) : EtherscanUtils.resolve(byHash.getInput());
        if (input.getContract() != null) {
            contract = input.getContract();
            contractAddress = contract.getHash();
        }
        if (contract == null) {
            contract = AbiUtils.createContract((String)contractAddress);
        }
        TransactionInfo transactionInfo = new TransactionInfo().setVirtualCurrencyPlatform(VirtualCurrencyPlatform.ETHERSCAN).setHash(byHash.getHash()).setFrom(StrUtil.isNotBlank((CharSequence)input.getFrom()) ? input.getFrom() : byHash.getFrom()).setTo(input.getTo()).setContract((Contract)contract).setValue(this.getNumberByBalanceAndContract(input.getValue(), contract, MathContext.UNLIMITED));
        if (byHash.getBlockNumber() == null) {
            return Optional.of(transactionInfo.setStatus(TransactionStatus.WAIT));
        }
        transactionInfo.setBlock(EtherscanUtils.toBigInteger(byHash.getBlockNumber()));
        TransactionReceipt receipt = TransactionReceipt.of(this.client, hash);
        if (receipt == null) {
            transactionInfo.setStatus(TransactionStatus.WAIT);
        } else if (receipt.getCode() != null || !EtherscanReceiptStatus.SUCCESS.getValue().equals(receipt.getStatus())) {
            transactionInfo.setStatus(TransactionStatus.FAIL);
        } else {
            transactionInfo.setStatus(TransactionStatus.SUCCESS);
        }
        Block block = Block.of(this.client, byHash.getBlockHash());
        return Optional.of(transactionInfo.setTime(EtherscanUtils.toBigInteger(block.getTimestamp()).longValue()));
    }

    public Integer getDecimalsByContract(Contract contract) throws JsonRpcException {
        if (contract == null) {
            return 0;
        }
        if (contract.getDecimals() != null) {
            return contract.getDecimals();
        }
        if (CONTRACT_DECIMAL_CACHE.containsKey(contract.getHash())) {
            return CONTRACT_DECIMAL_CACHE.get(contract.getHash());
        }
        Integer decimals = 0;
        List<Type> types = this.ethCall("decimals", new ArrayList<Type>(0), ListUtil.toList((Object[])new TypeReference[]{new TypeReference<Uint8>(){}}), EMPTY_ADDRESS, contract.getHash());
        if (!CollectionUtil.isEmpty(types)) {
            decimals = Convert.toInt((Object)types.get(0).getValue().toString(), (Integer)0);
        }
        CONTRACT_DECIMAL_CACHE.put(contract.getHash(), decimals);
        return decimals;
    }

    public BigInteger getBalanceByAddressAndContract(String address, Contract contract) throws JsonRpcException {
        if (contract == EtherscanContract.ETH) {
            return EtherscanUtils.toBigInteger((String)this.client.invoke("eth_getBalance", String.class, new Object[]{address, BlockEnum.LATEST.getVal()}));
        }
        List<Type> list = this.ethCall("balanceOf", ListUtil.toList((Object[])new Type[]{new Address(address)}), ListUtil.toList((Object[])new TypeReference[]{new TypeReference<Uint256>(){}}), address, contract.getHash());
        if (!CollectionUtil.isEmpty(list)) {
            return new BigInteger(list.get(0).getValue().toString());
        }
        return BigInteger.ZERO;
    }

    public BigDecimal getNumberByBalanceAndContract(BigInteger balance, Contract contract, MathContext mathContext) throws JsonRpcException {
        if (contract == null) {
            return new BigDecimal(balance);
        }
        if (balance == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(balance).divide(BigDecimal.TEN.pow(this.getDecimalsByContract(contract)), mathContext);
    }

    public EtherscanTransactionGenerate transactionGenerate(Account from, String to, Contract contract, BigDecimal value, TransferParams params) throws Exception {
        RawTransaction rawTransaction;
        if (value.compareTo(BigDecimal.ZERO) <= 0) {
            return EtherscanTransactionGenerate.failed("\u8f6c\u8d26\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0!");
        }
        if (!EtherscanUtils.addStart(Keys.getAddress((String)from.getPublicKey())).equals(from.getAddress())) {
            return EtherscanTransactionGenerate.failed("\u7531\u516c\u94a5\u63a8\u5bfc\u51fa\u7684\u5730\u5740\u4e0e\u4f20\u5165\u5730\u5740\u4e0d\u7b26!");
        }
        BigInteger amount = this.valueToBalanceByContract(value, contract);
        BigInteger nonce = EtherscanUtils.toBigInteger((String)this.client.invoke("eth_getTransactionCount", String.class, new Object[]{from.getAddress(), BlockEnum.PENDING.getVal()}));
        BigInteger gasPrice = params.getGasPrice();
        BigInteger gasLimit = params.getGasLimit();
        if (gasPrice == null) {
            gasPrice = EtherscanUtils.toBigInteger((String)this.client.invoke("eth_gasPrice", String.class, new Object[0]));
        }
        if (gasLimit == null) {
            gasLimit = EtherscanUtils.toBigInteger(Block.of(this.client, BlockEnum.PENDING).getGasLimit());
        }
        if (contract == EtherscanContract.ETH) {
            rawTransaction = RawTransaction.createEtherTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)to, (BigInteger)amount);
        } else {
            Function function = new Function("transfer", Arrays.asList(new Address(to), new Uint256(amount)), Collections.emptyList());
            String fData = FunctionEncoder.encode((Function)function);
            rawTransaction = RawTransaction.createTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)contract.getHash(), (String)fData);
        }
        return EtherscanTransactionGenerate.success(from, to, amount, contract, new EtherscanTransactionGenerate.Etherscan(nonce, gasPrice, gasLimit, rawTransaction));
    }

    public EtherscanTransactionGenerate transactionSign(EtherscanTransactionGenerate generate) {
        boolean error;
        boolean bl = error = generate.getSuccess() == false;
        if (error) {
            return generate;
        }
        Credentials credentials = Credentials.create((String)generate.getFrom().getPrivateKey(), (String)generate.getFrom().getPublicKey());
        byte[] sign = TransactionEncoder.signMessage((RawTransaction)generate.getEtherscan().getRawTransaction(), (Credentials)credentials);
        String hex = Numeric.toHexString((byte[])sign);
        generate.setSignHex(hex);
        return generate;
    }

    public TransferResult transactionBroadcast(EtherscanTransactionGenerate generate) throws JsonRpcException {
        boolean error;
        boolean bl = error = generate.getSuccess() == false;
        if (error) {
            String hash = (String)this.client.invoke("eth_sendRawTransaction", String.class, new Object[]{generate.getSignHex()});
            return TransferResult.success((String)hash);
        }
        return TransferResult.failed((TransactionGenerate)generate);
    }

    public boolean validate(String address) {
        Balance of = Balance.of(this.client, address);
        return of.getAmount() != null;
    }

    private List<Type> ethCall(String method, List<Type> input, List<TypeReference<?>> out, String from, String to) throws JsonRpcException {
        return this.ethCall(method, input, out, from, to, BlockEnum.LATEST.getVal());
    }

    private List<Type> ethCall(String method, List<Type> input, List<TypeReference<?>> out, String from, String to, String block) throws JsonRpcException {
        Assert.notNull(input);
        Assert.notNull(out);
        Function function = new Function(method, input, out);
        String data = FunctionEncoder.encode((Function)function);
        EtherscanTransaction transaction = EtherscanTransaction.of(from, to, data);
        String call = (String)this.client.invoke("eth_call", String.class, new Object[]{transaction, BlockEnum.LATEST.getVal()});
        return FunctionReturnDecoder.decode((String)call, (List)function.getOutputParameters());
    }

    public static Map<String, Integer> getCONTRACT_DECIMAL_CACHE() {
        return CONTRACT_DECIMAL_CACHE;
    }
}

