/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.etherscan;

import java.math.BigInteger;
import live.lingting.virtual.currency.core.Contract;
import live.lingting.virtual.currency.core.model.Account;
import live.lingting.virtual.currency.core.model.TransactionGenerate;
import org.web3j.crypto.RawTransaction;

public class EtherscanTransactionGenerate
extends TransactionGenerate {
    private Etherscan etherscan;

    public static EtherscanTransactionGenerate failed(String message) {
        EtherscanTransactionGenerate generate = new EtherscanTransactionGenerate();
        generate.setSuccess(false).setMessage(message);
        return generate;
    }

    public static EtherscanTransactionGenerate failed(Throwable e) {
        EtherscanTransactionGenerate generate = new EtherscanTransactionGenerate();
        generate.setSuccess(false).setMessage(e.getMessage()).setException(e);
        return generate;
    }

    private static EtherscanTransactionGenerate success(Account from, String to, BigInteger amount, Contract contract) {
        EtherscanTransactionGenerate generate = new EtherscanTransactionGenerate();
        generate.setSuccess(true).setContract(contract).setFrom(from).setTo(to).setAmount(amount);
        return generate;
    }

    public static EtherscanTransactionGenerate success(Account from, String to, BigInteger amount, Contract contract, Etherscan data) {
        return EtherscanTransactionGenerate.success(from, to, amount, contract).setEtherscan(data);
    }

    public Etherscan getEtherscan() {
        return this.etherscan;
    }

    public EtherscanTransactionGenerate setEtherscan(Etherscan etherscan) {
        this.etherscan = etherscan;
        return this;
    }

    public static class Etherscan {
        BigInteger nonce;
        BigInteger gasPrice;
        BigInteger gasLimit;
        RawTransaction rawTransaction;

        public BigInteger getNonce() {
            return this.nonce;
        }

        public BigInteger getGasPrice() {
            return this.gasPrice;
        }

        public BigInteger getGasLimit() {
            return this.gasLimit;
        }

        public RawTransaction getRawTransaction() {
            return this.rawTransaction;
        }

        public Etherscan setNonce(BigInteger nonce) {
            this.nonce = nonce;
            return this;
        }

        public Etherscan setGasPrice(BigInteger gasPrice) {
            this.gasPrice = gasPrice;
            return this;
        }

        public Etherscan setGasLimit(BigInteger gasLimit) {
            this.gasLimit = gasLimit;
            return this;
        }

        public Etherscan setRawTransaction(RawTransaction rawTransaction) {
            this.rawTransaction = rawTransaction;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Etherscan)) {
                return false;
            }
            Etherscan other = (Etherscan)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigInteger this$nonce = this.getNonce();
            BigInteger other$nonce = other.getNonce();
            if (this$nonce == null ? other$nonce != null : !((Object)this$nonce).equals(other$nonce)) {
                return false;
            }
            BigInteger this$gasPrice = this.getGasPrice();
            BigInteger other$gasPrice = other.getGasPrice();
            if (this$gasPrice == null ? other$gasPrice != null : !((Object)this$gasPrice).equals(other$gasPrice)) {
                return false;
            }
            BigInteger this$gasLimit = this.getGasLimit();
            BigInteger other$gasLimit = other.getGasLimit();
            if (this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit)) {
                return false;
            }
            RawTransaction this$rawTransaction = this.getRawTransaction();
            RawTransaction other$rawTransaction = other.getRawTransaction();
            return !(this$rawTransaction == null ? other$rawTransaction != null : !this$rawTransaction.equals(other$rawTransaction));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Etherscan;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigInteger $nonce = this.getNonce();
            result = result * 59 + ($nonce == null ? 43 : ((Object)$nonce).hashCode());
            BigInteger $gasPrice = this.getGasPrice();
            result = result * 59 + ($gasPrice == null ? 43 : ((Object)$gasPrice).hashCode());
            BigInteger $gasLimit = this.getGasLimit();
            result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
            RawTransaction $rawTransaction = this.getRawTransaction();
            result = result * 59 + ($rawTransaction == null ? 43 : $rawTransaction.hashCode());
            return result;
        }

        public String toString() {
            return "EtherscanTransactionGenerate.Etherscan(nonce=" + this.getNonce() + ", gasPrice=" + this.getGasPrice() + ", gasLimit=" + this.getGasLimit() + ", rawTransaction=" + this.getRawTransaction() + ")";
        }

        public Etherscan() {
        }

        public Etherscan(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, RawTransaction rawTransaction) {
            this.nonce = nonce;
            this.gasPrice = gasPrice;
            this.gasLimit = gasLimit;
            this.rawTransaction = rawTransaction;
        }
    }
}

