/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.etherscan.model;

import java.math.BigInteger;
import live.lingting.virtual.currency.core.jsonrpc.JsonRpcException;
import live.lingting.virtual.currency.core.jsonrpc.http.HttpJsonRpc;
import live.lingting.virtual.currency.etherscan.model.BaseResponse;
import live.lingting.virtual.currency.etherscan.model.BlockEnum;
import live.lingting.virtual.currency.etherscan.util.EtherscanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Balance
extends BaseResponse {
    private static final Logger log = LoggerFactory.getLogger(Balance.class);
    private BigInteger amount;

    public static Balance of(HttpJsonRpc client, String address) {
        Balance res = new Balance();
        try {
            res.setAmount(EtherscanUtils.toBigInteger((String)client.invoke("eth_getBalance", String.class, new Object[]{address, BlockEnum.LATEST.getVal()})));
        }
        catch (JsonRpcException e) {
            log.error("\u4f59\u989d\u89e3\u6790\u5f02\u5e38!", (Throwable)e);
            res.setMessage(e.getMessage());
            res.setCode(e.getCode());
        }
        return res;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }
}

