/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.etherscan.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigInteger;
import live.lingting.virtual.currency.etherscan.util.EtherscanUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EtherscanTransaction {
    private String from;
    private String to;
    private String gas;
    private String gasPrice;
    private String value;
    private String data;
    private String nonce;
    private String gasPremium;
    private String feeCap;

    public static EtherscanTransaction of(String from, String to, String data) {
        return new EtherscanTransaction().setFrom(from).setTo(to).setData(data);
    }

    public static EtherscanTransaction of(String from, BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data) {
        return new EtherscanTransaction().setFrom(from).setTo(to).setNonce(nonce.toString()).setGas(EtherscanUtils.addStart(gasLimit.toString())).setGasPrice(EtherscanUtils.addStart(gasPrice.toString())).setValue(EtherscanUtils.addStart(value.toString(16))).setData(data);
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getGas() {
        return this.gas;
    }

    public String getGasPrice() {
        return this.gasPrice;
    }

    public String getValue() {
        return this.value;
    }

    public String getData() {
        return this.data;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getGasPremium() {
        return this.gasPremium;
    }

    public String getFeeCap() {
        return this.feeCap;
    }

    public EtherscanTransaction setFrom(String from) {
        this.from = from;
        return this;
    }

    public EtherscanTransaction setTo(String to) {
        this.to = to;
        return this;
    }

    public EtherscanTransaction setGas(String gas) {
        this.gas = gas;
        return this;
    }

    public EtherscanTransaction setGasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
        return this;
    }

    public EtherscanTransaction setValue(String value) {
        this.value = value;
        return this;
    }

    public EtherscanTransaction setData(String data) {
        this.data = data;
        return this;
    }

    public EtherscanTransaction setNonce(String nonce) {
        this.nonce = nonce;
        return this;
    }

    public EtherscanTransaction setGasPremium(String gasPremium) {
        this.gasPremium = gasPremium;
        return this;
    }

    public EtherscanTransaction setFeeCap(String feeCap) {
        this.feeCap = feeCap;
        return this;
    }

    private EtherscanTransaction() {
    }

    private EtherscanTransaction(String from, String to, String gas, String gasPrice, String value, String data, String nonce, String gasPremium, String feeCap) {
        this.from = from;
        this.to = to;
        this.gas = gas;
        this.gasPrice = gasPrice;
        this.value = value;
        this.data = data;
        this.nonce = nonce;
        this.gasPremium = gasPremium;
        this.feeCap = feeCap;
    }
}

