/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.etherscan.model;

import java.math.BigInteger;
import live.lingting.virtual.currency.core.enums.AbiMethod;
import live.lingting.virtual.currency.etherscan.contract.EtherscanContract;
import live.lingting.virtual.currency.etherscan.util.EtherscanUtils;

public class Input {
    private AbiMethod method;
    private String data;
    private String to;
    private String from;
    private BigInteger value;
    private EtherscanContract contract;
    private String contractAddress;

    public Input setTo(String to) {
        this.to = to.startsWith("0x") ? to : EtherscanUtils.decodeAddressParam(to);
        return this;
    }

    public Input setFrom(String from) {
        this.from = from.startsWith("0x") ? from : EtherscanUtils.decodeAddressParam(this.to);
        return this;
    }

    public AbiMethod getMethod() {
        return this.method;
    }

    public String getData() {
        return this.data;
    }

    public String getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public EtherscanContract getContract() {
        return this.contract;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public Input setMethod(AbiMethod method) {
        this.method = method;
        return this;
    }

    public Input setData(String data) {
        this.data = data;
        return this;
    }

    public Input setValue(BigInteger value) {
        this.value = value;
        return this;
    }

    public Input setContract(EtherscanContract contract) {
        this.contract = contract;
        return this;
    }

    public Input setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Input)) {
            return false;
        }
        Input other = (Input)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AbiMethod this$method = this.getMethod();
        AbiMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        BigInteger this$value = this.getValue();
        BigInteger other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        EtherscanContract this$contract = this.getContract();
        EtherscanContract other$contract = other.getContract();
        if (this$contract == null ? other$contract != null : !((Object)((Object)this$contract)).equals((Object)other$contract)) {
            return false;
        }
        String this$contractAddress = this.getContractAddress();
        String other$contractAddress = other.getContractAddress();
        return !(this$contractAddress == null ? other$contractAddress != null : !this$contractAddress.equals(other$contractAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Input;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AbiMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        BigInteger $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        EtherscanContract $contract = this.getContract();
        result = result * 59 + ($contract == null ? 43 : ((Object)((Object)$contract)).hashCode());
        String $contractAddress = this.getContractAddress();
        result = result * 59 + ($contractAddress == null ? 43 : $contractAddress.hashCode());
        return result;
    }

    public String toString() {
        return "Input(method=" + this.getMethod() + ", data=" + this.getData() + ", to=" + this.getTo() + ", from=" + this.getFrom() + ", value=" + this.getValue() + ", contract=" + (Object)((Object)this.getContract()) + ", contractAddress=" + this.getContractAddress() + ")";
    }
}

