/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.etherscan.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import live.lingting.virtual.currency.core.jsonrpc.JsonRpcException;
import live.lingting.virtual.currency.core.jsonrpc.http.HttpJsonRpc;
import live.lingting.virtual.currency.etherscan.model.BaseResponse;

public class TransactionReceipt
extends BaseResponse {
    @JsonProperty(value="blockHash")
    private String blockHash;
    @JsonProperty(value="blockNumber")
    private String blockNumber;
    @JsonProperty(value="contractAddress")
    private String contractAddress;
    @JsonProperty(value="cumulativeGasUsed")
    private String cumulativeGasUsed;
    @JsonProperty(value="from")
    private String from;
    @JsonProperty(value="gasUsed")
    private String gasUsed;
    @JsonProperty(value="logsBloom")
    private String logsBloom;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="to")
    private String to;
    @JsonProperty(value="transactionHash")
    private String transactionHash;
    @JsonProperty(value="transactionIndex")
    private String transactionIndex;
    @JsonProperty(value="logs")
    private List<Log> logs;

    public static TransactionReceipt of(HttpJsonRpc client, String hash) throws JsonRpcException {
        return (TransactionReceipt)client.invoke("eth_getTransactionReceipt", TransactionReceipt.class, new Object[]{hash});
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public String getBlockNumber() {
        return this.blockNumber;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public String getCumulativeGasUsed() {
        return this.cumulativeGasUsed;
    }

    public String getFrom() {
        return this.from;
    }

    public String getGasUsed() {
        return this.gasUsed;
    }

    public String getLogsBloom() {
        return this.logsBloom;
    }

    public String getStatus() {
        return this.status;
    }

    public String getTo() {
        return this.to;
    }

    public String getTransactionHash() {
        return this.transactionHash;
    }

    public String getTransactionIndex() {
        return this.transactionIndex;
    }

    public List<Log> getLogs() {
        return this.logs;
    }

    @JsonProperty(value="blockHash")
    public void setBlockHash(String blockHash) {
        this.blockHash = blockHash;
    }

    @JsonProperty(value="blockNumber")
    public void setBlockNumber(String blockNumber) {
        this.blockNumber = blockNumber;
    }

    @JsonProperty(value="contractAddress")
    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    @JsonProperty(value="cumulativeGasUsed")
    public void setCumulativeGasUsed(String cumulativeGasUsed) {
        this.cumulativeGasUsed = cumulativeGasUsed;
    }

    @JsonProperty(value="from")
    public void setFrom(String from) {
        this.from = from;
    }

    @JsonProperty(value="gasUsed")
    public void setGasUsed(String gasUsed) {
        this.gasUsed = gasUsed;
    }

    @JsonProperty(value="logsBloom")
    public void setLogsBloom(String logsBloom) {
        this.logsBloom = logsBloom;
    }

    @JsonProperty(value="status")
    public void setStatus(String status) {
        this.status = status;
    }

    @JsonProperty(value="to")
    public void setTo(String to) {
        this.to = to;
    }

    @JsonProperty(value="transactionHash")
    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    @JsonProperty(value="transactionIndex")
    public void setTransactionIndex(String transactionIndex) {
        this.transactionIndex = transactionIndex;
    }

    @JsonProperty(value="logs")
    public void setLogs(List<Log> logs) {
        this.logs = logs;
    }

    public static class Log {
        @JsonProperty(value="address")
        private String address;
        @JsonProperty(value="blockHash")
        private String blockHash;
        @JsonProperty(value="blockNumber")
        private String blockNumber;
        @JsonProperty(value="data")
        private String data;
        @JsonProperty(value="logIndex")
        private String logIndex;
        @JsonProperty(value="removed")
        private Boolean removed;
        @JsonProperty(value="transactionHash")
        private String transactionHash;
        @JsonProperty(value="transactionIndex")
        private String transactionIndex;
        @JsonProperty(value="topics")
        private List<String> topics;

        public String getAddress() {
            return this.address;
        }

        public String getBlockHash() {
            return this.blockHash;
        }

        public String getBlockNumber() {
            return this.blockNumber;
        }

        public String getData() {
            return this.data;
        }

        public String getLogIndex() {
            return this.logIndex;
        }

        public Boolean getRemoved() {
            return this.removed;
        }

        public String getTransactionHash() {
            return this.transactionHash;
        }

        public String getTransactionIndex() {
            return this.transactionIndex;
        }

        public List<String> getTopics() {
            return this.topics;
        }

        @JsonProperty(value="address")
        public void setAddress(String address) {
            this.address = address;
        }

        @JsonProperty(value="blockHash")
        public void setBlockHash(String blockHash) {
            this.blockHash = blockHash;
        }

        @JsonProperty(value="blockNumber")
        public void setBlockNumber(String blockNumber) {
            this.blockNumber = blockNumber;
        }

        @JsonProperty(value="data")
        public void setData(String data) {
            this.data = data;
        }

        @JsonProperty(value="logIndex")
        public void setLogIndex(String logIndex) {
            this.logIndex = logIndex;
        }

        @JsonProperty(value="removed")
        public void setRemoved(Boolean removed) {
            this.removed = removed;
        }

        @JsonProperty(value="transactionHash")
        public void setTransactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
        }

        @JsonProperty(value="transactionIndex")
        public void setTransactionIndex(String transactionIndex) {
            this.transactionIndex = transactionIndex;
        }

        @JsonProperty(value="topics")
        public void setTopics(List<String> topics) {
            this.topics = topics;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Log)) {
                return false;
            }
            Log other = (Log)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            String this$blockHash = this.getBlockHash();
            String other$blockHash = other.getBlockHash();
            if (this$blockHash == null ? other$blockHash != null : !this$blockHash.equals(other$blockHash)) {
                return false;
            }
            String this$blockNumber = this.getBlockNumber();
            String other$blockNumber = other.getBlockNumber();
            if (this$blockNumber == null ? other$blockNumber != null : !this$blockNumber.equals(other$blockNumber)) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            String this$logIndex = this.getLogIndex();
            String other$logIndex = other.getLogIndex();
            if (this$logIndex == null ? other$logIndex != null : !this$logIndex.equals(other$logIndex)) {
                return false;
            }
            Boolean this$removed = this.getRemoved();
            Boolean other$removed = other.getRemoved();
            if (this$removed == null ? other$removed != null : !((Object)this$removed).equals(other$removed)) {
                return false;
            }
            String this$transactionHash = this.getTransactionHash();
            String other$transactionHash = other.getTransactionHash();
            if (this$transactionHash == null ? other$transactionHash != null : !this$transactionHash.equals(other$transactionHash)) {
                return false;
            }
            String this$transactionIndex = this.getTransactionIndex();
            String other$transactionIndex = other.getTransactionIndex();
            if (this$transactionIndex == null ? other$transactionIndex != null : !this$transactionIndex.equals(other$transactionIndex)) {
                return false;
            }
            List<String> this$topics = this.getTopics();
            List<String> other$topics = other.getTopics();
            return !(this$topics == null ? other$topics != null : !((Object)this$topics).equals(other$topics));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Log;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            String $blockHash = this.getBlockHash();
            result = result * 59 + ($blockHash == null ? 43 : $blockHash.hashCode());
            String $blockNumber = this.getBlockNumber();
            result = result * 59 + ($blockNumber == null ? 43 : $blockNumber.hashCode());
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            String $logIndex = this.getLogIndex();
            result = result * 59 + ($logIndex == null ? 43 : $logIndex.hashCode());
            Boolean $removed = this.getRemoved();
            result = result * 59 + ($removed == null ? 43 : ((Object)$removed).hashCode());
            String $transactionHash = this.getTransactionHash();
            result = result * 59 + ($transactionHash == null ? 43 : $transactionHash.hashCode());
            String $transactionIndex = this.getTransactionIndex();
            result = result * 59 + ($transactionIndex == null ? 43 : $transactionIndex.hashCode());
            List<String> $topics = this.getTopics();
            result = result * 59 + ($topics == null ? 43 : ((Object)$topics).hashCode());
            return result;
        }

        public String toString() {
            return "TransactionReceipt.Log(address=" + this.getAddress() + ", blockHash=" + this.getBlockHash() + ", blockNumber=" + this.getBlockNumber() + ", data=" + this.getData() + ", logIndex=" + this.getLogIndex() + ", removed=" + this.getRemoved() + ", transactionHash=" + this.getTransactionHash() + ", transactionIndex=" + this.getTransactionIndex() + ", topics=" + this.getTopics() + ")";
        }
    }
}

