/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.etherscan.util;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import live.lingting.virtual.currency.core.enums.AbiMethod;
import live.lingting.virtual.currency.core.exception.AbiMethodNotSupportException;
import live.lingting.virtual.currency.core.model.Account;
import live.lingting.virtual.currency.core.util.AbiUtils;
import live.lingting.virtual.currency.etherscan.contract.EtherscanContract;
import live.lingting.virtual.currency.etherscan.model.Input;
import org.bitcoinj.crypto.DeterministicKey;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Keys;

public class EtherscanUtils {
    public static final String START = "0x";
    private static final Map<String, Consumer<Input>> METHOD_HANDLER = new ConcurrentHashMap<String, Consumer<Input>>(AbiMethod.values().length);

    private static String[] dataToArray(AbiMethod method, String data) {
        return AbiUtils.stringToArrayBy64((String)(START + method.getMethodId()), (String)data);
    }

    public static Input resolve(String inputString) throws AbiMethodNotSupportException {
        String methodId = inputString.substring(2, 10);
        Input input = new Input().setMethod(AbiMethod.getById((String)methodId)).setData(inputString);
        if (!METHOD_HANDLER.containsKey(methodId)) {
            throw new AbiMethodNotSupportException(methodId);
        }
        METHOD_HANDLER.get(methodId).accept(input);
        return input;
    }

    public static Account createAccount() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        return EtherscanUtils.createAccount(Keys.createEcKeyPair());
    }

    public static Account createAccount(ECKeyPair keyPair) {
        String privateKey = EtherscanUtils.keyDeserialization(keyPair.getPrivateKey());
        String publicKey = EtherscanUtils.keyDeserialization(keyPair.getPublicKey());
        String address = EtherscanUtils.addStart(Keys.getAddress((ECKeyPair)keyPair));
        return new Account(address, publicKey, privateKey);
    }

    public static Account createAccount(DeterministicKey key) {
        return EtherscanUtils.createAccount(ECKeyPair.create((byte[])key.getPrivKeyBytes()));
    }

    public static Account getAccountOfKey(String address, String privateKey) {
        return EtherscanUtils.getAccountOfKey(address, null, privateKey);
    }

    public static Account getAccountOfKey(String address, String publicKey, String privateKey) {
        address = EtherscanUtils.addStart(address);
        Assert.isFalse((boolean)StrUtil.isBlank((CharSequence)address));
        Assert.isFalse((boolean)StrUtil.isBlank((CharSequence)privateKey));
        Account account = new Account(address, publicKey, privateKey);
        if (StrUtil.isBlank((CharSequence)publicKey)) {
            ECKeyPair keyPair = ECKeyPair.create((BigInteger)EtherscanUtils.keySerialization(privateKey));
            publicKey = EtherscanUtils.keyDeserialization(keyPair.getPublicKey());
        }
        account.setPublicKey(publicKey);
        return account;
    }

    public static BigInteger toBigInteger(String str) {
        return new BigInteger(EtherscanUtils.removeStart(str), 16);
    }

    public static String removeStart(String str) {
        if (str.startsWith(START)) {
            str = str.substring(START.length());
        }
        return str;
    }

    public static String addStart(String str) {
        if (!str.startsWith(START)) {
            str = START + str;
        }
        return str;
    }

    public static BigInteger keySerialization(String key) {
        return new BigInteger(key, 16);
    }

    public static String keyDeserialization(BigInteger key) {
        return key.toString(16);
    }

    public static String decodeAddressParam(String param) {
        String address = AbiUtils.removePreZero((String)param);
        if (address.length() < 40) {
            address = StrUtil.padPre((CharSequence)address, (int)40, (CharSequence)"0");
        }
        return START + address;
    }

    static {
        METHOD_HANDLER.put(AbiMethod.TRANSFER.getMethodId(), input -> {
            String[] array = EtherscanUtils.dataToArray(AbiMethod.TRANSFER, input.getData());
            input.setTo(array[0]);
            input.setValue(new BigInteger(array[1], 16));
        });
        METHOD_HANDLER.put(AbiMethod.SEND_MULTI_SIG_TOKEN.getMethodId(), input -> {
            String[] array = EtherscanUtils.dataToArray(AbiMethod.SEND_MULTI_SIG_TOKEN, input.getData());
            input.setTo(array[0]);
            input.setValue(new BigInteger(array[1], 16));
            String address = EtherscanUtils.decodeAddressParam(array[2]);
            input.setContract(EtherscanContract.getByHash(address));
            input.setContractAddress(address);
        });
        METHOD_HANDLER.put(AbiMethod.SEND_MULTI_SIG.getMethodId(), input -> {
            String[] array = EtherscanUtils.dataToArray(AbiMethod.SEND_MULTI_SIG, input.getData());
            input.setTo(array[0]);
            input.setValue(new BigInteger(array[1], 16));
        });
        METHOD_HANDLER.put(AbiMethod.TRANSFER_FROM.getMethodId(), input -> {
            String[] array = EtherscanUtils.dataToArray(AbiMethod.TRANSFER_FROM, input.getData());
            input.setFrom(array[0]);
            input.setTo(array[1]);
            input.setValue(new BigInteger(array[2], 16));
        });
    }
}

