/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.codec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dreamlu.iot.mqtt.codec.properties.IntegerProperty;
import net.dreamlu.iot.mqtt.codec.properties.MqttProperty;
import net.dreamlu.iot.mqtt.codec.properties.MqttPropertyType;
import net.dreamlu.iot.mqtt.codec.properties.StringPair;
import net.dreamlu.iot.mqtt.codec.properties.UserProperties;
import net.dreamlu.iot.mqtt.codec.properties.UserProperty;

public final class MqttProperties {
    public static final MqttProperties NO_PROPERTIES = new MqttProperties(false);
    private Map<Integer, MqttProperty> props;
    private List<UserProperty> userProperties;
    private List<IntegerProperty> subscriptionIds;
    private final boolean canModify;

    static MqttProperties withEmptyDefaults(MqttProperties properties) {
        if (properties == null) {
            return NO_PROPERTIES;
        }
        return properties;
    }

    public MqttProperties() {
        this(true);
    }

    private MqttProperties(boolean canModify) {
        this.canModify = canModify;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(MqttProperty property) {
        if (!this.canModify) {
            throw new UnsupportedOperationException("adding property isn't allowed");
        }
        Map<Integer, MqttProperty> props = this.props;
        int propertyId = property.propertyId();
        if (propertyId == MqttPropertyType.USER_PROPERTY.value()) {
            List<UserProperty> userProperties = this.userProperties;
            if (userProperties == null) {
                this.userProperties = userProperties = new ArrayList<UserProperty>(1);
            }
            if (property instanceof UserProperty) {
                userProperties.add((UserProperty)property);
                return;
            } else {
                if (!(property instanceof UserProperties)) throw new IllegalArgumentException("User property must be of UserProperty or UserProperties type");
                for (StringPair pair : (List)((UserProperties)property).value()) {
                    userProperties.add(new UserProperty(pair.key, pair.value));
                }
            }
            return;
        } else if (propertyId == MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value()) {
            List<IntegerProperty> subscriptionIds = this.subscriptionIds;
            if (subscriptionIds == null) {
                this.subscriptionIds = subscriptionIds = new ArrayList<IntegerProperty>(1);
            }
            if (!(property instanceof IntegerProperty)) throw new IllegalArgumentException("Subscription ID must be an integer property");
            subscriptionIds.add((IntegerProperty)property);
            return;
        } else {
            if (props == null) {
                this.props = props = new HashMap<Integer, MqttProperty>();
            }
            props.put(propertyId, property);
        }
    }

    public Collection<? extends MqttProperty> listAll() {
        Map<Integer, MqttProperty> props = this.props;
        if (props == null && this.subscriptionIds == null && this.userProperties == null) {
            return Collections.emptyList();
        }
        if (props == null && this.userProperties == null) {
            return this.subscriptionIds;
        }
        if (props == null && this.subscriptionIds == null) {
            return this.userProperties;
        }
        if (this.subscriptionIds == null && this.userProperties == null) {
            return props.values();
        }
        ArrayList<MqttProperty> propValues = new ArrayList<MqttProperty>(props != null ? props.size() : 1);
        if (props != null) {
            propValues.addAll(props.values());
        }
        if (this.subscriptionIds != null) {
            propValues.addAll(this.subscriptionIds);
        }
        if (this.userProperties != null) {
            propValues.add(UserProperties.fromUserPropertyCollection(this.userProperties));
        }
        return propValues;
    }

    public boolean isEmpty() {
        Map<Integer, MqttProperty> props = this.props;
        return props == null || props.isEmpty();
    }

    public MqttProperty getProperty(int propertyId) {
        if (MqttPropertyType.USER_PROPERTY.value() == propertyId) {
            List<UserProperty> userProperties = this.userProperties;
            if (userProperties == null) {
                return null;
            }
            return UserProperties.fromUserPropertyCollection(userProperties);
        }
        if (MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value() == propertyId) {
            List<IntegerProperty> subscriptionIds = this.subscriptionIds;
            if (subscriptionIds == null || subscriptionIds.isEmpty()) {
                return null;
            }
            return subscriptionIds.get(0);
        }
        Map<Integer, MqttProperty> props = this.props;
        return props == null ? null : props.get(propertyId);
    }

    public MqttProperty getProperty(MqttPropertyType mqttPropertyType) {
        return this.getProperty(mqttPropertyType.value());
    }

    public <T> T getPropertyValue(MqttPropertyType mqttPropertyType) {
        MqttProperty property = this.getProperty(mqttPropertyType.value());
        if (property == null) {
            return null;
        }
        return property.value();
    }

    public List<? extends MqttProperty> getProperties(int propertyId) {
        if (propertyId == MqttPropertyType.USER_PROPERTY.value()) {
            return this.userProperties == null ? Collections.emptyList() : this.userProperties;
        }
        if (propertyId == MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value()) {
            return this.subscriptionIds == null ? Collections.emptyList() : this.subscriptionIds;
        }
        Map<Integer, MqttProperty> props = this.props;
        return props == null || !props.containsKey(propertyId) ? Collections.emptyList() : Collections.singletonList(props.get(propertyId));
    }
}

