/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.codec;

public enum MqttQoS {
    QOS0(0),
    QOS1(1),
    QOS2(2),
    FAILURE(-128);

    private final byte value;

    private MqttQoS(byte value) {
        this.value = value;
    }

    public short value() {
        return (short)(this.value & 0xFF);
    }

    public static MqttQoS valueOf(int value) {
        switch (value) {
            case 0: {
                return QOS0;
            }
            case 1: {
                return QOS1;
            }
            case 2: {
                return QOS2;
            }
            case 128: {
                return FAILURE;
            }
        }
        throw new IllegalArgumentException("invalid QoS: " + value);
    }

    public String toString() {
        return "QoS" + this.value;
    }
}

