/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.codec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.dreamlu.iot.mqtt.codec.MqttQoS;

public class MqttSubAckPayload {
    private final List<Short> reasonCodes;

    public MqttSubAckPayload(short[] reasonCodes) {
        Objects.requireNonNull(reasonCodes, "reasonCodes is null.");
        ArrayList<Short> list = new ArrayList<Short>(reasonCodes.length);
        for (short v : reasonCodes) {
            list.add(v);
        }
        this.reasonCodes = Collections.unmodifiableList(list);
    }

    public MqttSubAckPayload(Iterable<Short> reasonCodes) {
        Objects.requireNonNull(reasonCodes, "reasonCodes is null.");
        ArrayList<Short> list = new ArrayList<Short>();
        for (Short v : reasonCodes) {
            if (v == null) break;
            list.add(v);
        }
        this.reasonCodes = Collections.unmodifiableList(list);
    }

    public List<Short> grantedQoSLevels() {
        ArrayList<Short> qosLevels = new ArrayList<Short>(this.reasonCodes.size());
        for (Short code : this.reasonCodes) {
            if (code > MqttQoS.QOS2.value()) {
                qosLevels.add(MqttQoS.FAILURE.value());
                continue;
            }
            qosLevels.add(code);
        }
        return qosLevels;
    }

    public List<Short> reasonCodes() {
        return this.reasonCodes;
    }

    public String toString() {
        return "MqttSubAckPayload[reasonCodes=" + this.reasonCodes + ']';
    }
}

