/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.codec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class MqttUnsubAckPayload {
    private final List<Short> unsubscribeReasonCodes;
    private static final MqttUnsubAckPayload EMPTY = new MqttUnsubAckPayload();

    public static MqttUnsubAckPayload withEmptyDefaults(MqttUnsubAckPayload payload) {
        if (payload == null) {
            return EMPTY;
        }
        return payload;
    }

    public MqttUnsubAckPayload() {
        this.unsubscribeReasonCodes = Collections.emptyList();
    }

    public MqttUnsubAckPayload(short[] unsubscribeReasonCodes) {
        Objects.requireNonNull(unsubscribeReasonCodes, "unsubscribeReasonCodes is null.");
        ArrayList<Short> list = new ArrayList<Short>();
        for (short v : unsubscribeReasonCodes) {
            list.add(v);
        }
        this.unsubscribeReasonCodes = Collections.unmodifiableList(list);
    }

    public MqttUnsubAckPayload(Iterable<Short> unsubscribeReasonCodes) {
        Objects.requireNonNull(unsubscribeReasonCodes, "unsubscribeReasonCodes is null.");
        ArrayList<Short> list = new ArrayList<Short>();
        for (Short v : unsubscribeReasonCodes) {
            Objects.requireNonNull(v, "unsubscribeReasonCode is null.");
            list.add(v);
        }
        this.unsubscribeReasonCodes = Collections.unmodifiableList(list);
    }

    public List<Short> unsubscribeReasonCodes() {
        return this.unsubscribeReasonCodes;
    }

    public String toString() {
        return "MqttUnsubAckPayload[unsubscribeReasonCodes=" + this.unsubscribeReasonCodes + ']';
    }
}

