/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.codec.properties;

public enum MqttPropertyType {
    PAYLOAD_FORMAT_INDICATOR(1),
    REQUEST_PROBLEM_INFORMATION(23),
    REQUEST_RESPONSE_INFORMATION(25),
    MAXIMUM_QOS(36),
    RETAIN_AVAILABLE(37),
    WILDCARD_SUBSCRIPTION_AVAILABLE(40),
    SUBSCRIPTION_IDENTIFIER_AVAILABLE(41),
    SHARED_SUBSCRIPTION_AVAILABLE(42),
    SERVER_KEEP_ALIVE(19),
    RECEIVE_MAXIMUM(33),
    TOPIC_ALIAS_MAXIMUM(34),
    TOPIC_ALIAS(35),
    PUBLICATION_EXPIRY_INTERVAL(2),
    SESSION_EXPIRY_INTERVAL(17),
    WILL_DELAY_INTERVAL(24),
    MAXIMUM_PACKET_SIZE(39),
    SUBSCRIPTION_IDENTIFIER(11),
    CONTENT_TYPE(3),
    RESPONSE_TOPIC(8),
    ASSIGNED_CLIENT_IDENTIFIER(18),
    AUTHENTICATION_METHOD(21),
    RESPONSE_INFORMATION(26),
    SERVER_REFERENCE(28),
    REASON_STRING(31),
    USER_PROPERTY(38),
    CORRELATION_DATA(9),
    AUTHENTICATION_DATA(22);

    private static final MqttPropertyType[] VALUES;
    private final byte value;

    private MqttPropertyType(byte value) {
        this.value = value;
    }

    public byte value() {
        return this.value;
    }

    public static MqttPropertyType valueOf(int type) {
        MqttPropertyType t = null;
        try {
            t = VALUES[type];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (t == null) {
            throw new IllegalArgumentException("unknown property type: " + type);
        }
        return t;
    }

    static {
        VALUES = new MqttPropertyType[43];
        MqttPropertyType[] mqttPropertyTypeArray = MqttPropertyType.values();
        int n = mqttPropertyTypeArray.length;
        for (int i = 0; i < n; ++i) {
            MqttPropertyType v;
            MqttPropertyType.VALUES[v.value] = v = mqttPropertyTypeArray[i];
        }
    }
}

