/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.spring.server;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import net.dreamlu.iot.mqtt.codec.MqttPublishMessage;
import net.dreamlu.iot.mqtt.core.server.func.IMqttFunctionMessageListener;
import net.dreamlu.iot.mqtt.core.server.func.MqttFunctionManager;
import net.dreamlu.iot.mqtt.core.util.TopicUtil;
import net.dreamlu.iot.mqtt.spring.server.MqttServerFunction;
import net.dreamlu.iot.mqtt.spring.server.MqttServerFunctionMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.tio.core.ChannelContext;

public class MqttServerFunctionDetector
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(MqttServerFunctionDetector.class);
    private final ApplicationContext applicationContext;
    private final MqttFunctionManager functionManager;

    public Object postProcessAfterInitialization(@NonNull Object bean, String beanName) throws BeansException {
        Class userClass = ClassUtils.getUserClass((Object)bean);
        if (bean instanceof MqttServerFunctionMessageListener) {
            MqttServerFunction subscribe = (MqttServerFunction)AnnotationUtils.findAnnotation((Class)userClass, MqttServerFunction.class);
            if (subscribe != null) {
                String[] topicFilters = MqttServerFunctionDetector.getTopicFilters(this.applicationContext, subscribe.value());
                this.functionManager.register(topicFilters, (IMqttFunctionMessageListener)((MqttServerFunctionMessageListener)bean));
            }
        } else {
            ReflectionUtils.doWithMethods((Class)userClass, method -> {
                MqttServerFunction subscribe = (MqttServerFunction)AnnotationUtils.findAnnotation((Method)method, MqttServerFunction.class);
                if (subscribe != null) {
                    int modifiers = method.getModifiers();
                    if (Modifier.isStatic(modifiers)) {
                        throw new IllegalArgumentException("@MqttServerFunction on method " + method + " must not static.");
                    }
                    if (!Modifier.isPublic(modifiers)) {
                        throw new IllegalArgumentException("@MqttServerFunction on method " + method + " must public.");
                    }
                    int paramCount = method.getParameterCount();
                    if (paramCount < 2 || paramCount > 6) {
                        throw new IllegalArgumentException("@MqttServerFunction on method " + method + " parameter count must 2 ~ 6.");
                    }
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    MqttServerFunctionDetector.checkParameterTypes(method, parameterTypes);
                    String[] topicTemplates = subscribe.value();
                    String[] topicFilters = MqttServerFunctionDetector.getTopicFilters(this.applicationContext, topicTemplates);
                    MqttServerFunctionMessageListener messageListener = new MqttServerFunctionMessageListener(bean, method, topicTemplates, topicFilters);
                    this.functionManager.register(topicFilters, (IMqttFunctionMessageListener)messageListener);
                }
            }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        }
        return bean;
    }

    private static String[] getTopicFilters(ApplicationContext applicationContext, String[] values) {
        return (String[])Arrays.stream(values).map(arg_0 -> ((Environment)applicationContext.getEnvironment()).resolvePlaceholders(arg_0)).map(TopicUtil::getTopicFilter).toArray(String[]::new);
    }

    private static void checkParameterTypes(Method method, Class<?>[] parameterTypes) {
        for (Class<?> parameterType : parameterTypes) {
            if (String.class == parameterType || ChannelContext.class == parameterType || Map.class == parameterType || MqttPublishMessage.class == parameterType || byte[].class == parameterType || ByteBuffer.class == parameterType) continue;
            throw new IllegalArgumentException("@MqttServerFunction on method " + method + " parameter type must String topic, Map<String, String> topicVars, MqttPublishMessage message, byte[] payload or ByteBuffer payload.");
        }
    }

    public MqttServerFunctionDetector(ApplicationContext applicationContext, MqttFunctionManager functionManager) {
        this.applicationContext = applicationContext;
        this.functionManager = functionManager;
    }
}

