/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.redis.spring;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.javacrumbs.shedlock.core.ExtensibleLockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.provider.redis.support.InternalRedisLockProvider;
import net.javacrumbs.shedlock.provider.redis.support.InternalRedisLockTemplate;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.core.types.Expiration;

public class RedisLockProvider
implements ExtensibleLockProvider {
    private final InternalRedisLockProvider internalRedisLockProvider;

    public RedisLockProvider(RedisConnectionFactory redisConn) {
        this(redisConn, "default");
    }

    public RedisLockProvider(RedisConnectionFactory redisConn, String environment) {
        this(redisConn, environment, "job-lock");
    }

    public RedisLockProvider(RedisConnectionFactory redisConn, String environment, String keyPrefix) {
        this(new StringRedisTemplate(redisConn), environment, keyPrefix);
    }

    public RedisLockProvider(StringRedisTemplate redisTemplate, String environment, String keyPrefix) {
        this(redisTemplate, environment, keyPrefix, false);
    }

    RedisLockProvider(StringRedisTemplate redisTemplate, String environment, String keyPrefix, boolean safeUpdate) {
        this.internalRedisLockProvider = new InternalRedisLockProvider((InternalRedisLockTemplate)new SpringRedisLockTemplate(redisTemplate), environment, keyPrefix, safeUpdate);
    }

    public Optional<SimpleLock> lock(LockConfiguration lockConfiguration) {
        return this.internalRedisLockProvider.lock(lockConfiguration);
    }

    private record SpringRedisLockTemplate(StringRedisTemplate template) implements InternalRedisLockTemplate
    {
        public boolean setIfAbsent(String key, String value, long expirationMs) {
            return this.set(key, value, expirationMs, RedisStringCommands.SetOption.SET_IF_ABSENT);
        }

        public boolean setIfPresent(String key, String value, long expirationMs) {
            return this.set(key, value, expirationMs, RedisStringCommands.SetOption.SET_IF_PRESENT);
        }

        private boolean set(String key, String value, long expirationMs, RedisStringCommands.SetOption setOption) {
            return Boolean.TRUE.equals(this.template.execute(connection -> {
                byte[] serializedKey = this.template.getKeySerializer().serialize((Object)key);
                byte[] serializedValue = this.template.getValueSerializer().serialize((Object)value);
                return connection.stringCommands().set(serializedKey, serializedValue, Expiration.from((long)expirationMs, (TimeUnit)TimeUnit.MILLISECONDS), setOption);
            }, false));
        }

        public @Nullable Object eval(String script, String key, String ... values) {
            return this.template.execute((RedisScript)new DefaultRedisScript(script, Integer.class), List.of(key), (Object[])values);
        }

        public void delete(String key) {
            this.template.delete((Object)key);
        }
    }

    public static class Builder {
        private final StringRedisTemplate redisTemplate;
        private String environment = "default";
        private String keyPrefix = "job-lock";
        private boolean safeUpdate = false;

        public Builder(RedisConnectionFactory redisConnectionFactory) {
            this.redisTemplate = new StringRedisTemplate(redisConnectionFactory);
        }

        public Builder(StringRedisTemplate redisTemplate) {
            this.redisTemplate = redisTemplate;
        }

        public Builder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder keyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
            return this;
        }

        public Builder safeUpdate(boolean safeUpdate) {
            this.safeUpdate = safeUpdate;
            return this;
        }

        public RedisLockProvider build() {
            return new RedisLockProvider(this.redisTemplate, this.environment, this.keyPrefix, this.safeUpdate);
        }
    }
}

