/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback;

import ch.qos.logback.classic.pattern.Abbreviator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CachingAbbreviator
implements Abbreviator {
    private final Abbreviator delegate;
    private final ConcurrentMap<String, String> cache = new ConcurrentHashMap<String, String>();

    public CachingAbbreviator(Abbreviator delegate) {
        this.delegate = delegate;
    }

    public String abbreviate(String in) {
        String abbreviation = (String)this.cache.get(in);
        if (abbreviation == null) {
            abbreviation = this.delegate.abbreviate(in);
            this.cache.putIfAbsent(in, abbreviation);
        }
        return abbreviation;
    }

    public void clear() {
        this.cache.clear();
    }
}

