/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite.loggingevent;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import net.logstash.logback.argument.StructuredArgument;
import net.logstash.logback.composite.AbstractFieldJsonProvider;

public class ArgumentsJsonProvider
extends AbstractFieldJsonProvider<ILoggingEvent> {
    private boolean includeNonStructuredArguments;
    private String nonStructuredArgumentsFieldPrefix = "arg";

    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) throws IOException {
        Object[] args = event.getArgumentArray();
        if (args == null || args.length == 0) {
            return;
        }
        boolean hasWrittenFieldName = false;
        for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            Object arg = args[argIndex];
            if (arg instanceof StructuredArgument) {
                if (!hasWrittenFieldName && this.getFieldName() != null) {
                    generator.writeObjectFieldStart(this.getFieldName());
                    hasWrittenFieldName = true;
                }
                StructuredArgument structuredArgument = (StructuredArgument)arg;
                structuredArgument.writeTo(generator);
                continue;
            }
            if (!this.includeNonStructuredArguments) continue;
            if (!hasWrittenFieldName && this.getFieldName() != null) {
                generator.writeObjectFieldStart(this.getFieldName());
                hasWrittenFieldName = true;
            }
            String fieldName = this.nonStructuredArgumentsFieldPrefix + argIndex;
            generator.writeObjectField(fieldName, arg);
        }
        if (hasWrittenFieldName) {
            generator.writeEndObject();
        }
    }

    public boolean isIncludeNonStructuredArguments() {
        return this.includeNonStructuredArguments;
    }

    public void setIncludeNonStructuredArguments(boolean includeArgumentWithNoKey) {
        this.includeNonStructuredArguments = includeArgumentWithNoKey;
    }

    public String getNonStructuredArgumentsFieldPrefix() {
        return this.nonStructuredArgumentsFieldPrefix;
    }

    public void setNonStructuredArgumentsFieldPrefix(String argumentWithNoKeyPrefix) {
        this.nonStructuredArgumentsFieldPrefix = argumentWithNoKeyPrefix;
    }
}

