/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;

public class JsonReadingUtils {
    private JsonReadingUtils() {
    }

    public static JsonNode readFully(JsonFactory jsonFactory, String json) throws IOException {
        if (json == null) {
            return null;
        }
        String trimmedJson = json.trim();
        try (JsonParser parser = jsonFactory.createParser(trimmedJson);){
            JsonNode tree = (JsonNode)parser.readValueAsTree();
            if (parser.getCurrentLocation().getCharOffset() < (long)trimmedJson.length()) {
                throw new JsonParseException(parser, "unexpected character");
            }
            JsonNode jsonNode = tree;
            return jsonNode;
        }
    }

    public static ObjectNode readFullyAsObjectNode(JsonFactory jsonFactory, String json) throws IOException {
        JsonNode node = JsonReadingUtils.readFully(jsonFactory, json);
        if (node != null && !(node instanceof ObjectNode)) {
            throw new JsonParseException(null, "expected a JSON object representation");
        }
        return (ObjectNode)node;
    }
}

