/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.impl.configuration;

import com.sun.esb.management.api.configuration.ConfigurationService;
import com.sun.esb.management.base.services.AbstractListStateServiceMBeansImpl;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.TargetType;
import com.sun.esb.management.common.data.ApplicationVerificationReport;
import com.sun.esb.management.common.data.helper.ApplicationVerificationReportWriter;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.ui.common.JBIManagementMessage;
import com.sun.jbi.ui.common.JBIResultXmlBuilder;
import com.sun.jbi.ui.common.Util;
import com.sun.jbi.ui.runtime.verifier.JBIApplicationVerifier;
import com.sun.jbi.util.Constants;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class ConfigurationServiceMBeanImpl
extends AbstractListStateServiceMBeansImpl
implements ConfigurationService,
Serializable,
Constants {
    static final long serialVersionUID = -1L;

    public ConfigurationServiceMBeanImpl(EnvironmentContext anEnvContext) {
        super(anEnvContext);
    }

    public boolean isComponentConfigSupported(String componentName, String targetName) throws ManagementRemoteException {
        Boolean isComponentConfigSupported = false;
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("isComponentConfigSupported(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            try {
                isComponentConfigSupported = (Boolean)this.invokeMBeanOperation(configFacadeMBean, "isComponentConfigSupported", new Object[0], new String[0]);
                ConfigurationServiceMBeanImpl.logDebug("isComponentConfigSupported(): result = " + isComponentConfigSupported);
            }
            catch (ManagementRemoteException jbiRE) {
                ConfigurationServiceMBeanImpl.logDebug("isComponentConfigSupported caught ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
                throw jbiRE;
            }
            catch (Exception ex) {
                ConfigurationServiceMBeanImpl.logDebug("isComponentConfigSupported  caught non-ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug(ex);
                throw new ManagementRemoteException((Throwable)ex);
            }
        } else {
            String[] args = new String[]{componentName, targetName};
            Exception mgmtEx = this.createManagementException("ui.mbean.component.configuration.mbean.not.found.error", args, null);
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        return isComponentConfigSupported;
    }

    public boolean isAppConfigSupported(String componentName, String targetName) throws ManagementRemoteException {
        Boolean isAppConfigSupported = false;
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("isAppConfigSupported(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            try {
                isAppConfigSupported = (Boolean)this.invokeMBeanOperation(configFacadeMBean, "isAppConfigSupported", new Object[0], new String[0]);
                ConfigurationServiceMBeanImpl.logDebug("isAppConfigSupported(): result = " + isAppConfigSupported);
            }
            catch (ManagementRemoteException jbiRE) {
                ConfigurationServiceMBeanImpl.logDebug("isAppConfigSupported caught ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
                throw jbiRE;
            }
            catch (Exception ex) {
                ConfigurationServiceMBeanImpl.logDebug("isAppConfigSupported  caught non-ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug(ex);
                throw new ManagementRemoteException((Throwable)ex);
            }
        } else {
            String[] args = new String[]{componentName, targetName};
            Exception mgmtEx = this.createManagementException("ui.mbean.component.configuration.mbean.not.found.error", args, null);
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        return isAppConfigSupported;
    }

    public boolean isAppVarsSupported(String componentName, String targetName) throws ManagementRemoteException {
        Boolean isAppVarsSupported = false;
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("isAppVarsSupported(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            try {
                isAppVarsSupported = (Boolean)this.invokeMBeanOperation(configFacadeMBean, "isAppVarsSupported", new Object[0], new String[0]);
                ConfigurationServiceMBeanImpl.logDebug("isAppVarsSupported(): result = " + isAppVarsSupported);
            }
            catch (ManagementRemoteException jbiRE) {
                ConfigurationServiceMBeanImpl.logDebug("isAppVarsSupported caught ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
                throw jbiRE;
            }
            catch (Exception ex) {
                ConfigurationServiceMBeanImpl.logDebug("isAppVarsSupported  caught non-ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug(ex);
                throw new ManagementRemoteException((Throwable)ex);
            }
        } else {
            String[] args = new String[]{componentName, targetName};
            Exception mgmtEx = this.createManagementException("ui.mbean.component.configuration.mbean.not.found.error", args, null);
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        return isAppVarsSupported;
    }

    public CompositeType queryApplicationConfigurationType(String componentName, String targetName) throws ManagementRemoteException {
        this.domainTargetCheck(targetName);
        CompositeType appCfgType = null;
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("queryApplicationConfigurationType(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            try {
                appCfgType = (CompositeType)this.invokeMBeanOperation(configFacadeMBean, "queryApplicationConfigurationType", new Object[0], new String[0]);
                return appCfgType;
            }
            catch (ManagementRemoteException jbiRE) {
                ConfigurationServiceMBeanImpl.logDebug("queryApplicationConfigurationType caught ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
                throw jbiRE;
            }
            catch (Exception ex) {
                ConfigurationServiceMBeanImpl.logDebug("queryApplicationConfigurationType  caught non-ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug(ex);
                throw new ManagementRemoteException((Throwable)ex);
            }
        }
        String[] args = new String[]{componentName, targetName};
        Exception mgmtEx = this.createManagementException("ui.mbean.component.configuration.mbean.not.found.error", args, null);
        throw new ManagementRemoteException((Throwable)mgmtEx);
    }

    public String addApplicationConfiguration(String componentName, String targetName, String name, Properties config) throws ManagementRemoteException {
        this.domainTargetCheck(targetName);
        if (!this.isAppConfigSupported(componentName, targetName)) {
            Exception mgmtEx = this.createManagementException("ui.mbean.component.set.app.config.not.supported", new String[]{componentName, targetName}, null);
            ConfigurationServiceMBeanImpl.logDebug(mgmtEx.getMessage());
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        String jbiMgmtMsgResult = null;
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("addApplicationConfiguration(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            try {
                jbiMgmtMsgResult = (String)this.invokeMBeanOperation(configFacadeMBean, "addApplicationConfiguration", new Object[]{name, config}, new String[]{"java.lang.String", "java.util.Properties"});
                ConfigurationServiceMBeanImpl.logDebug("addApplicationConfiguration(): result = " + jbiMgmtMsgResult);
                return jbiMgmtMsgResult;
            }
            catch (ManagementRemoteException jbiRE) {
                ConfigurationServiceMBeanImpl.logDebug("addApplicationConfiguration caught ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
                throw jbiRE;
            }
            catch (Exception ex) {
                ConfigurationServiceMBeanImpl.logDebug("addApplicationConfiguration  caught non-ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug(ex);
                String[] args = new String[]{name, componentName, targetName};
                Exception mgmtEx = this.createManagementException("ui.mbean.component.add.app.config.error", args, ex);
                throw new ManagementRemoteException((Throwable)mgmtEx);
            }
        }
        String[] args = new String[]{componentName, targetName};
        Exception mgmtEx = this.createManagementException("ui.mbean.component.configuration.mbean.not.found.error", args, null);
        throw new ManagementRemoteException((Throwable)mgmtEx);
    }

    public String addApplicationVariables(String componentName, String targetName, Properties appVariables) throws ManagementRemoteException {
        this.domainTargetCheck(targetName);
        if (!this.isAppVarsSupported(componentName, targetName)) {
            Exception mgmtEx = this.createManagementException("ui.mbean.component.set.app.vars.not.supported", new String[]{componentName, targetName}, null);
            ConfigurationServiceMBeanImpl.logDebug(mgmtEx.getMessage());
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("addApplicationVariables(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        HashMap<String, String> results = new HashMap<String, String>();
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            this.componentStartedOnTargetCheck(componentName, targetName);
            Set<Object> appVarNames = appVariables.keySet();
            for (String string : appVarNames) {
                String typeAndValueStr = (String)appVariables.get(string);
                String result = null;
                try {
                    CompositeData appVarCD = this.componentConfigurationHelper.createApplicationVariableComposite(string, typeAndValueStr);
                    result = (String)this.invokeMBeanOperation(configFacadeMBean, "addApplicationVariable", new Object[]{string, appVarCD}, new String[]{"java.lang.String", "javax.management.openmbean.CompositeData"});
                    ConfigurationServiceMBeanImpl.logDebug("addApplicationVariable(): result = " + result);
                }
                catch (ManagementRemoteException jbiRE) {
                    ConfigurationServiceMBeanImpl.logDebug("caught ManagementRemoteException:");
                    ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
                    result = jbiRE.getMessage();
                }
                catch (Exception ex) {
                    ConfigurationServiceMBeanImpl.logDebug("caught non-ManagementRemoteException:");
                    ConfigurationServiceMBeanImpl.logDebug(ex);
                    result = ex.getMessage();
                }
                results.put(string, result);
            }
        } else {
            String[] args = new String[]{componentName, targetName};
            Exception mgmtEx = this.createManagementException("ui.mbean.component.configuration.mbean.not.found.error", args, null);
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        JBIManagementMessage msg = JBIManagementMessage.createJBIManagementMessage((String)"addApplicationVariables", results, (boolean)false);
        return JBIResultXmlBuilder.getInstance().createJbiResultXml(msg);
    }

    public String deleteApplicationConfiguration(String componentName, String targetName, String name) throws ManagementRemoteException {
        this.domainTargetCheck(targetName);
        if (!this.isAppConfigSupported(componentName, targetName)) {
            Exception mgmtEx = this.createManagementException("ui.mbean.component.set.app.config.not.supported", new String[]{componentName, targetName}, null);
            ConfigurationServiceMBeanImpl.logDebug(mgmtEx.getMessage());
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        String jbiMgmtMsgResult = null;
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("deleteApplicationConfiguration(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            try {
                jbiMgmtMsgResult = (String)this.invokeMBeanOperation(configFacadeMBean, "deleteApplicationConfiguration", new Object[]{name}, new String[]{"java.lang.String"});
                ConfigurationServiceMBeanImpl.logDebug("deleteApplicationConfiguration(): result = " + jbiMgmtMsgResult);
                return jbiMgmtMsgResult;
            }
            catch (ManagementRemoteException jbiRE) {
                ConfigurationServiceMBeanImpl.logDebug("deleteApplicationConfiguration caught ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
                throw jbiRE;
            }
            catch (Exception ex) {
                ConfigurationServiceMBeanImpl.logDebug("deleteApplicationConfiguration  caught non-ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug(ex);
                String[] args = new String[]{name, componentName, targetName};
                Exception mgmtEx = this.createManagementException("ui.mbean.component.delete.app.config.error", args, ex);
                throw new ManagementRemoteException((Throwable)mgmtEx);
            }
        }
        String[] args = new String[]{componentName, targetName};
        Exception mgmtEx = this.createManagementException("ui.mbean.component.configuration.mbean.not.found.error", args, null);
        throw new ManagementRemoteException((Throwable)mgmtEx);
    }

    public String deleteApplicationVariables(String componentName, String targetName, String[] appVariableNames) throws ManagementRemoteException {
        this.domainTargetCheck(targetName);
        if (!this.isAppVarsSupported(componentName, targetName)) {
            Exception mgmtEx = this.createManagementException("ui.mbean.component.set.app.vars.not.supported", new String[]{componentName, targetName}, null);
            ConfigurationServiceMBeanImpl.logDebug(mgmtEx.getMessage());
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("deleteApplicationVariables(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        HashMap<String, String> results = new HashMap<String, String>();
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            this.componentStartedOnTargetCheck(componentName, targetName);
            if (appVariableNames != null) {
                for (String appVarName : appVariableNames) {
                    String result = null;
                    try {
                        result = (String)this.invokeMBeanOperation(configFacadeMBean, "deleteApplicationVariable", new Object[]{appVarName}, new String[]{"java.lang.String"});
                        ConfigurationServiceMBeanImpl.logDebug("deleteApplicationVariable(): result = " + result);
                    }
                    catch (ManagementRemoteException jbiRE) {
                        ConfigurationServiceMBeanImpl.logDebug("caught ManagementRemoteException:");
                        ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
                        result = jbiRE.getMessage();
                    }
                    catch (Exception ex) {
                        ConfigurationServiceMBeanImpl.logDebug("caught non-ManagementRemoteException:");
                        ConfigurationServiceMBeanImpl.logDebug(ex);
                        result = ex.getMessage();
                    }
                    results.put(appVarName, result);
                }
            }
        } else {
            String[] args = new String[]{componentName, targetName};
            Exception mgmtEx = this.createManagementException("ui.mbean.component.configuration.mbean.not.found.error", args, null);
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        JBIManagementMessage msg = JBIManagementMessage.createJBIManagementMessage((String)"deleteApplicationVariables", results, (boolean)true);
        return JBIResultXmlBuilder.getInstance().createJbiResultXml(msg);
    }

    public String exportApplicationConfiguration(String applicationName, String targetName, String configDir) throws ManagementRemoteException {
        String result = null;
        JBIApplicationVerifier verifier = new JBIApplicationVerifier(this.environmentContext);
        try {
            this.domainTargetCheck(targetName);
            result = verifier.exportApplicationConfiguration(applicationName, targetName, configDir);
        }
        catch (Exception ManagementRemoteException2) {
            throw new ManagementRemoteException((Throwable)ManagementRemoteException2);
        }
        return result;
    }

    public Properties getApplicationConfiguration(String componentName, String name, String targetName) throws ManagementRemoteException {
        this.domainTargetCheck(targetName);
        if (!this.isAppConfigSupported(componentName, targetName)) {
            Exception mgmtEx = this.createManagementException("ui.mbean.component.set.app.config.not.supported", new String[]{componentName, targetName}, null);
            ConfigurationServiceMBeanImpl.logDebug(mgmtEx.getMessage());
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        Map<String, Properties> configMap = this.getApplicationConfigurations(componentName, targetName);
        Properties appConfigProps = configMap.get(name);
        if (appConfigProps == null) {
            String[] args = new String[]{name, componentName, targetName};
            Exception mgmtEx = this.createManagementException("ui.mbean.component.missing.app.config.error", args, null);
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        return appConfigProps;
    }

    public Map<String, Properties> getApplicationConfigurations(String componentName, String targetName) throws ManagementRemoteException {
        this.domainTargetCheck(targetName);
        if (!this.isAppConfigSupported(componentName, targetName)) {
            Exception mgmtEx = this.createManagementException("ui.mbean.component.set.app.config.not.supported", new String[]{componentName, targetName}, null);
            ConfigurationServiceMBeanImpl.logDebug(mgmtEx.getMessage());
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        TabularData td = null;
        Map<String, Properties> appConfigMap = new HashMap<String, Properties>();
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("getApplicationConfigurations(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            try {
                Object result = this.getAttributeValue(configFacadeMBean, "ApplicationConfigurations");
                if (result != null) {
                    td = (TabularData)result;
                    appConfigMap = this.getApplicationConfigurationsMap(td);
                }
                return appConfigMap;
            }
            catch (ManagementRemoteException jbiRE) {
                ConfigurationServiceMBeanImpl.logDebug("getApplicationConfigurations caught ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
                throw jbiRE;
            }
            catch (Exception ex) {
                ConfigurationServiceMBeanImpl.logDebug("getApplicationConfigurations  caught non-ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug(ex);
                String[] args = new String[]{componentName, targetName};
                Exception mgmtEx = this.createManagementException("ui.mbean.component.get.app.config.error", args, ex);
                throw new ManagementRemoteException((Throwable)mgmtEx);
            }
        }
        String[] args = new String[]{componentName, targetName};
        Exception mgmtEx = this.createManagementException("ui.mbean.component.configuration.mbean.not.found.error", args, null);
        throw new ManagementRemoteException((Throwable)mgmtEx);
    }

    public Properties getApplicationVariables(String componentName, String targetName) throws ManagementRemoteException {
        this.domainTargetCheck(targetName);
        if (!this.isAppVarsSupported(componentName, targetName)) {
            Exception mgmtEx = this.createManagementException("ui.mbean.component.set.vars.config.not.supported", new String[]{componentName, targetName}, null);
            ConfigurationServiceMBeanImpl.logDebug(mgmtEx.getMessage());
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        Properties appVarProps = new Properties();
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("getApplicationVariables(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            try {
                TabularData appVarTable = (TabularData)this.getAttributeValue(configFacadeMBean, "ApplicationVariables");
                appVarProps = this.componentConfigurationHelper.convertToApplicationVariablesProperties(appVarTable);
                ConfigurationServiceMBeanImpl.logDebug("getApplicationVariables(): result = " + appVarProps);
            }
            catch (ManagementRemoteException jbiRE) {
                ConfigurationServiceMBeanImpl.logDebug("caught ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
                throw jbiRE;
            }
            catch (Exception ex) {
                ConfigurationServiceMBeanImpl.logDebug("caught non-ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug(ex);
                String[] args = new String[]{componentName, targetName};
                Exception exception = this.createManagementException("ui.mbean.component.get.app.vars.error", args, ex);
                ManagementRemoteException remoteException = new ManagementRemoteException((Throwable)exception);
                throw remoteException;
            }
        } else {
            String[] args = new String[]{componentName, targetName};
            Exception mgmtEx = this.createManagementException("ui.mbean.component.configuration.mbean.not.found.error", args, null);
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        return appVarProps;
    }

    public Properties getComponentConfiguration(String componentName, String targetName) throws ManagementRemoteException {
        Properties result = null;
        TargetType targetType = this.checkTargetType(targetName);
        Exception exception = null;
        String[] args = new String[]{targetName};
        switch (targetType) {
            case STANDALONE_SERVER: 
            case CLUSTER: 
            case CLUSTERED_SERVER: {
                break;
            }
            default: {
                ConfigurationServiceMBeanImpl.logDebug("getComponentConfiguration(): target " + targetName + " type not supported.");
                exception = this.createManagementException("ui.mbean.schemaorg_apache_xmlbeans.system.config.target.type.not.supported", args, null);
                throw new ManagementRemoteException((Throwable)exception);
            }
        }
        this.targetUpCheck(targetName);
        this.componentInstalledOnTargetCheck(componentName, targetName);
        this.componentStartedOnTargetCheck(componentName, targetName);
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("getComponentConfiguration(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            try {
                result = this.getConfigurationAttributeValues(configFacadeMBean);
                ConfigurationServiceMBeanImpl.logDebug("getComponentConfiguration: result properties = " + result);
            }
            catch (ManagementRemoteException jbiRE) {
                ConfigurationServiceMBeanImpl.logDebug("caught ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
                throw jbiRE;
            }
            catch (Exception ex) {
                ConfigurationServiceMBeanImpl.logDebug("caught non-ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug(ex);
                exception = this.createManagementException("ui.mbean.install.config.mbean.error.get.attrs.error", null, ex);
                ManagementRemoteException remoteException = new ManagementRemoteException((Throwable)exception);
                throw remoteException;
            }
        }
        return result;
    }

    @Override
    public Map<String, ObjectName[]> getComponentExtensionMBeanObjectNames(String componentName, String extensionName, String targetName) throws ManagementRemoteException {
        return super.getComponentExtensionMBeanObjectNames(componentName, extensionName, targetName);
    }

    @Override
    public ObjectName[] getComponentExtensionMBeanObjectNames(String componentName, String extensionName, String targetName, String targetInstanceName) throws ManagementRemoteException {
        return super.getComponentExtensionMBeanObjectNames(componentName, extensionName, targetName, targetInstanceName);
    }

    public Map<String, Level> getComponentLoggerLevels(String componentName, String targetName, String targetInstanceName) throws ManagementRemoteException {
        TreeMap<String, Level> resultObject = new TreeMap<String, Level>();
        ConfigurationServiceMBeanImpl.logDebug("Get Component Logger Levels ");
        boolean isTargetCluserInstance = false;
        if (targetInstanceName != null) {
            isTargetCluserInstance = ConfigurationServiceMBeanImpl.getEnvironmentContext().getPlatformContext().isClusteredServer(targetInstanceName);
        }
        ConfigurationServiceMBeanImpl.logDebug("Get Component Configuration MBean Name for component " + componentName);
        ObjectName extensionMBeanObjectName = null;
        if (isTargetCluserInstance) {
            String cluster = ConfigurationServiceMBeanImpl.getEnvironmentContext().getPlatformContext().getTargetName(targetInstanceName);
            extensionMBeanObjectName = this.getExtensionMBeanObjectName(componentName, cluster);
            this.checkForValidTarget(extensionMBeanObjectName, "domain");
        } else {
            extensionMBeanObjectName = this.getExtensionMBeanObjectName(componentName, targetName);
            this.checkForValidTarget(extensionMBeanObjectName, "domain");
        }
        ConfigurationServiceMBeanImpl.logDebug("Calling getLoggerMBeanNames on extensionMBeanObjectName = " + extensionMBeanObjectName);
        Map loggerMBeansMap = (Map)this.invokeMBeanOperation(extensionMBeanObjectName, "getLoggerMBeanNames");
        if (loggerMBeansMap != null && (targetName != null || targetInstanceName != null)) {
            ObjectName[] filteredLoggerObjectNames = null;
            if (isTargetCluserInstance) {
                filteredLoggerObjectNames = (ObjectName[])loggerMBeansMap.get(targetInstanceName);
            } else if (this.getPlatformContext().isCluster(targetName)) {
                Iterator clusterItr = loggerMBeansMap.keySet().iterator();
                String clusterInstance = (String)clusterItr.next();
                filteredLoggerObjectNames = (ObjectName[])loggerMBeansMap.get(clusterInstance);
            } else {
                filteredLoggerObjectNames = (ObjectName[])loggerMBeansMap.get(targetName);
            }
            if (filteredLoggerObjectNames != null && filteredLoggerObjectNames.length > 0) {
                for (ObjectName filteredLoggerObjectName : filteredLoggerObjectNames) {
                    try {
                        String[] loggerNames;
                        this.checkForValidTarget(filteredLoggerObjectName, "domain");
                        for (String loggerName : loggerNames = (String[])this.invokeMBeanOperation(filteredLoggerObjectName, "getLoggerNames")) {
                            try {
                                Object[] args = new Object[]{loggerName};
                                String[] signature = new String[]{"java.lang.String"};
                                String logLevel = (String)this.invokeMBeanOperation(filteredLoggerObjectName, "getLevel", args, signature);
                                resultObject.put(loggerName, Level.parse(logLevel));
                            }
                            catch (ManagementRemoteException exception) {
                                ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)exception));
                            }
                            catch (RuntimeException exception) {
                                ConfigurationServiceMBeanImpl.logDebug(exception);
                            }
                        }
                    }
                    catch (ManagementRemoteException exception) {
                        ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)exception));
                    }
                    catch (RuntimeException exception) {
                        ConfigurationServiceMBeanImpl.logDebug(exception);
                    }
                }
            }
        } else {
            Exception exception = this.createManagementException("ui.mbean.extension.getComponentLoggerLevels.error", null, null);
            throw new ManagementRemoteException((Throwable)exception);
        }
        return resultObject;
    }

    public Map<String, String> getComponentLoggerDisplayNames(String componentName, String targetName, String targetInstanceName) throws ManagementRemoteException {
        TreeMap<String, String> resultObject = new TreeMap<String, String>();
        ConfigurationServiceMBeanImpl.logDebug("Get Component Logger Display Names ");
        boolean isTargetCluserInstance = false;
        if (targetInstanceName != null) {
            isTargetCluserInstance = ConfigurationServiceMBeanImpl.getEnvironmentContext().getPlatformContext().isClusteredServer(targetInstanceName);
        }
        ConfigurationServiceMBeanImpl.logDebug("Get Component Configuration MBean Name for component " + componentName);
        ObjectName extensionMBeanObjectName = null;
        if (isTargetCluserInstance) {
            String cluster = ConfigurationServiceMBeanImpl.getEnvironmentContext().getPlatformContext().getTargetName(targetInstanceName);
            extensionMBeanObjectName = this.getExtensionMBeanObjectName(componentName, cluster);
            this.checkForValidTarget(extensionMBeanObjectName, cluster);
        } else {
            extensionMBeanObjectName = this.getExtensionMBeanObjectName(componentName, targetName);
            this.checkForValidTarget(extensionMBeanObjectName, targetName);
        }
        ConfigurationServiceMBeanImpl.logDebug("Calling getLoggerMBeanNames on extensionMBeanObjectName = " + extensionMBeanObjectName);
        Map loggerMBeansMap = (Map)this.invokeMBeanOperation(extensionMBeanObjectName, "getLoggerMBeanNames");
        if (loggerMBeansMap != null && (targetName != null || targetInstanceName != null)) {
            ObjectName[] filteredLoggerObjectNames = null;
            if (isTargetCluserInstance) {
                filteredLoggerObjectNames = (ObjectName[])loggerMBeansMap.get(targetInstanceName);
            } else if (this.getPlatformContext().isCluster(targetName)) {
                Iterator clusterItr = loggerMBeansMap.keySet().iterator();
                String clusterInstance = (String)clusterItr.next();
                filteredLoggerObjectNames = (ObjectName[])loggerMBeansMap.get(clusterInstance);
            } else {
                filteredLoggerObjectNames = (ObjectName[])loggerMBeansMap.get(targetName);
            }
            if (filteredLoggerObjectNames != null && filteredLoggerObjectNames.length > 0) {
                for (ObjectName filteredLoggerObjectName : filteredLoggerObjectNames) {
                    try {
                        String[] loggerNames;
                        this.checkForValidTarget(filteredLoggerObjectName, "domain");
                        for (String loggerName : loggerNames = (String[])this.invokeMBeanOperation(filteredLoggerObjectName, "getLoggerNames")) {
                            try {
                                Object[] args = new Object[]{loggerName};
                                String[] signature = new String[]{"java.lang.String"};
                                String displayName = (String)this.invokeMBeanOperation(filteredLoggerObjectName, "getDisplayName", args, signature);
                                resultObject.put(loggerName, displayName);
                            }
                            catch (ManagementRemoteException exception) {
                                ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)exception));
                            }
                            catch (RuntimeException exception) {
                                ConfigurationServiceMBeanImpl.logDebug(exception);
                            }
                        }
                    }
                    catch (ManagementRemoteException exception) {
                        ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)exception));
                    }
                    catch (RuntimeException exception) {
                        ConfigurationServiceMBeanImpl.logDebug(exception);
                    }
                }
            }
        } else {
            Exception exception = this.createManagementException("ui.mbean.extension.getComponentLoggerDisplayNames.error", null, null);
            throw new ManagementRemoteException((Throwable)exception);
        }
        return resultObject;
    }

    public Properties getDefaultRuntimeConfiguration() throws ManagementRemoteException {
        return this.getDefaultRuntimeConfigurationInternal("domain");
    }

    public Properties getRuntimeConfiguration(String targetName) throws ManagementRemoteException {
        return this.getRuntimeConfigurationInternal(targetName);
    }

    public Properties getRuntimeConfigurationMetaData(String propertyKeyName) throws ManagementRemoteException {
        Map<String, Properties> metadata = null;
        metadata = this.getRuntimeConfigurationMetadataInternal("domain");
        return metadata.get(propertyKeyName);
    }

    public Level getRuntimeLoggerLevel(String runtimeLoggerName, String targetName, String targetInstanceName) throws ManagementRemoteException {
        return this.getRuntimeLoggerLevel(runtimeLoggerName, targetName);
    }

    public Map<String, Level> getRuntimeLoggerLevels(String targetName, String targetInstanceName) throws ManagementRemoteException {
        return this.getRuntimeLoggerLevels(targetName);
    }

    public Map<String, String> getRuntimeLoggerNames(String targetName, String targetInstanceName) throws ManagementRemoteException {
        return this.getRuntimeLoggerNames(targetName);
    }

    public Map<String, Level> getRuntimeLoggerLevels(String targetName) throws ManagementRemoteException {
        TreeMap<String, Level> resultObject = new TreeMap<String, Level>();
        ConfigurationServiceMBeanImpl.logDebug("getRuntimeLoggerLevels: targetName: " + targetName);
        TargetType type = this.checkTargetType(targetName);
        String[] args = new String[]{targetName};
        switch (type) {
            case STANDALONE_SERVER: 
            case CLUSTERED_SERVER: {
                try {
                    if (!this.getPlatformContext().isInstanceUp(targetName)) {
                        Exception exception = this.createManagementException("ui.mbean.list.rt.logger.levels.instance.down.error", args, null);
                        throw new ManagementRemoteException((Throwable)exception);
                    }
                    ObjectName[] loggers = this.getSystemLoggerMBeans(targetName);
                    ConfigurationServiceMBeanImpl.logDebug("found the following " + loggers.length + " loggers: " + loggers);
                    for (int index = 0; index < loggers.length; ++index) {
                        String loggerName = null;
                        String logLevelString = null;
                        try {
                            ConfigurationServiceMBeanImpl.logDebug("loggers[" + index + "]: ObjectName = " + loggers[index]);
                            loggerName = (String)this.invokeMBeanOperation(loggers[index], "getLoggerName");
                            ConfigurationServiceMBeanImpl.logDebug("loggers[" + index + "]: name = " + loggerName);
                            logLevelString = (String)this.invokeMBeanOperation(loggers[index], "getLogLevel");
                            ConfigurationServiceMBeanImpl.logDebug("level = " + logLevelString);
                            this.checkForValidTarget(loggers[index], "domain");
                            resultObject.put(loggerName, Level.parse(logLevelString));
                            continue;
                        }
                        catch (ManagementRemoteException managementRemoteException) {
                            ConfigurationServiceMBeanImpl.logDebug("ManagementRemoteException");
                            ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)managementRemoteException));
                            continue;
                        }
                        catch (RuntimeException runtimeException) {
                            ConfigurationServiceMBeanImpl.logDebug("RuntimeException");
                            ConfigurationServiceMBeanImpl.logDebug(runtimeException);
                        }
                    }
                    break;
                }
                catch (Exception ex) {
                    throw ManagementRemoteException.filterJmxExceptions((Exception)ex);
                }
            }
            case INVALID_TARGET: {
                ConfigurationServiceMBeanImpl.logDebug("getRuntimeLoggerLevels(): target " + targetName + " type not supported.");
                Exception exception = this.createManagementException("ui.mbean.invalid.target.error", args, null);
                throw new ManagementRemoteException((Throwable)exception);
            }
            default: {
                ObjectName loggerCfgFacade = this.getRuntimeLoggerConfigFacadeMBeanName(targetName);
                Properties attribs = this.getConfigurationAttributeValues(loggerCfgFacade);
                for (String string : attribs.keySet()) {
                    String level = (String)attribs.get(string);
                    Level loggerValue = null;
                    loggerValue = level == null || "null".equalsIgnoreCase(level) || "DEFAULT".equalsIgnoreCase(level) ? null : Level.parse(level);
                    resultObject.put(string, loggerValue);
                }
            }
        }
        return resultObject;
    }

    public Level getRuntimeLoggerLevel(String runtimeLoggerName, String targetName) throws ManagementRemoteException {
        Map<String, Level> loggers = this.getRuntimeLoggerLevels(targetName);
        if (loggers.containsKey(runtimeLoggerName)) {
            Level returnLevel = loggers.get(runtimeLoggerName);
            return returnLevel;
        }
        Exception exception = this.createManagementException("ui.mbean.logger.id.does.not.exist", new String[]{runtimeLoggerName}, null);
        throw new ManagementRemoteException((Throwable)exception);
    }

    public Map<String, String> getRuntimeLoggerNames(String targetName) throws ManagementRemoteException {
        TreeMap<String, String> resultObject = new TreeMap<String, String>();
        ConfigurationServiceMBeanImpl.logDebug("getRuntimeLoggerNames: targetName: " + targetName);
        TargetType type = this.checkTargetType(targetName);
        String[] args = new String[]{targetName};
        switch (type) {
            case CLUSTERED_SERVER: {
                try {
                    if (!this.getPlatformContext().isInstanceUp(targetName)) {
                        Exception exception = this.createManagementException("ui.mbean.target.down", args, null);
                        throw new ManagementRemoteException((Throwable)exception);
                    }
                    ObjectName[] loggers = this.getSystemLoggerMBeans(targetName);
                    ConfigurationServiceMBeanImpl.logDebug("found the following " + loggers.length + " loggers: " + loggers);
                    for (int index = 0; index < loggers.length; ++index) {
                        String loggerDisplayName = null;
                        String loggerName = null;
                        try {
                            ConfigurationServiceMBeanImpl.logDebug("loggers[" + index + "]: ObjectName = " + loggers[index]);
                            loggerDisplayName = (String)this.invokeMBeanOperation(loggers[index], "getDisplayName");
                            loggerName = (String)this.invokeMBeanOperation(loggers[index], "getLoggerName");
                            ConfigurationServiceMBeanImpl.logDebug("loggers[" + index + "]: name = " + loggerName + ", display name = " + loggerDisplayName);
                            this.checkForValidTarget(loggers[index], "domain");
                            resultObject.put(loggerDisplayName, loggerName);
                            continue;
                        }
                        catch (ManagementRemoteException exception) {
                            ConfigurationServiceMBeanImpl.logDebug("ManagementRemoteException");
                            ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)exception));
                            continue;
                        }
                        catch (RuntimeException exception) {
                            ConfigurationServiceMBeanImpl.logDebug("RuntimeException");
                            ConfigurationServiceMBeanImpl.logDebug(exception);
                        }
                    }
                    break;
                }
                catch (Exception ex) {
                    throw ManagementRemoteException.filterJmxExceptions((Exception)ex);
                }
            }
            case INVALID_TARGET: {
                ConfigurationServiceMBeanImpl.logDebug("getRuntimeLoggerNames(): target " + targetName + " type not supported.");
                Exception exception = this.createManagementException("ui.mbean.invalid.target.error", args, null);
                throw new ManagementRemoteException((Throwable)exception);
            }
            default: {
                ObjectName loggerCfgFacade = this.getRuntimeLoggerConfigFacadeMBeanName(targetName);
                Map<String, Descriptor> descrMap = this.getConfigurationDescriptors(loggerCfgFacade);
                for (String loggerName : descrMap.keySet()) {
                    Descriptor descr = descrMap.get(loggerName);
                    String loggerDisplayName = (String)descr.getFieldValue("displayName");
                    resultObject.put(loggerDisplayName, loggerName);
                }
            }
        }
        return resultObject;
    }

    public String getRuntimeLoggerDisplayName(String runtimeLoggerName, String targetName) throws ManagementRemoteException {
        String resultString = null;
        ConfigurationServiceMBeanImpl.logDebug("getRuntimeLoggerDisplayName: loggerName: " + runtimeLoggerName + " , targetName: " + targetName);
        TargetType type = this.checkTargetType(targetName);
        String[] args = new String[]{targetName};
        switch (type) {
            case CLUSTERED_SERVER: {
                try {
                    if (!this.getPlatformContext().isInstanceUp(targetName)) {
                        Exception exception = this.createManagementException("ui.mbean.target.down", args, null);
                        throw new ManagementRemoteException((Throwable)exception);
                    }
                    ObjectName[] loggers = this.getSystemLoggerMBeans(targetName);
                    for (int index = 0; index < loggers.length; ++index) {
                        String loggerName = null;
                        String loggerDisplayName = null;
                        try {
                            ConfigurationServiceMBeanImpl.logDebug("loggers[" + index + "]: ObjectName = " + loggers[index]);
                            loggerDisplayName = (String)this.invokeMBeanOperation(loggers[index], "getDisplayName");
                            loggerName = (String)this.invokeMBeanOperation(loggers[index], "getLoggerName");
                            ConfigurationServiceMBeanImpl.logDebug("loggers[" + index + "]: " + loggerName + ", " + loggerDisplayName);
                            if (!loggerName.equals(runtimeLoggerName)) continue;
                            ConfigurationServiceMBeanImpl.logDebug("Found the matching logger.");
                            resultString = loggerDisplayName;
                            continue;
                        }
                        catch (ManagementRemoteException exception) {
                            ConfigurationServiceMBeanImpl.logDebug("ManagementRemoteException");
                            ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)exception));
                            continue;
                        }
                        catch (RuntimeException exception) {
                            ConfigurationServiceMBeanImpl.logDebug("RuntimeException");
                            ConfigurationServiceMBeanImpl.logDebug(exception);
                        }
                    }
                    break;
                }
                catch (Exception ex) {
                    throw ManagementRemoteException.filterJmxExceptions((Exception)ex);
                }
            }
            case INVALID_TARGET: {
                ConfigurationServiceMBeanImpl.logDebug("getRuntimeLoggerName(): target " + targetName + " type not supported.");
                Exception exception = this.createManagementException("ui.mbean.invalid.target.error", args, null);
                throw new ManagementRemoteException((Throwable)exception);
            }
            default: {
                ObjectName loggerCfgFacade = this.getRuntimeLoggerConfigFacadeMBeanName(targetName);
                Map<String, Descriptor> descrMap = this.getConfigurationDescriptors(loggerCfgFacade);
                for (String loggerName : descrMap.keySet()) {
                    if (!loggerName.equals(runtimeLoggerName)) continue;
                    Descriptor descr = descrMap.get(loggerName);
                    resultString = (String)descr.getFieldValue("displayName");
                }
            }
        }
        if (resultString == null) {
            Exception exception = this.createManagementException("ui.mbean.logger.id.does.not.exist", new String[]{runtimeLoggerName}, null);
            throw new ManagementRemoteException((Throwable)exception);
        }
        return resultString;
    }

    public boolean isServerRestartRequired() throws ManagementRemoteException {
        return false;
    }

    public String[] listApplicationConfigurationNames(String componentName, String targetName) throws ManagementRemoteException {
        this.domainTargetCheck(targetName);
        Map<String, Properties> configMap = this.getApplicationConfigurations(componentName, targetName);
        Set<String> configNamesSet = configMap.keySet();
        String[] configNames = new String[configNamesSet.size()];
        configNames = configNamesSet.toArray(configNames);
        return configNames;
    }

    public String setApplicationConfiguration(String componentName, String name, Properties config, String targetName) throws ManagementRemoteException {
        this.domainTargetCheck(targetName);
        if (!this.isAppConfigSupported(componentName, targetName)) {
            Exception mgmtEx = this.createManagementException("ui.mbean.component.set.app.config.not.supported", new String[]{componentName, targetName}, null);
            ConfigurationServiceMBeanImpl.logDebug(mgmtEx.getMessage());
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        String jbiMgmtMsgResult = null;
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("setApplicationConfiguration(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            try {
                jbiMgmtMsgResult = (String)this.invokeMBeanOperation(configFacadeMBean, "setApplicationConfiguration", new Object[]{name, config}, new String[]{"java.lang.String", "java.util.Properties"});
                ConfigurationServiceMBeanImpl.logDebug("setApplicationConfiguration(): result = " + jbiMgmtMsgResult);
                return jbiMgmtMsgResult;
            }
            catch (ManagementRemoteException jbiRE) {
                ConfigurationServiceMBeanImpl.logDebug("setApplicationConfiguration caught ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
                throw jbiRE;
            }
            catch (Exception ex) {
                ConfigurationServiceMBeanImpl.logDebug("setApplicationConfiguration  caught non-ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug(ex);
                String[] args = new String[]{name, componentName, targetName};
                Exception mgmtEx = this.createManagementException("ui.mbean.component.set.app.config.error", args, ex);
                throw new ManagementRemoteException((Throwable)mgmtEx);
            }
        }
        String[] args = new String[]{componentName, targetName};
        Exception mgmtEx = this.createManagementException("ui.mbean.component.configuration.mbean.not.found.error", args, null);
        throw new ManagementRemoteException((Throwable)mgmtEx);
    }

    public String setApplicationVariables(String componentName, Properties appVariables, String targetName) throws ManagementRemoteException {
        this.domainTargetCheck(targetName);
        if (!this.isAppVarsSupported(componentName, targetName)) {
            Exception mgmtEx = this.createManagementException("ui.mbean.component.set.app.vars.not.supported", new String[]{componentName, targetName}, null);
            ConfigurationServiceMBeanImpl.logDebug(mgmtEx.getMessage());
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("setApplicationVariables(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        HashMap<String, String> results = new HashMap<String, String>();
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            this.componentStartedOnTargetCheck(componentName, targetName);
            Set<Object> appVarNames = appVariables.keySet();
            for (String string : appVarNames) {
                String typeAndValueStr = (String)appVariables.get(string);
                String result = null;
                try {
                    String type = this.componentConfigurationHelper.getAppVarType(typeAndValueStr, null);
                    String value = this.componentConfigurationHelper.getAppVarValue(typeAndValueStr);
                    if (type == null) {
                        type = this.getExistingAppVarType(componentName, targetName, string);
                    }
                    CompositeData appVarCD = this.componentConfigurationHelper.createApplicationVariableComposite(string, value, type);
                    result = (String)this.invokeMBeanOperation(configFacadeMBean, "setApplicationVariable", new Object[]{string, appVarCD}, new String[]{"java.lang.String", "javax.management.openmbean.CompositeData"});
                    ConfigurationServiceMBeanImpl.logDebug("setApplicationVariable(): result = " + result);
                }
                catch (ManagementRemoteException jbiRE) {
                    ConfigurationServiceMBeanImpl.logDebug("caught ManagementRemoteException:");
                    ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
                    result = jbiRE.getMessage();
                }
                catch (Exception ex) {
                    ConfigurationServiceMBeanImpl.logDebug("caught non-ManagementRemoteException:");
                    ConfigurationServiceMBeanImpl.logDebug(ex);
                    result = ex.getMessage();
                }
                results.put(string, result);
            }
        } else {
            String[] args = new String[]{componentName, targetName};
            Exception mgmtEx = this.createManagementException("ui.mbean.component.configuration.mbean.not.found.error", args, null);
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        JBIManagementMessage msg = JBIManagementMessage.createJBIManagementMessage((String)"setApplicationVariables", results, (boolean)false);
        String strMsg = JBIResultXmlBuilder.getInstance().createJbiResultXml(msg);
        return JBIResultXmlBuilder.getInstance().createJbiResultXml(msg);
    }

    public String setComponentConfiguration(String componentName, Properties configurationValues, String targetName) throws ManagementRemoteException {
        String result = null;
        AttributeList list = null;
        TargetType targetType = this.checkTargetType(targetName);
        Exception exception = null;
        String[] args = new String[]{targetName};
        switch (targetType) {
            case STANDALONE_SERVER: 
            case CLUSTER: 
            case CLUSTERED_SERVER: {
                break;
            }
            default: {
                ConfigurationServiceMBeanImpl.logDebug("setComponentConfiguration(): target " + targetName + " type not supported.");
                exception = this.createManagementException("ui.mbean.schemaorg_apache_xmlbeans.system.config.target.type.not.supported", args, null);
                throw new ManagementRemoteException((Throwable)exception);
            }
        }
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("setComponentConfiguration(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            try {
                list = this.constructMBeanAttributes(configFacadeMBean, configurationValues);
                result = this.setMBeanConfigAttributes(configFacadeMBean, list);
                ConfigurationServiceMBeanImpl.logDebug("setComponentConfiguration(): result = " + result);
            }
            catch (ManagementRemoteException jbiRE) {
                ConfigurationServiceMBeanImpl.logDebug("caught ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
                throw jbiRE;
            }
            catch (Exception ex) {
                ConfigurationServiceMBeanImpl.logDebug("caught non-ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug(ex);
                exception = this.createManagementException("ui.mbean.component.config.mbean.error.set.attrs.error", null, ex);
                ManagementRemoteException remoteException = new ManagementRemoteException((Throwable)exception);
                throw remoteException;
            }
        } else {
            ConfigurationServiceMBeanImpl.logDebug("Component " + componentName + " does not exist.");
            exception = this.createManagementException("ui.mbean.component.id.does.not.exist", new String[]{componentName}, null);
            ManagementRemoteException remoteException = new ManagementRemoteException((Throwable)exception);
            throw remoteException;
        }
        return result;
    }

    public void setComponentLoggerLevel(String componentName, String loggerCustomName, Level logLevel, String targetName, String targetInstanceName) throws ManagementRemoteException {
        ConfigurationServiceMBeanImpl.logDebug("Set Component Logger Level");
        boolean isTargetCluserInstance = false;
        if (targetInstanceName != null) {
            isTargetCluserInstance = ConfigurationServiceMBeanImpl.getEnvironmentContext().getPlatformContext().isClusteredServer(targetInstanceName);
        }
        ConfigurationServiceMBeanImpl.logDebug("Get Component Configuration MBean Name for component " + componentName);
        ObjectName extensionMBeanObjectName = null;
        if (isTargetCluserInstance) {
            targetName = ConfigurationServiceMBeanImpl.getEnvironmentContext().getPlatformContext().getTargetName(targetInstanceName);
        }
        this.componentInstalledOnTargetCheck(componentName, targetName);
        extensionMBeanObjectName = this.getExtensionMBeanObjectName(componentName, targetName);
        this.checkForValidTarget(extensionMBeanObjectName, "domain");
        ConfigurationServiceMBeanImpl.logDebug("Calling getLoggerMBeanNames on extensionMBeanObjectName = " + extensionMBeanObjectName);
        Map loggerMBeansMap = (Map)this.invokeMBeanOperation(extensionMBeanObjectName, "getLoggerMBeanNames");
        if (loggerMBeansMap != null && (targetName != null || targetInstanceName != null)) {
            ObjectName[] filteredLoggerObjectNames = null;
            if (isTargetCluserInstance) {
                filteredLoggerObjectNames = (ObjectName[])loggerMBeansMap.get(targetInstanceName);
                this.setLoggerLevelsForInstance(filteredLoggerObjectNames, loggerCustomName, logLevel);
            } else if (this.getPlatformContext().isCluster(targetName)) {
                for (String clusterInstance : loggerMBeansMap.keySet()) {
                    filteredLoggerObjectNames = (ObjectName[])loggerMBeansMap.get(clusterInstance);
                    this.setLoggerLevelsForInstance(filteredLoggerObjectNames, loggerCustomName, logLevel);
                }
            } else {
                filteredLoggerObjectNames = (ObjectName[])loggerMBeansMap.get(targetName);
                this.setLoggerLevelsForInstance(filteredLoggerObjectNames, loggerCustomName, logLevel);
            }
        } else {
            Exception exception = this.createManagementException("ui.mbean.extension.setComponentLoggerLevel.error", null, null);
            throw new ManagementRemoteException((Throwable)exception);
        }
    }

    private void setLoggerLevelsForInstance(ObjectName[] loggerObjectNames, String loggerCustomName, Level logLevel) throws ManagementRemoteException {
        if (loggerObjectNames != null && loggerObjectNames.length > 0) {
            for (ObjectName loggerObjectName : loggerObjectNames) {
                this.checkForValidTarget(loggerObjectName, "domain");
                Object[] args = new Object[]{loggerCustomName};
                String[] signature = new String[]{"java.lang.String"};
                this.invokeMBeanOperation(loggerObjectName, this.setLevel(logLevel), args, signature);
            }
        }
    }

    public boolean setRuntimeConfiguration(Properties parameters, String targetName) throws ManagementRemoteException {
        return this.setRuntimeConfigurationInternal(parameters, targetName);
    }

    public void setRuntimeLoggerLevel(String runtimeLoggerName, Level logLevel, String targetName, String targetInstanceName) throws ManagementRemoteException {
        this.setRuntimeLoggerLevel(runtimeLoggerName, logLevel, targetName);
    }

    public void setRuntimeLoggerLevel(String runtimeLoggerName, Level logLevel, String targetName) throws ManagementRemoteException {
        Exception exception;
        ConfigurationServiceMBeanImpl.logDebug("setRuntimeLoggerLevel(" + runtimeLoggerName + ")");
        TargetType type = this.checkTargetType(targetName);
        String[] args = new String[]{targetName};
        boolean updated = false;
        switch (type) {
            case CLUSTERED_SERVER: {
                try {
                    if (!this.getPlatformContext().isInstanceUp(targetName)) {
                        exception = this.createManagementException("ui.mbean.target.down", args, null);
                    }
                    ObjectName[] loggers = this.getSystemLoggerMBeans(targetName);
                    for (int index = 0; index < loggers.length; ++index) {
                        String loggerName = null;
                        try {
                            this.checkForValidTarget(loggers[index], "domain");
                            loggerName = (String)this.invokeMBeanOperation(loggers[index], "getLoggerName");
                            ConfigurationServiceMBeanImpl.logDebug("loggers[" + index + "]: name = " + loggerName);
                            if (!loggerName.equals(runtimeLoggerName)) continue;
                            ConfigurationServiceMBeanImpl.logDebug("Found the matching logger.");
                            this.invokeMBeanOperation(loggers[index], this.setLevel(logLevel));
                            updated = true;
                            continue;
                        }
                        catch (ManagementRemoteException exception2) {
                            ConfigurationServiceMBeanImpl.logDebug("ManagementRemoteException");
                            ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)exception2));
                            continue;
                        }
                        catch (RuntimeException exception3) {
                            ConfigurationServiceMBeanImpl.logDebug("RuntimeException");
                            ConfigurationServiceMBeanImpl.logDebug(exception3);
                        }
                    }
                    break;
                }
                catch (Exception ex) {
                    throw ManagementRemoteException.filterJmxExceptions((Exception)ex);
                }
            }
            case INVALID_TARGET: {
                ConfigurationServiceMBeanImpl.logDebug("setRuntimeLoggerLevels(): target " + targetName + " type not supported.");
                Exception exception4 = this.createManagementException("ui.mbean.invalid.target.error", args, null);
                throw new ManagementRemoteException((Throwable)exception4);
            }
            default: {
                ObjectName loggerCfgFacade = this.getRuntimeLoggerConfigFacadeMBeanName(targetName);
                AttributeList attribList = new AttributeList();
                Attribute attrib = new Attribute(runtimeLoggerName, null == logLevel ? "DEFAULT" : logLevel.getName());
                attribList.add(attrib);
                AttributeList updatedAttribs = this.setMBeanAttributes(this.environmentContext.getMBeanServer(), loggerCfgFacade, attribList);
                if (updatedAttribs == null) break;
                for (Object updatedObj : updatedAttribs) {
                    Attribute updatedAttrib = (Attribute)updatedObj;
                    if (!updatedAttrib.getName().equals(attrib.getName())) continue;
                    updated = true;
                }
            }
        }
        if (!updated) {
            exception = this.createManagementException("ui.mbean.logger.id.does.not.exist", new String[]{runtimeLoggerName}, null);
            throw new ManagementRemoteException((Throwable)exception);
        }
    }

    public String getRuntimeLoggerDisplayName(String runtimeLoggerName, String targetName, String targetInstanceName) throws ManagementRemoteException {
        return this.getRuntimeLoggerDisplayName(runtimeLoggerName, targetName);
    }

    public String verifyApplication(String applicationURL, boolean generateTemplates, String templateDir, boolean includeDeployCommand, String targetName, String clientSAFilePath) throws ManagementRemoteException {
        String result = null;
        JBIApplicationVerifier verifier = new JBIApplicationVerifier(this.environmentContext);
        CompositeData data = null;
        try {
            this.domainTargetCheck(targetName);
            data = verifier.verifyApplication(applicationURL, targetName, generateTemplates, templateDir, includeDeployCommand, clientSAFilePath);
        }
        catch (Exception ManagementRemoteException2) {
            throw new ManagementRemoteException((Throwable)ManagementRemoteException2);
        }
        if (data != null) {
            ApplicationVerificationReport report = null;
            report = new ApplicationVerificationReport(data);
            try {
                result = ApplicationVerificationReportWriter.serialize((ApplicationVerificationReport)report);
            }
            catch (ParserConfigurationException e) {
                throw new ManagementRemoteException((Throwable)e);
            }
            catch (TransformerException e) {
                throw new ManagementRemoteException((Throwable)e);
            }
        }
        return result;
    }

    protected ObjectName getComponentConfigurationFacadeMBeanName(String componentName, String targetName) throws ManagementRemoteException {
        this.domainTargetCheck(targetName);
        ObjectName objName = null;
        boolean isTargetCluserInstance = ConfigurationServiceMBeanImpl.getEnvironmentContext().getPlatformContext().isClusteredServer(targetName);
        ConfigurationServiceMBeanImpl.logDebug("Get Component Configuration MBean Name for component " + componentName);
        ObjectName extensionMBeanObjectName = null;
        if (isTargetCluserInstance) {
            String cluster = ConfigurationServiceMBeanImpl.getEnvironmentContext().getPlatformContext().getTargetName(targetName);
            extensionMBeanObjectName = this.getExtensionMBeanObjectName(componentName, cluster);
        } else {
            extensionMBeanObjectName = this.getExtensionMBeanObjectName(componentName, targetName);
        }
        if (!this.isMBeanRegistered(extensionMBeanObjectName)) {
            return objName;
        }
        ConfigurationServiceMBeanImpl.logDebug("Calling getComponentConfigurationFacadeMBeanName on extensionMBeanObjectName = " + extensionMBeanObjectName);
        objName = (ObjectName)this.invokeMBeanOperation(extensionMBeanObjectName, "getComponentConfigurationFacadeMBeanName", targetName);
        return objName;
    }

    protected Properties getComponentConfigurationForClusteredServer(String componentName, String targetName) throws ManagementRemoteException {
        Properties result = null;
        ConfigurationServiceMBeanImpl.logDebug("Entering getComponentConfigurationForClusteredServer(" + componentName + ", " + targetName + ")...");
        try {
            ObjectName configMBeanName = this.getConfigMBeanName(componentName, targetName);
            MBeanServerConnection mbns = this.getPlatformContext().getMBeanServerConnection(targetName);
            result = this.getMBeanAttributeValues(mbns, configMBeanName);
            ConfigurationServiceMBeanImpl.logDebug("getComponentConfigurationForClusteredServer: result properties = " + result);
        }
        catch (ManagementRemoteException jbiRE) {
            ConfigurationServiceMBeanImpl.logDebug("caught ManagementRemoteException:");
            ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
            throw jbiRE;
        }
        catch (Exception ex) {
            Exception exception = this.createManagementException("ui.mbean.install.config.mbean.error.get.attrs.error", null, ex);
            ManagementRemoteException remoteException = new ManagementRemoteException((Throwable)exception);
            throw remoteException;
        }
        return result;
    }

    protected ObjectName getConfigMBeanName(String componentName, String targetName) throws ManagementRemoteException {
        ConfigurationServiceMBeanImpl.logDebug("getConfigMBeanName(" + componentName + ", " + targetName + ")...");
        String clusterName = this.getPlatformContext().getTargetName(targetName);
        ObjectName result = null;
        if (!this.isExistingComponent(componentName, clusterName)) {
            String[] args = new String[]{componentName};
            Exception exception = this.createManagementException("ui.mbean.component.id.does.not.exist", args, null);
            ConfigurationServiceMBeanImpl.logDebug(exception);
            throw new ManagementRemoteException((Throwable)exception);
        }
        String state = "Unknown";
        try {
            ObjectName lifeCycleMBeanObjectName = null;
            lifeCycleMBeanObjectName = this.getComponentLifeCycleMBeanObjectName(componentName, clusterName);
            state = (String)this.getMBeanAttribute(lifeCycleMBeanObjectName, "CurrentState");
        }
        catch (ManagementRemoteException exception) {
            state = "Unknown";
        }
        if ("Running".equals(state)) {
            state = "Started";
        }
        ConfigurationServiceMBeanImpl.logDebug("state of component " + componentName + " on target " + targetName + " = " + state);
        if (!"Started".equals(state)) {
            String[] args = new String[]{componentName};
            Exception exception = this.createManagementException("ui.mbean.component.id.not.started.state", args, null);
            ConfigurationServiceMBeanImpl.logDebug(exception);
            throw new ManagementRemoteException((Throwable)exception);
        }
        try {
            MBeanServerConnection mbns = this.getPlatformContext().getMBeanServerConnection(targetName);
            Map<Object, Object> clusterMBeans = new HashMap();
            try {
                String target = this.getPlatformContext().getTargetName(targetName);
                clusterMBeans = this.getComponentExtensionMBeanObjectNames(componentName, "Configuration", target);
            }
            catch (Exception ex) {
                ConfigurationServiceMBeanImpl.logDebug(ex);
            }
            ObjectName[] clusteredInstanceMBeans = (ObjectName[])clusterMBeans.get(targetName);
            if (clusteredInstanceMBeans.length > 0) {
                if (clusteredInstanceMBeans.length > 1) {
                    ConfigurationServiceMBeanImpl.logDebug("More than one component configuration MBean registered for component " + componentName);
                }
                result = clusteredInstanceMBeans[0];
            } else {
                ObjectName ebiPattern = null;
                try {
                    ebiPattern = new ObjectName("com.sun.ebi:ServiceType=Configuration,IdentificationName=" + componentName + ",*");
                }
                catch (Exception ex) {
                    ConfigurationServiceMBeanImpl.logDebug(ex);
                }
                Set<ObjectName> ebiNames = mbns.queryNames(ebiPattern, null);
                if (!ebiNames.isEmpty()) {
                    if (ebiNames.size() > 1) {
                        ConfigurationServiceMBeanImpl.logDebug("More than one MBean matches ebi pattern " + ebiPattern + ": " + this.convertToString(ebiNames));
                    }
                    result = ebiNames.iterator().next();
                }
            }
            if (result == null) {
                String[] args = new String[]{componentName, targetName};
                Exception exception = this.createManagementException("ui.mbean.component.cannot.find.config.mbean", args, null);
                ConfigurationServiceMBeanImpl.logDebug(exception);
                throw new ManagementRemoteException((Throwable)exception);
            }
        }
        catch (ManagementRemoteException jbiRE) {
            ConfigurationServiceMBeanImpl.logDebug("caught ManagementRemoteException:");
            ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
            throw jbiRE;
        }
        catch (Exception ex) {
            Exception exception = this.createManagementException("ui.mbean.install.config.mbean.error.get.attrs.error", null, ex);
            ManagementRemoteException remoteException = new ManagementRemoteException((Throwable)exception);
            throw remoteException;
        }
        ConfigurationServiceMBeanImpl.logDebug("getConfigMBeanName() returning " + result);
        return result;
    }

    protected String convertToString(Collection colxn) {
        StringBuffer strBuf = new StringBuffer("[ ");
        if (!colxn.isEmpty()) {
            Iterator itr = colxn.iterator();
            while (itr.hasNext()) {
                strBuf.append(itr.next().toString());
                if (itr.hasNext()) {
                    strBuf.append(",  ");
                    continue;
                }
                strBuf.append("  ");
            }
        }
        strBuf.append(" ]");
        return strBuf.toString();
    }

    @Override
    protected ObjectName getExtensionMBeanObjectName(String componentName, String targetName) throws ManagementRemoteException {
        return super.getExtensionMBeanObjectName(componentName, targetName);
    }

    protected Properties getConfigurationAttributeValues(ObjectName objectName) throws ManagementRemoteException {
        Properties properties = new Properties();
        MBeanServer mbeanServer = this.environmentContext.getMBeanServer();
        try {
            properties = this.getMBeanAttributeValues(mbeanServer, objectName);
        }
        catch (ManagementRemoteException exception) {
            properties = new Properties();
            JBIManagementMessage mgmtMsg = null;
            mgmtMsg = exception.extractJBIManagementMessage();
            properties.setProperty("com.sun.jbi.cluster.instance.error", mgmtMsg.getMessage());
        }
        return properties;
    }

    protected Map<String, Object> getConfigurationAttributeValuesAsMap(ObjectName objectName) throws ManagementRemoteException {
        HashMap<String, Object> properties = null;
        properties = new HashMap();
        MBeanServer mbeanServer = this.environmentContext.getMBeanServer();
        try {
            properties = this.getMBeanAttributeValuesAsMap(mbeanServer, objectName);
        }
        catch (ManagementRemoteException exception) {
            properties = new HashMap();
            JBIManagementMessage mgmtMsg = null;
            mgmtMsg = exception.extractJBIManagementMessage();
            properties.put("com.sun.jbi.cluster.instance.error", mgmtMsg.getMessage());
        }
        return properties;
    }

    protected Properties getDefaultRuntimeConfigurationInternal(String targetName) throws ManagementRemoteException {
        MBeanAttributeInfo[] deploymentAttributes;
        MBeanAttributeInfo[] installationAttributes;
        String DEFAULT_VALUE_KEY = "default";
        Properties properties = new Properties();
        ObjectName systemObjectName = null;
        ObjectName installationObjectName = null;
        ObjectName deploymentObjectName = null;
        String SYSTEM_TYPE = "System";
        String INSTALLATION_TYPE = "Installation";
        String DEPLOYMENT_TYPE = "Deployment";
        systemObjectName = this.getConfigurationMBeanObjectName(targetName, SYSTEM_TYPE);
        installationObjectName = this.getConfigurationMBeanObjectName(targetName, INSTALLATION_TYPE);
        deploymentObjectName = this.getConfigurationMBeanObjectName(targetName, DEPLOYMENT_TYPE);
        MBeanServer mbeanServer = this.environmentContext.getMBeanServer();
        MBeanInfo mbeanSystemInfo = null;
        MBeanInfo mbeanInstallationInfo = null;
        MBeanInfo mbeanDeploymentInfo = null;
        try {
            mbeanSystemInfo = mbeanServer.getMBeanInfo(systemObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (IntrospectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (ReflectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        try {
            mbeanInstallationInfo = mbeanServer.getMBeanInfo(installationObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (IntrospectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (ReflectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        try {
            mbeanDeploymentInfo = mbeanServer.getMBeanInfo(deploymentObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (IntrospectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (ReflectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        MBeanAttributeInfo[] systemAttributes = mbeanSystemInfo.getAttributes();
        if (systemAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : systemAttributes) {
                Descriptor descriptor;
                String[] fields;
                String attributeName = attributeInfo.getName();
                if (!(attributeInfo instanceof ModelMBeanAttributeInfo) || (fields = (descriptor = ((ModelMBeanAttributeInfo)attributeInfo).getDescriptor()).getFieldNames()) == null) continue;
                for (String fieldName : fields) {
                    Object value = descriptor.getFieldValue(fieldName);
                    if (!"default".equals(fieldName) || value == null) continue;
                    properties.setProperty(attributeName, value + "");
                }
            }
        }
        if ((installationAttributes = mbeanInstallationInfo.getAttributes()) != null) {
            for (MBeanAttributeInfo attributeInfo : installationAttributes) {
                Descriptor descriptor;
                String[] fields;
                String attributeName = attributeInfo.getName();
                if (!(attributeInfo instanceof ModelMBeanAttributeInfo) || (fields = (descriptor = ((ModelMBeanAttributeInfo)attributeInfo).getDescriptor()).getFieldNames()) == null) continue;
                for (String fieldName : fields) {
                    Object value = descriptor.getFieldValue(fieldName);
                    if (!"default".equals(fieldName) || value == null) continue;
                    properties.setProperty(attributeName, value + "");
                }
            }
        }
        if ((deploymentAttributes = mbeanDeploymentInfo.getAttributes()) != null) {
            for (MBeanAttributeInfo attributeInfo : deploymentAttributes) {
                Descriptor descriptor;
                String[] fields;
                String attributeName = attributeInfo.getName();
                if (!(attributeInfo instanceof ModelMBeanAttributeInfo) || (fields = (descriptor = ((ModelMBeanAttributeInfo)attributeInfo).getDescriptor()).getFieldNames()) == null) continue;
                for (String fieldName : fields) {
                    Object value = descriptor.getFieldValue(fieldName);
                    if (!"default".equals(fieldName) || value == null) continue;
                    properties.setProperty(attributeName, value + "");
                }
            }
        }
        return properties;
    }

    public ObjectName getConfigurationMBeanObjectName(String targetName, String configurationType) throws ManagementRemoteException {
        ObjectName configurationMBeanObjectName = null;
        String objectNameString = "com.sun.jbi:Target=" + targetName + "," + "ServiceName" + "=" + "ConfigurationService" + "," + "ServiceType" + "=" + configurationType;
        try {
            configurationMBeanObjectName = new ObjectName(objectNameString);
        }
        catch (MalformedObjectNameException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (NullPointerException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        return configurationMBeanObjectName;
    }

    Properties getRuntimeConfigurationInternal(String targetName) throws ManagementRemoteException {
        MBeanAttributeInfo[] deploymentAttributes;
        MBeanAttributeInfo[] installationAttributes;
        Properties properties = new Properties();
        ObjectName systemObjectName = null;
        ObjectName installationObjectName = null;
        ObjectName deploymentObjectName = null;
        String SYSTEM_TYPE = "System";
        String INSTALLATION_TYPE = "Installation";
        String DEPLOYMENT_TYPE = "Deployment";
        this.validateTargetForRuntimeConfigurationSpport(targetName);
        if (this.checkTargetType(targetName) == TargetType.INVALID_TARGET) {
            ConfigurationServiceMBeanImpl.logDebug("getRuntimeConfigurationInternal(): target " + targetName + " type not supported.");
            String[] args = new String[]{targetName};
            Exception exception = this.createManagementException("ui.mbean.schemaorg_apache_xmlbeans.system.config.target.type.not.supported", args, null);
            throw new ManagementRemoteException((Throwable)exception);
        }
        systemObjectName = this.getConfigurationMBeanObjectName(targetName, SYSTEM_TYPE);
        installationObjectName = this.getConfigurationMBeanObjectName(targetName, INSTALLATION_TYPE);
        deploymentObjectName = this.getConfigurationMBeanObjectName(targetName, DEPLOYMENT_TYPE);
        MBeanServer mbeanServer = this.environmentContext.getMBeanServer();
        MBeanInfo mbeanSystemInfo = null;
        MBeanInfo mbeanInstallationInfo = null;
        MBeanInfo mbeanDeploymentInfo = null;
        try {
            mbeanSystemInfo = mbeanServer.getMBeanInfo(systemObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (IntrospectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (ReflectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        try {
            mbeanInstallationInfo = mbeanServer.getMBeanInfo(installationObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (IntrospectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (ReflectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        try {
            mbeanDeploymentInfo = mbeanServer.getMBeanInfo(deploymentObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (IntrospectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (ReflectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        MBeanAttributeInfo[] systemAttributes = mbeanSystemInfo.getAttributes();
        if (systemAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : systemAttributes) {
                String attributeName = attributeInfo.getName();
                Object attributeValue = this.getAttributeValue(systemObjectName, attributeName);
                properties.setProperty(attributeName, attributeValue + "");
            }
        }
        if ((installationAttributes = mbeanInstallationInfo.getAttributes()) != null) {
            for (MBeanAttributeInfo attributeInfo : installationAttributes) {
                String attributeName = attributeInfo.getName();
                Object attributeValue = this.getAttributeValue(installationObjectName, attributeName);
                properties.setProperty(attributeName, attributeValue + "");
            }
        }
        if ((deploymentAttributes = mbeanDeploymentInfo.getAttributes()) != null) {
            for (MBeanAttributeInfo attributeInfo : deploymentAttributes) {
                String attributeName = attributeInfo.getName();
                Object attributeValue = this.getAttributeValue(deploymentObjectName, attributeName);
                properties.setProperty(attributeName, attributeValue + "");
            }
        }
        return properties;
    }

    Map<String, Properties> getRuntimeConfigurationMetadataInternal(String targetName) throws ManagementRemoteException {
        Object value;
        Descriptor descriptor;
        String[] fields;
        String attributeName;
        Properties properties = null;
        HashMap<String, Properties> result = null;
        result = new HashMap<String, Properties>();
        ObjectName systemObjectName = null;
        ObjectName installationObjectName = null;
        ObjectName deploymentObjectName = null;
        String SYSTEM_TYPE = "System";
        String INSTALLATION_TYPE = "Installation";
        String DEPLOYMENT_TYPE = "Deployment";
        systemObjectName = this.getConfigurationMBeanObjectName(targetName, SYSTEM_TYPE);
        installationObjectName = this.getConfigurationMBeanObjectName(targetName, INSTALLATION_TYPE);
        deploymentObjectName = this.getConfigurationMBeanObjectName(targetName, DEPLOYMENT_TYPE);
        MBeanServer mbeanServer = this.environmentContext.getMBeanServer();
        MBeanInfo mbeanSystemInfo = null;
        MBeanInfo mbeanInstallationInfo = null;
        MBeanInfo mbeanDeploymentInfo = null;
        try {
            mbeanSystemInfo = mbeanServer.getMBeanInfo(systemObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (IntrospectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (ReflectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        try {
            mbeanInstallationInfo = mbeanServer.getMBeanInfo(installationObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (IntrospectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (ReflectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        try {
            mbeanDeploymentInfo = mbeanServer.getMBeanInfo(deploymentObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (IntrospectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (ReflectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        MBeanAttributeInfo[] systemAttributes = mbeanSystemInfo.getAttributes();
        MBeanAttributeInfo[] installationAttributes = mbeanInstallationInfo.getAttributes();
        MBeanAttributeInfo[] deploymentAttributes = mbeanDeploymentInfo.getAttributes();
        if (systemAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : systemAttributes) {
                attributeName = attributeInfo.getName();
                if (attributeName == null) continue;
                properties = new Properties();
                if (attributeInfo instanceof ModelMBeanAttributeInfo && (fields = (descriptor = ((ModelMBeanAttributeInfo)attributeInfo).getDescriptor()).getFieldNames()) != null) {
                    for (String fieldName : fields) {
                        value = descriptor.getFieldValue(fieldName);
                        if (fieldName == null || value == null) continue;
                        properties.setProperty(fieldName, value + "");
                    }
                }
                result.put(attributeName, properties);
            }
        }
        if (installationAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : installationAttributes) {
                attributeName = attributeInfo.getName();
                if (attributeName == null) continue;
                properties = new Properties();
                if (attributeInfo instanceof ModelMBeanAttributeInfo && (fields = (descriptor = ((ModelMBeanAttributeInfo)attributeInfo).getDescriptor()).getFieldNames()) != null) {
                    for (String fieldName : fields) {
                        value = descriptor.getFieldValue(fieldName);
                        if (fieldName == null || value == null) continue;
                        properties.setProperty(fieldName, value + "");
                    }
                }
                result.put(attributeName, properties);
            }
        }
        if (deploymentAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : deploymentAttributes) {
                attributeName = attributeInfo.getName();
                if (attributeName == null) continue;
                properties = new Properties();
                if (attributeInfo instanceof ModelMBeanAttributeInfo && (fields = (descriptor = ((ModelMBeanAttributeInfo)attributeInfo).getDescriptor()).getFieldNames()) != null) {
                    for (String fieldName : fields) {
                        value = descriptor.getFieldValue(fieldName);
                        if (fieldName == null || value == null) continue;
                        properties.setProperty(fieldName, value + "");
                    }
                }
                result.put(attributeName, properties);
            }
        }
        return result;
    }

    public ObjectName getLoggingServiceMBeanObjectName(String targetName) {
        ObjectName loggingMBeanObjectName = null;
        String loggingString = "com.sun.jbi:JbiName=" + targetName + "," + "ServiceName" + "=" + "LoggingService" + "," + "ControlType" + "=" + "LoggingService" + "," + "ComponentType" + "=" + "System";
        try {
            loggingMBeanObjectName = new ObjectName(loggingString);
        }
        catch (Exception exception) {
            ConfigurationServiceMBeanImpl.logDebug(exception);
        }
        return loggingMBeanObjectName;
    }

    String setComponentConfigurationForClusteredServer(String componentName, String targetName, Properties configurationValues) throws ManagementRemoteException {
        String result = null;
        AttributeList list = null;
        ConfigurationServiceMBeanImpl.logDebug("Entering setComponentConfigurationForClusteredServer(" + componentName + ", " + targetName + ")...");
        try {
            ObjectName configMBeanName = this.getConfigMBeanName(componentName, targetName);
            MBeanServerConnection mbns = this.getPlatformContext().getMBeanServerConnection(targetName);
            list = this.constructMBeanAttributes(mbns, configMBeanName, configurationValues);
            this.setMBeanAttributes(mbns, configMBeanName, list);
            result = this.createManagementMessage("setComponentConfiguration", true, "INFO", "ui.mbean.component.set.attribute.success", new Object[]{componentName});
            ConfigurationServiceMBeanImpl.logDebug("setComponentConfigurationForClusteredServer(): result = " + result);
        }
        catch (ManagementRemoteException jbiRE) {
            ConfigurationServiceMBeanImpl.logDebug("caught ManagementRemoteException:");
            ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
            Exception jbiMgmtEx = this.createManagementException("ui.mbean.component.set.attribute.error", new String[]{componentName, jbiRE.toString()}, (Exception)((Object)jbiRE));
            throw new ManagementRemoteException((Throwable)jbiMgmtEx);
        }
        catch (Exception ex) {
            Exception exception = this.createManagementException("ui.mbean.component.set.attribute.error", null, ex);
            ManagementRemoteException remoteException = new ManagementRemoteException((Throwable)exception);
            throw remoteException;
        }
        return result;
    }

    @Override
    protected String setLevel(Level logLevel) {
        if (null == logLevel) {
            return "setDefault";
        }
        if (Level.OFF.equals(logLevel)) {
            return "setOff";
        }
        if (Level.SEVERE.equals(logLevel)) {
            return "setSevere";
        }
        if (Level.WARNING.equals(logLevel)) {
            return "setWarning";
        }
        if (Level.INFO.equals(logLevel)) {
            return "setInfo";
        }
        if (Level.CONFIG.equals(logLevel)) {
            return "setConfig";
        }
        if (Level.FINE.equals(logLevel)) {
            return "setFine";
        }
        if (Level.FINER.equals(logLevel)) {
            return "setFiner";
        }
        if (Level.FINEST.equals(logLevel)) {
            return "setFinest";
        }
        if (Level.ALL.equals(logLevel)) {
            return "setAll";
        }
        return "setDefault";
    }

    protected boolean setRuntimeConfigurationInternal(Properties properties, String targetName) throws ManagementRemoteException {
        String type;
        String stringValue;
        String attributeName;
        String type2;
        String stringValue2;
        String attributeName2;
        ObjectName systemObjectName = null;
        ObjectName installationObjectName = null;
        ObjectName deploymentObjectName = null;
        String SYSTEM_TYPE = "System";
        String INSTALLATION_TYPE = "Installation";
        String DEPLOYMENT_TYPE = "Deployment";
        this.validateTargetForRuntimeConfigurationSpport(targetName);
        if (this.checkTargetType(targetName) == TargetType.INVALID_TARGET) {
            ConfigurationServiceMBeanImpl.logDebug("setRuntimeConfigurationInternal(): target " + targetName + " type not supported.");
            String[] args = new String[]{targetName};
            Exception exception = this.createManagementException("ui.mbean.schemaorg_apache_xmlbeans.system.config.target.type.not.supported", args, null);
            throw new ManagementRemoteException((Throwable)exception);
        }
        systemObjectName = this.getConfigurationMBeanObjectName(targetName, "System");
        installationObjectName = this.getConfigurationMBeanObjectName(targetName, "Installation");
        deploymentObjectName = this.getConfigurationMBeanObjectName(targetName, "Deployment");
        MBeanServer mbeanServer = this.environmentContext.getMBeanServer();
        MBeanInfo mbeanSystemInfo = null;
        MBeanInfo mbeanInstallationInfo = null;
        MBeanInfo mbeanDeploymentInfo = null;
        try {
            mbeanSystemInfo = mbeanServer.getMBeanInfo(systemObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (IntrospectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (ReflectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        try {
            mbeanInstallationInfo = mbeanServer.getMBeanInfo(installationObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (IntrospectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (ReflectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        try {
            mbeanDeploymentInfo = mbeanServer.getMBeanInfo(deploymentObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (IntrospectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (ReflectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        Object attributeValueObject = null;
        MBeanAttributeInfo[] systemAttributes = mbeanSystemInfo.getAttributes();
        MBeanAttributeInfo[] installationAttributes = mbeanInstallationInfo.getAttributes();
        MBeanAttributeInfo[] deploymentAttributes = mbeanDeploymentInfo.getAttributes();
        HashMap<String, Object> attributeNameTypeMap = new HashMap<String, Object>();
        Properties metaDataProperties = null;
        if (systemAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : systemAttributes) {
                attributeName2 = attributeInfo.getName();
                stringValue2 = properties.getProperty(attributeName2);
                if (stringValue2 == null) continue;
                type2 = attributeInfo.getType();
                try {
                    attributeValueObject = Util.newInstance((String)type2, (String)stringValue2);
                    attributeNameTypeMap.put(attributeName2, attributeValueObject);
                }
                catch (Exception ex) {
                    String[] args = new String[]{stringValue2, type2, attributeName2};
                    Exception exception = this.createManagementException("ui.mbean.install.config.mbean.attrib.type.convertion.error", args, ex);
                    throw new ManagementRemoteException((Throwable)exception);
                }
            }
        }
        if (installationAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : installationAttributes) {
                attributeName2 = attributeInfo.getName();
                stringValue2 = properties.getProperty(attributeName2);
                if (stringValue2 == null) continue;
                type2 = attributeInfo.getType();
                try {
                    attributeValueObject = Util.newInstance((String)type2, (String)stringValue2);
                    attributeNameTypeMap.put(attributeName2, attributeValueObject);
                }
                catch (Exception ex) {
                    String[] args = new String[]{stringValue2, type2, attributeName2};
                    Exception exception = this.createManagementException("ui.mbean.install.config.mbean.attrib.type.convertion.error", args, ex);
                    throw new ManagementRemoteException((Throwable)exception);
                }
            }
        }
        if (deploymentAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : deploymentAttributes) {
                attributeName2 = attributeInfo.getName();
                stringValue2 = properties.getProperty(attributeName2);
                if (stringValue2 == null) continue;
                type2 = attributeInfo.getType();
                try {
                    attributeValueObject = Util.newInstance((String)type2, (String)stringValue2);
                    attributeNameTypeMap.put(attributeName2, attributeValueObject);
                }
                catch (Exception ex) {
                    String[] args = new String[]{stringValue2, type2, attributeName2};
                    Exception exception = this.createManagementException("ui.mbean.install.config.mbean.attrib.type.convertion.error", args, ex);
                    throw new ManagementRemoteException((Throwable)exception);
                }
            }
        }
        Set<Object> keySet = properties.keySet();
        Set attributeSet = attributeNameTypeMap.keySet();
        if (keySet != null) {
            for (Object keyObject : keySet) {
                String key = (String)keyObject;
                if (attributeSet.contains(key)) continue;
                String[] args = new String[]{key};
                Exception exception = this.createManagementException("ui.mbean.runtime.config.mbean.attrib.key.invalid.error", args, null);
                throw new ManagementRemoteException((Throwable)exception);
            }
        }
        String IS_STATIC_KEY = "isStatic";
        boolean isRestartRequired = false;
        Map<String, Properties> metadata = null;
        metadata = this.getRuntimeConfigurationMetadataInternal(targetName);
        if (systemAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : systemAttributes) {
                attributeName = attributeInfo.getName();
                stringValue = properties.getProperty(attributeName);
                if (stringValue == null) continue;
                type = attributeInfo.getType();
                try {
                    attributeValueObject = Util.newInstance((String)type, (String)stringValue);
                }
                catch (Exception ex) {
                    String[] args = new String[]{stringValue, type, attributeName};
                    Exception exception = this.createManagementException("ui.mbean.install.config.mbean.attrib.type.convertion.error", args, ex);
                    throw new ManagementRemoteException((Throwable)exception);
                }
                this.setAttributeValue(systemObjectName, attributeName, attributeValueObject);
                metaDataProperties = metadata.get(attributeName);
                if (!Boolean.valueOf(metaDataProperties.getProperty("isStatic")).booleanValue()) continue;
                isRestartRequired = true;
            }
        }
        if (installationAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : installationAttributes) {
                attributeName = attributeInfo.getName();
                stringValue = properties.getProperty(attributeName);
                if (stringValue == null) continue;
                type = attributeInfo.getType();
                try {
                    attributeValueObject = Util.newInstance((String)type, (String)stringValue);
                }
                catch (Exception ex) {
                    String[] args = new String[]{stringValue, type, attributeName};
                    Exception exception = this.createManagementException("ui.mbean.install.config.mbean.attrib.type.convertion.error", args, ex);
                    throw new ManagementRemoteException((Throwable)exception);
                }
                this.setAttributeValue(installationObjectName, attributeName, attributeValueObject);
                metaDataProperties = metadata.get(attributeName);
                if (!Boolean.valueOf(metaDataProperties.getProperty("isStatic")).booleanValue()) continue;
                isRestartRequired = true;
            }
        }
        if (deploymentAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : deploymentAttributes) {
                attributeName = attributeInfo.getName();
                stringValue = properties.getProperty(attributeName);
                if (stringValue == null) continue;
                type = attributeInfo.getType();
                try {
                    attributeValueObject = Util.newInstance((String)type, (String)stringValue);
                }
                catch (Exception ex) {
                    String[] args = new String[]{stringValue, type, attributeName};
                    Exception exception = this.createManagementException("ui.mbean.install.config.mbean.attrib.type.convertion.error", args, ex);
                    throw new ManagementRemoteException((Throwable)exception);
                }
                this.setAttributeValue(deploymentObjectName, attributeName, attributeValueObject);
                metaDataProperties = metadata.get(attributeName);
                if (!Boolean.valueOf(metaDataProperties.getProperty("isStatic")).booleanValue()) continue;
                isRestartRequired = true;
            }
        }
        return isRestartRequired;
    }

    protected Map<String, Properties> getApplicationConfigurationsMap(TabularData td) {
        HashMap<String, Properties> configMap = new HashMap<String, Properties>();
        Set<?> configKeys = td.keySet();
        if (configKeys != null) {
            for (Object configKey : configKeys) {
                List keyList = (List)configKey;
                Object[] index = new String[keyList.size()];
                index = keyList.toArray(index);
                CompositeData cd = td.get(index);
                Properties configProps = this.componentConfigurationHelper.convertCompositeDataToProperties(cd);
                configMap.put((String)index[0], configProps);
            }
        }
        return configMap;
    }

    public String retrieveConfigurationDisplaySchema(String componentName, String targetName) throws ManagementRemoteException {
        this.domainTargetCheck(targetName);
        String schema = "";
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("retrieveConfigurationDisplaySchema(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            try {
                Object[] params = new Object[]{componentName, targetName};
                String[] signature = new String[]{"java.lang.String", "java.lang.String"};
                schema = (String)this.invokeMBeanOperation(configFacadeMBean, "retrieveConfigurationDisplaySchema", params, signature);
            }
            catch (ManagementRemoteException jbiRE) {
                ConfigurationServiceMBeanImpl.logDebug("retrieveConfigurationDisplaySchema caught ManagementRemoteException:");
                throw jbiRE;
            }
            catch (Exception ex) {
                ConfigurationServiceMBeanImpl.logDebug("retrieveConfigurationDisplaySchema caught non-ManagementRemoteException:");
                throw new ManagementRemoteException((Throwable)ex);
            }
        } else {
            String[] args = new String[]{componentName, targetName};
            Exception mgmtEx = this.createManagementException("ui.mbean.component.configuration.mbean.not.found.error", args, null);
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        return schema;
    }

    public String retrieveConfigurationDisplayData(String componentName, String targetName) throws ManagementRemoteException {
        this.domainTargetCheck(targetName);
        String data = "";
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("retrieveConfigurationDisplayData(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            try {
                Object[] params = new Object[]{componentName, targetName};
                String[] signature = new String[]{"java.lang.String", "java.lang.String"};
                data = (String)this.invokeMBeanOperation(configFacadeMBean, "retrieveConfigurationDisplayData", params, signature);
            }
            catch (ManagementRemoteException jbiRE) {
                ConfigurationServiceMBeanImpl.logDebug("retrieveConfigurationDisplayData caught ManagementRemoteException:");
                throw jbiRE;
            }
            catch (Exception ex) {
                ConfigurationServiceMBeanImpl.logDebug("retrieveConfigurationDisplayData caught non-ManagementRemoteException:");
                throw new ManagementRemoteException((Throwable)ex);
            }
        } else {
            String[] args = new String[]{componentName, targetName};
            Exception mgmtEx = this.createManagementException("ui.mbean.component.configuration.mbean.not.found.error", args, null);
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        return data;
    }

    public String addApplicationConfiguration(String componentName, String targetName, String name, CompositeData appConfig) throws ManagementRemoteException {
        this.domainTargetCheck(targetName);
        if (!this.isAppConfigSupported(componentName, targetName)) {
            Exception mgmtEx = this.createManagementException("ui.mbean.component.set.app.config.not.supported", new String[]{componentName, targetName}, null);
            ConfigurationServiceMBeanImpl.logDebug(mgmtEx.getMessage());
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        String jbiMgmtMsgResult = null;
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("addApplicationConfiguration(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            try {
                jbiMgmtMsgResult = (String)this.invokeMBeanOperation(configFacadeMBean, "addApplicationConfiguration", new Object[]{name, appConfig}, new String[]{"java.lang.String", "javax.management.openmbean.CompositeData"});
                ConfigurationServiceMBeanImpl.logDebug("addApplicationConfiguration(): result = " + jbiMgmtMsgResult);
                return jbiMgmtMsgResult;
            }
            catch (ManagementRemoteException jbiRE) {
                ConfigurationServiceMBeanImpl.logDebug("addApplicationConfiguration caught ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
                throw jbiRE;
            }
            catch (Exception ex) {
                ConfigurationServiceMBeanImpl.logDebug("addApplicationConfiguration  caught non-ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug(ex);
                String[] args = new String[]{name, componentName, targetName};
                Exception mgmtEx = this.createManagementException("ui.mbean.component.add.app.config.error", args, ex);
                throw new ManagementRemoteException((Throwable)mgmtEx);
            }
        }
        String[] args = new String[]{componentName, targetName};
        Exception mgmtEx = this.createManagementException("ui.mbean.component.configuration.mbean.not.found.error", args, null);
        throw new ManagementRemoteException((Throwable)mgmtEx);
    }

    public String setApplicationConfiguration(String componentName, String targetName, String name, CompositeData appConfig) throws ManagementRemoteException {
        this.domainTargetCheck(targetName);
        if (!this.isAppConfigSupported(componentName, targetName)) {
            Exception mgmtEx = this.createManagementException("ui.mbean.component.set.app.config.not.supported", new String[]{componentName, targetName}, null);
            ConfigurationServiceMBeanImpl.logDebug(mgmtEx.getMessage());
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        String jbiMgmtMsgResult = null;
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("setApplicationConfiguration(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            try {
                jbiMgmtMsgResult = (String)this.invokeMBeanOperation(configFacadeMBean, "setApplicationConfiguration", new Object[]{name, appConfig}, new String[]{"java.lang.String", "javax.management.openmbean.CompositeData"});
                ConfigurationServiceMBeanImpl.logDebug("setApplicationConfiguration(): result = " + jbiMgmtMsgResult);
                return jbiMgmtMsgResult;
            }
            catch (ManagementRemoteException jbiRE) {
                ConfigurationServiceMBeanImpl.logDebug("setApplicationConfiguration caught ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
                throw jbiRE;
            }
            catch (Exception ex) {
                ConfigurationServiceMBeanImpl.logDebug("setApplicationConfiguration  caught non-ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug(ex);
                String[] args = new String[]{name, componentName, targetName};
                Exception mgmtEx = this.createManagementException("ui.mbean.component.set.app.config.error", args, ex);
                throw new ManagementRemoteException((Throwable)mgmtEx);
            }
        }
        String[] args = new String[]{componentName, targetName};
        Exception mgmtEx = this.createManagementException("ui.mbean.component.configuration.mbean.not.found.error", args, null);
        throw new ManagementRemoteException((Throwable)mgmtEx);
    }

    public TabularData getApplicationConfigurationsAsTabularData(String componentName, String targetName) throws ManagementRemoteException {
        this.domainTargetCheck(targetName);
        if (!this.isAppConfigSupported(componentName, targetName)) {
            Exception mgmtEx = this.createManagementException("ui.mbean.component.set.app.config.not.supported", new String[]{componentName, targetName}, null);
            ConfigurationServiceMBeanImpl.logDebug(mgmtEx.getMessage());
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        TabularData td = null;
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("getApplicationConfigurations(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            try {
                Object result = this.getAttributeValue(configFacadeMBean, "ApplicationConfigurations");
                if (result != null) {
                    td = (TabularData)result;
                }
                return td;
            }
            catch (ManagementRemoteException jbiRE) {
                ConfigurationServiceMBeanImpl.logDebug("getApplicationConfigurations caught ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
                throw jbiRE;
            }
            catch (Exception ex) {
                ConfigurationServiceMBeanImpl.logDebug("getApplicationConfigurations  caught non-ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug(ex);
                String[] args = new String[]{componentName, targetName};
                Exception mgmtEx = this.createManagementException("ui.mbean.component.get.app.config.error", args, ex);
                throw new ManagementRemoteException((Throwable)mgmtEx);
            }
        }
        String[] args = new String[]{componentName, targetName};
        Exception mgmtEx = this.createManagementException("ui.mbean.component.configuration.mbean.not.found.error", args, null);
        throw new ManagementRemoteException((Throwable)mgmtEx);
    }

    public TabularData getApplicationVariablesAsTabularData(String componentName, String targetName) throws ManagementRemoteException {
        this.domainTargetCheck(targetName);
        if (!this.isAppVarsSupported(componentName, targetName)) {
            Exception mgmtEx = this.createManagementException("ui.mbean.component.set.app.vars.not.supported", new String[]{componentName, targetName}, null);
            ConfigurationServiceMBeanImpl.logDebug(mgmtEx.getMessage());
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        TabularData appVarTable = null;
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("getApplicationVariables(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            try {
                appVarTable = (TabularData)this.getAttributeValue(configFacadeMBean, "ApplicationVariables");
                ConfigurationServiceMBeanImpl.logDebug("getApplicationVariables(): result = " + appVarTable);
            }
            catch (ManagementRemoteException jbiRE) {
                ConfigurationServiceMBeanImpl.logDebug("caught ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
                throw jbiRE;
            }
            catch (Exception ex) {
                ConfigurationServiceMBeanImpl.logDebug("caught non-ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug(ex);
                String[] args = new String[]{componentName, targetName};
                Exception exception = this.createManagementException("ui.mbean.component.get.app.vars.error", null, ex);
                ManagementRemoteException remoteException = new ManagementRemoteException((Throwable)exception);
                throw remoteException;
            }
        } else {
            String[] args = new String[]{componentName, targetName};
            Exception mgmtEx = this.createManagementException("ui.mbean.component.configuration.mbean.not.found.error", args, null);
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        return appVarTable;
    }

    public String addApplicationVariable(String componentName, String targetName, String name, CompositeData appVar) throws ManagementRemoteException {
        this.domainTargetCheck(targetName);
        if (!this.isAppVarsSupported(componentName, targetName)) {
            Exception mgmtEx = this.createManagementException("ui.mbean.component.set.app.vars.not.supported", new String[]{componentName, targetName}, null);
            ConfigurationServiceMBeanImpl.logDebug(mgmtEx.getMessage());
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        String jbiMgmtMsgResult = null;
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("addApplicationVariable(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            try {
                jbiMgmtMsgResult = (String)this.invokeMBeanOperation(configFacadeMBean, "addApplicationVariable", new Object[]{name, appVar}, new String[]{"java.lang.String", "javax.management.openmbean.CompositeData"});
                ConfigurationServiceMBeanImpl.logDebug("addApplicationVariable(): result = " + jbiMgmtMsgResult);
                return jbiMgmtMsgResult;
            }
            catch (ManagementRemoteException jbiRE) {
                ConfigurationServiceMBeanImpl.logDebug("addApplicationVariable caught ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
                throw jbiRE;
            }
            catch (Exception ex) {
                ConfigurationServiceMBeanImpl.logDebug("addApplicationVariable  caught non-ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug(ex);
                String[] args = new String[]{name, componentName, targetName};
                Exception mgmtEx = this.createManagementException("ui.mbean.component.add.app.vars.error", args, ex);
                throw new ManagementRemoteException((Throwable)mgmtEx);
            }
        }
        String[] args = new String[]{componentName, targetName};
        Exception mgmtEx = this.createManagementException("ui.mbean.component.configuration.mbean.not.found.error", args, null);
        throw new ManagementRemoteException((Throwable)mgmtEx);
    }

    public String setApplicationVariable(String componentName, String targetName, String name, CompositeData appVar) throws ManagementRemoteException {
        this.domainTargetCheck(targetName);
        if (!this.isAppVarsSupported(componentName, targetName)) {
            Exception mgmtEx = this.createManagementException("ui.mbean.component.set.app.vars.not.supported", new String[]{componentName, targetName}, null);
            ConfigurationServiceMBeanImpl.logDebug(mgmtEx.getMessage());
            throw new ManagementRemoteException((Throwable)mgmtEx);
        }
        String jbiMgmtMsgResult = null;
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("setApplicationVariable(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            try {
                jbiMgmtMsgResult = (String)this.invokeMBeanOperation(configFacadeMBean, "setApplicationVariable", new Object[]{name, appVar}, new String[]{"java.lang.String", "javax.management.openmbean.CompositeData"});
                ConfigurationServiceMBeanImpl.logDebug("setApplicationVariable(): result = " + jbiMgmtMsgResult);
                return jbiMgmtMsgResult;
            }
            catch (ManagementRemoteException jbiRE) {
                ConfigurationServiceMBeanImpl.logDebug("setApplicationVariable caught ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
                throw jbiRE;
            }
            catch (Exception ex) {
                ConfigurationServiceMBeanImpl.logDebug("setApplicationVariable  caught non-ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug(ex);
                String[] args = new String[]{name, componentName, targetName};
                Exception mgmtEx = this.createManagementException("ui.mbean.component.set.app.vars.error", args, ex);
                throw new ManagementRemoteException((Throwable)mgmtEx);
            }
        }
        String[] args = new String[]{componentName, targetName};
        Exception mgmtEx = this.createManagementException("ui.mbean.component.configuration.mbean.not.found.error", args, null);
        throw new ManagementRemoteException((Throwable)mgmtEx);
    }

    public Map<String, Object> getDefaultRuntimeConfigurationAsMap() throws ManagementRemoteException {
        return this.getDefaultRuntimeConfigurationAsMapInternal("domain");
    }

    public Map<String, Object> getDefaultRuntimeConfigurationAsMapInternal(String targetName) throws ManagementRemoteException {
        MBeanAttributeInfo[] deploymentAttributes;
        MBeanAttributeInfo[] installationAttributes;
        String DEFAULT_VALUE_KEY = "default";
        HashMap<String, Object> properties = null;
        properties = new HashMap<String, Object>();
        ObjectName systemObjectName = null;
        ObjectName installationObjectName = null;
        ObjectName deploymentObjectName = null;
        String SYSTEM_TYPE = "System";
        String INSTALLATION_TYPE = "Installation";
        String DEPLOYMENT_TYPE = "Deployment";
        systemObjectName = this.getConfigurationMBeanObjectName(targetName, SYSTEM_TYPE);
        installationObjectName = this.getConfigurationMBeanObjectName(targetName, INSTALLATION_TYPE);
        deploymentObjectName = this.getConfigurationMBeanObjectName(targetName, DEPLOYMENT_TYPE);
        MBeanServer mbeanServer = this.environmentContext.getMBeanServer();
        MBeanInfo mbeanSystemInfo = null;
        MBeanInfo mbeanInstallationInfo = null;
        MBeanInfo mbeanDeploymentInfo = null;
        try {
            mbeanSystemInfo = mbeanServer.getMBeanInfo(systemObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (IntrospectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (ReflectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        try {
            mbeanInstallationInfo = mbeanServer.getMBeanInfo(installationObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (IntrospectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (ReflectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        try {
            mbeanDeploymentInfo = mbeanServer.getMBeanInfo(deploymentObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (IntrospectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (ReflectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        MBeanAttributeInfo[] systemAttributes = mbeanSystemInfo.getAttributes();
        if (systemAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : systemAttributes) {
                Descriptor descriptor;
                String[] fields;
                String attributeName = attributeInfo.getName();
                if (!(attributeInfo instanceof ModelMBeanAttributeInfo) || (fields = (descriptor = ((ModelMBeanAttributeInfo)attributeInfo).getDescriptor()).getFieldNames()) == null) continue;
                for (String fieldName : fields) {
                    Object value = descriptor.getFieldValue(fieldName);
                    if (!"default".equals(fieldName) || value == null) continue;
                    properties.put(attributeName, value);
                }
            }
        }
        if ((installationAttributes = mbeanInstallationInfo.getAttributes()) != null) {
            for (MBeanAttributeInfo attributeInfo : installationAttributes) {
                Descriptor descriptor;
                String[] fields;
                String attributeName = attributeInfo.getName();
                if (!(attributeInfo instanceof ModelMBeanAttributeInfo) || (fields = (descriptor = ((ModelMBeanAttributeInfo)attributeInfo).getDescriptor()).getFieldNames()) == null) continue;
                for (String fieldName : fields) {
                    Object value = descriptor.getFieldValue(fieldName);
                    if (!"default".equals(fieldName) || value == null) continue;
                    properties.put(attributeName, value);
                }
            }
        }
        if ((deploymentAttributes = mbeanDeploymentInfo.getAttributes()) != null) {
            for (MBeanAttributeInfo attributeInfo : deploymentAttributes) {
                Descriptor descriptor;
                String[] fields;
                String attributeName = attributeInfo.getName();
                if (!(attributeInfo instanceof ModelMBeanAttributeInfo) || (fields = (descriptor = ((ModelMBeanAttributeInfo)attributeInfo).getDescriptor()).getFieldNames()) == null) continue;
                for (String fieldName : fields) {
                    Object value = descriptor.getFieldValue(fieldName);
                    if (!"default".equals(fieldName) || value == null) continue;
                    properties.put(attributeName, value);
                }
            }
        }
        return properties;
    }

    public Map<String, Object> getRuntimeConfigurationAsMap(String targetName) throws ManagementRemoteException {
        MBeanAttributeInfo[] deploymentAttributes;
        MBeanAttributeInfo[] installationAttributes;
        HashMap<String, Object> properties = null;
        properties = new HashMap<String, Object>();
        ObjectName systemObjectName = null;
        ObjectName installationObjectName = null;
        ObjectName deploymentObjectName = null;
        String SYSTEM_TYPE = "System";
        String INSTALLATION_TYPE = "Installation";
        String DEPLOYMENT_TYPE = "Deployment";
        this.validateTargetForRuntimeConfigurationSpport(targetName);
        systemObjectName = this.getConfigurationMBeanObjectName(targetName, SYSTEM_TYPE);
        installationObjectName = this.getConfigurationMBeanObjectName(targetName, INSTALLATION_TYPE);
        deploymentObjectName = this.getConfigurationMBeanObjectName(targetName, DEPLOYMENT_TYPE);
        MBeanServer mbeanServer = this.environmentContext.getMBeanServer();
        MBeanInfo mbeanSystemInfo = null;
        MBeanInfo mbeanInstallationInfo = null;
        MBeanInfo mbeanDeploymentInfo = null;
        try {
            mbeanSystemInfo = mbeanServer.getMBeanInfo(systemObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (IntrospectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (ReflectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        try {
            mbeanInstallationInfo = mbeanServer.getMBeanInfo(installationObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (IntrospectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (ReflectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        try {
            mbeanDeploymentInfo = mbeanServer.getMBeanInfo(deploymentObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (IntrospectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (ReflectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        MBeanAttributeInfo[] systemAttributes = mbeanSystemInfo.getAttributes();
        if (systemAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : systemAttributes) {
                String attributeName = attributeInfo.getName();
                Object attributeValue = this.getAttributeValue(systemObjectName, attributeName);
                properties.put(attributeName, attributeValue);
            }
        }
        if ((installationAttributes = mbeanInstallationInfo.getAttributes()) != null) {
            for (MBeanAttributeInfo attributeInfo : installationAttributes) {
                String attributeName = attributeInfo.getName();
                Object attributeValue = this.getAttributeValue(installationObjectName, attributeName);
                properties.put(attributeName, attributeValue);
            }
        }
        if ((deploymentAttributes = mbeanDeploymentInfo.getAttributes()) != null) {
            for (MBeanAttributeInfo attributeInfo : deploymentAttributes) {
                String attributeName = attributeInfo.getName();
                Object attributeValue = this.getAttributeValue(deploymentObjectName, attributeName);
                properties.put(attributeName, attributeValue);
            }
        }
        return properties;
    }

    public boolean setRuntimeConfiguration(Map<String, Object> properties, String targetName) throws ManagementRemoteException {
        String attributeName;
        String type;
        String attributeName2;
        ObjectName systemObjectName = null;
        ObjectName installationObjectName = null;
        ObjectName deploymentObjectName = null;
        String SYSTEM_TYPE = "System";
        String INSTALLATION_TYPE = "Installation";
        String DEPLOYMENT_TYPE = "Deployment";
        this.validateTargetForRuntimeConfigurationSpport(targetName);
        systemObjectName = this.getConfigurationMBeanObjectName(targetName, "System");
        installationObjectName = this.getConfigurationMBeanObjectName(targetName, "Installation");
        deploymentObjectName = this.getConfigurationMBeanObjectName(targetName, "Deployment");
        MBeanServer mbeanServer = this.environmentContext.getMBeanServer();
        MBeanInfo mbeanSystemInfo = null;
        MBeanInfo mbeanInstallationInfo = null;
        MBeanInfo mbeanDeploymentInfo = null;
        try {
            mbeanSystemInfo = mbeanServer.getMBeanInfo(systemObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (IntrospectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (ReflectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        try {
            mbeanInstallationInfo = mbeanServer.getMBeanInfo(installationObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (IntrospectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (ReflectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        try {
            mbeanDeploymentInfo = mbeanServer.getMBeanInfo(deploymentObjectName);
        }
        catch (InstanceNotFoundException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (IntrospectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        catch (ReflectionException exception) {
            throw new ManagementRemoteException((Throwable)exception);
        }
        Object attributeValueObject = null;
        MBeanAttributeInfo[] systemAttributes = mbeanSystemInfo.getAttributes();
        MBeanAttributeInfo[] installationAttributes = mbeanInstallationInfo.getAttributes();
        MBeanAttributeInfo[] deploymentAttributes = mbeanDeploymentInfo.getAttributes();
        HashMap<String, Object> attributeNameTypeMap = new HashMap<String, Object>();
        Properties metaDataProperties = null;
        if (systemAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : systemAttributes) {
                attributeName2 = attributeInfo.getName();
                attributeValueObject = properties.get(attributeName2);
                if (attributeValueObject == null) continue;
                type = attributeInfo.getType();
                try {
                    attributeNameTypeMap.put(attributeName2, attributeValueObject);
                }
                catch (Exception ex) {
                    String[] args = new String[]{attributeValueObject + "", type, attributeName2};
                    Exception exception = this.createManagementException("ui.mbean.install.config.mbean.attrib.type.convertion.error", args, ex);
                    throw new ManagementRemoteException((Throwable)exception);
                }
            }
        }
        if (installationAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : installationAttributes) {
                attributeName2 = attributeInfo.getName();
                attributeValueObject = properties.get(attributeName2);
                if (attributeValueObject == null) continue;
                type = attributeInfo.getType();
                try {
                    attributeNameTypeMap.put(attributeName2, attributeValueObject);
                }
                catch (Exception ex) {
                    String[] args = new String[]{attributeValueObject + "", type, attributeName2};
                    Exception exception = this.createManagementException("ui.mbean.install.config.mbean.attrib.type.convertion.error", args, ex);
                    throw new ManagementRemoteException((Throwable)exception);
                }
            }
        }
        if (deploymentAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : deploymentAttributes) {
                attributeName2 = attributeInfo.getName();
                attributeValueObject = properties.get(attributeName2);
                if (attributeValueObject == null) continue;
                type = attributeInfo.getType();
                try {
                    attributeNameTypeMap.put(attributeName2, attributeValueObject);
                }
                catch (Exception ex) {
                    String[] args = new String[]{attributeValueObject + "", type, attributeName2};
                    Exception exception = this.createManagementException("ui.mbean.install.config.mbean.attrib.type.convertion.error", args, ex);
                    throw new ManagementRemoteException((Throwable)exception);
                }
            }
        }
        Set<String> keySet = properties.keySet();
        Set attributeSet = attributeNameTypeMap.keySet();
        if (keySet != null) {
            for (String keyObject : keySet) {
                String key = keyObject;
                if (attributeSet.contains(key)) continue;
                String[] args = new String[]{key};
                Exception exception = this.createManagementException("ui.mbean.runtime.config.mbean.attrib.key.invalid.error", args, null);
                throw new ManagementRemoteException((Throwable)exception);
            }
        }
        String IS_STATIC_KEY = "isStatic";
        boolean isRestartRequired = false;
        Map<String, Properties> metadata = null;
        metadata = this.getRuntimeConfigurationMetadataInternal(targetName);
        if (systemAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : systemAttributes) {
                attributeName = attributeInfo.getName();
                attributeValueObject = properties.get(attributeName);
                if (attributeValueObject == null) continue;
                this.setAttributeValue(systemObjectName, attributeName, attributeValueObject);
                metaDataProperties = metadata.get(attributeName);
                if (!Boolean.valueOf(metaDataProperties.getProperty("isStatic")).booleanValue()) continue;
                isRestartRequired = true;
            }
        }
        if (installationAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : installationAttributes) {
                attributeName = attributeInfo.getName();
                attributeValueObject = properties.get(attributeName);
                if (attributeValueObject == null) continue;
                this.setAttributeValue(installationObjectName, attributeName, attributeValueObject);
                metaDataProperties = metadata.get(attributeName);
                if (!Boolean.valueOf(metaDataProperties.getProperty("isStatic")).booleanValue()) continue;
                isRestartRequired = true;
            }
        }
        if (deploymentAttributes != null) {
            for (MBeanAttributeInfo attributeInfo : deploymentAttributes) {
                attributeName = attributeInfo.getName();
                attributeValueObject = properties.get(attributeName);
                if (attributeValueObject == null) continue;
                this.setAttributeValue(deploymentObjectName, attributeName, attributeValueObject);
                metaDataProperties = metadata.get(attributeName);
                if (!Boolean.valueOf(metaDataProperties.getProperty("isStatic")).booleanValue()) continue;
                isRestartRequired = true;
            }
        }
        return isRestartRequired;
    }

    public Map<String, Object> getComponentConfigurationAsMap(String componentName, String targetName) throws ManagementRemoteException {
        Map<String, Object> result = null;
        TargetType targetType = this.checkTargetType(targetName);
        Exception exception = null;
        String[] args = new String[]{targetName};
        switch (targetType) {
            case STANDALONE_SERVER: 
            case CLUSTER: 
            case CLUSTERED_SERVER: {
                break;
            }
            default: {
                ConfigurationServiceMBeanImpl.logDebug("getComponentConfiguration(): target " + targetName + " type not supported.");
                exception = this.createManagementException("ui.mbean.schemaorg_apache_xmlbeans.system.config.target.type.not.supported", args, null);
                throw new ManagementRemoteException((Throwable)exception);
            }
        }
        this.targetUpCheck(targetName);
        this.componentInstalledOnTargetCheck(componentName, targetName);
        this.componentStartedOnTargetCheck(componentName, targetName);
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("getComponentConfiguration(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            try {
                result = this.getConfigurationAttributeValuesAsMap(configFacadeMBean);
                ConfigurationServiceMBeanImpl.logDebug("getComponentConfiguration: result properties = " + result);
            }
            catch (ManagementRemoteException jbiRE) {
                ConfigurationServiceMBeanImpl.logDebug("caught ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
                throw jbiRE;
            }
            catch (Exception ex) {
                ConfigurationServiceMBeanImpl.logDebug("caught non-ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug(ex);
                exception = this.createManagementException("ui.mbean.install.config.mbean.error.get.attrs.error", null, ex);
                ManagementRemoteException remoteException = new ManagementRemoteException((Throwable)exception);
                throw remoteException;
            }
        }
        return result;
    }

    public String setComponentConfiguration(String componentName, Map<String, Object> configurationValues, String targetName) throws ManagementRemoteException {
        String result = null;
        AttributeList list = null;
        TargetType targetType = this.checkTargetType(targetName);
        Exception exception = null;
        String[] args = new String[]{targetName};
        switch (targetType) {
            case STANDALONE_SERVER: 
            case CLUSTER: 
            case CLUSTERED_SERVER: {
                break;
            }
            default: {
                ConfigurationServiceMBeanImpl.logDebug("setComponentConfiguration(): target " + targetName + " type not supported.");
                exception = this.createManagementException("ui.mbean.schemaorg_apache_xmlbeans.system.config.target.type.not.supported", args, null);
                throw new ManagementRemoteException((Throwable)exception);
            }
        }
        ObjectName configFacadeMBean = this.getComponentConfigurationFacadeMBeanName(componentName, targetName);
        ConfigurationServiceMBeanImpl.logDebug("setComponentConfiguration(" + componentName + "," + targetName + "): configMBean = " + configFacadeMBean);
        if (configFacadeMBean != null && this.isValidTarget(configFacadeMBean)) {
            try {
                list = this.constructMBeanAttributes(configFacadeMBean, configurationValues);
                result = this.setMBeanConfigAttributes(configFacadeMBean, list);
                ConfigurationServiceMBeanImpl.logDebug("setComponentConfiguration(): result = " + result);
            }
            catch (ManagementRemoteException jbiRE) {
                ConfigurationServiceMBeanImpl.logDebug("caught ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug((Exception)((Object)jbiRE));
                throw jbiRE;
            }
            catch (Exception ex) {
                ConfigurationServiceMBeanImpl.logDebug("caught non-ManagementRemoteException:");
                ConfigurationServiceMBeanImpl.logDebug(ex);
                exception = this.createManagementException("ui.mbean.component.config.mbean.error.set.attrs.error", null, ex);
                ManagementRemoteException remoteException = new ManagementRemoteException((Throwable)exception);
                throw remoteException;
            }
        } else {
            ConfigurationServiceMBeanImpl.logDebug("Component " + componentName + " does not exist.");
            exception = this.createManagementException("ui.mbean.component.id.does.not.exist", new String[]{componentName}, null);
            ManagementRemoteException remoteException = new ManagementRemoteException((Throwable)exception);
            throw remoteException;
        }
        return result;
    }

    public Object invokeExtensionMBeanOperation(String componentName, String extensionName, String operationName, Object[] parameters, String[] signature, String targetName, String targetInstanceName) throws ManagementRemoteException {
        Object result;
        block5: {
            ObjectName[] objectNames;
            block6: {
                result = null;
                objectNames = null;
                boolean isClusteredServer = false;
                objectNames = this.getComponentExtensionMBeanObjectNames(componentName, extensionName, targetName, targetInstanceName);
                if (targetName != null) {
                    isClusteredServer = this.getPlatformContext().isCluster(targetName);
                }
                if (!isClusteredServer || targetInstanceName != null) break block6;
                if (objectNames == null) break block5;
                for (ObjectName objectName : objectNames) {
                    result = this.invokeMBeanOperation(objectName, operationName, parameters, signature);
                }
                break block5;
            }
            String target = targetName;
            if (targetInstanceName != null) {
                target = targetInstanceName;
            }
            if (objectNames != null) {
                for (ObjectName objectName : objectNames) {
                    String currentTarget = objectName.getKeyProperty("JbiName");
                    if (currentTarget == null || !currentTarget.equals(target)) continue;
                    result = this.invokeMBeanOperation(objectName, operationName, parameters, signature);
                    break;
                }
            }
        }
        return result;
    }

    protected ObjectName getRuntimeLoggerConfigFacadeMBeanName(String target) {
        return this.environmentContext.getMBeanNames().getSystemServiceMBeanName(MBeanNames.ServiceName.ConfigurationService, MBeanNames.ServiceType.Logger, target);
    }

    protected String getExistingAppVarType(String compName, String targetName, String appVarName) {
        String type = null;
        try {
            Properties appVars = this.getApplicationVariables(compName, targetName);
            if (appVars.containsKey(appVarName)) {
                String typeAndValueStr = appVars.getProperty(appVarName);
                type = this.componentConfigurationHelper.getAppVarType(typeAndValueStr, null);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return type;
    }

    protected void validateTargetForRuntimeConfigurationSpport(String targetName) throws ManagementRemoteException {
        if (targetName != null && !this.getPlatformContext().isCluster(targetName) && this.getPlatformContext().isInstanceClustered(targetName)) {
            ConfigurationServiceMBeanImpl.logDebug("Runtime configuration is managed at the cluster level. The target " + targetName + " is a clustered instance. For clustered instances, use cluster name as target for runtime configuration.");
            String cluster = "";
            try {
                cluster = this.getPlatformContext().getTargetName(targetName);
            }
            catch (Exception ex) {
                ConfigurationServiceMBeanImpl.logDebug(ex);
            }
            String i18nKey = "ui.mbean.system.config.runtime.target.type.not.supported";
            String[] args = new String[]{targetName, cluster};
            Exception exception = this.createManagementException(i18nKey, args, null);
            throw new ManagementRemoteException((Throwable)exception);
        }
    }
}

