/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.TestFrameworksUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class TestClassWithoutTestCasesRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Pattern> TEST_CLASS_PATTERN = ((PropertyBuilder.RegexPropertyBuilder)PropertyFactory.regexProperty((String)"testClassPattern").defaultValue("^(?:.*\\.)?Test[^\\.]*$|^(?:.*\\.)?.*Tests?$|^(?:.*\\.)?.*TestCase$").desc("Test class name pattern to identify test classes by their fully qualified name. An empty pattern disables test class detection by name. Since PMD 6.51.0.")).build();

    public TestClassWithoutTestCasesRule() {
        super(ASTClassDeclaration.class, new Class[0]);
        this.definePropertyDescriptor(TEST_CLASS_PATTERN);
    }

    public Object visit(ASTClassDeclaration node, Object data) {
        if (TestFrameworksUtil.isJUnit3Class(node) || TestFrameworksUtil.isJUnit5NestedClass(node) || this.isTestClassByPattern(node)) {
            boolean hasTests = node.getDeclarations(ASTMethodDeclaration.class).any(TestFrameworksUtil::isTestMethod);
            boolean hasNestedTestClasses = node.getDeclarations(ASTTypeDeclaration.class).any(TestFrameworksUtil::isJUnit5NestedClass);
            if (!hasTests && !hasNestedTestClasses) {
                this.asCtx(data).addViolation((Node)node, new Object[]{node.getSimpleName()});
            }
        }
        return null;
    }

    private boolean isTestClassByPattern(ASTClassDeclaration node) {
        Pattern testClassPattern = (Pattern)this.getProperty(TEST_CLASS_PATTERN);
        if (testClassPattern.pattern().isEmpty()) {
            return false;
        }
        if (node.isAbstract() || node.isInterface()) {
            return false;
        }
        String fullName = node.getCanonicalName();
        return fullName != null && testClassPattern.matcher(fullName).find();
    }
}

