/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.util.Objects;
import java.util.function.Function;
import net.sourceforge.pmd.lang.java.symbols.JTypeParameterSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.JWildcardType;
import net.sourceforge.pmd.lang.java.types.SubstVar;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.HashTreePSet;
import org.pcollections.PSet;

final class CaptureMatcher
implements JTypeVar {
    private final JWildcardType wild;
    private @Nullable JTypeVar captured = null;

    CaptureMatcher(JWildcardType wild) {
        this.wild = wild;
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.wild.getTypeSystem();
    }

    @Override
    public boolean isCaptured() {
        return true;
    }

    @Override
    public JTypeVar withAnnotations(PSet<SymbolicValue.SymAnnot> newTypeAnnots) {
        throw new UnsupportedOperationException("this is a test only object which should only be used for equals");
    }

    @Override
    public JTypeVar withUpperBound(@NonNull JTypeMirror newUB) {
        throw new UnsupportedOperationException("this is a test only object which should only be used for equals");
    }

    @Override
    public PSet<SymbolicValue.SymAnnot> getTypeAnnotations() {
        if (this.captured != null) {
            return this.captured.getTypeAnnotations();
        }
        return HashTreePSet.empty();
    }

    @Override
    public @Nullable JTypeParameterSymbol getSymbol() {
        return null;
    }

    @Override
    public @NonNull String getName() {
        if (this.captured != null) {
            return this.captured.getName();
        }
        throw new UnsupportedOperationException("this is a test only object which should only be used for equals");
    }

    @Override
    public @NonNull JTypeMirror getUpperBound() {
        return this.captured != null ? this.captured.getUpperBound() : this.getTypeSystem().OBJECT;
    }

    @Override
    public @NonNull JTypeMirror getLowerBound() {
        return this.captured != null ? this.captured.getLowerBound() : this.getTypeSystem().NULL_TYPE;
    }

    @Override
    public boolean isCaptureOf(JWildcardType wildcard) {
        return this.wild.equals(wildcard);
    }

    @Override
    public @Nullable JWildcardType getCapturedOrigin() {
        return this.wild;
    }

    @Override
    public JTypeVar cloneWithBounds(JTypeMirror lower, JTypeMirror upper) {
        throw new UnsupportedOperationException("this is a test only object which should only be used for equals");
    }

    @Override
    public JTypeVar substInBounds(Function<? super SubstVar, ? extends @NonNull JTypeMirror> substitution) {
        throw new UnsupportedOperationException("this is a test only object which should only be used for equals");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JTypeVar)) {
            return false;
        }
        if (this.captured != null) {
            return this.captured.equals(o);
        }
        JTypeVar that = (JTypeVar)o;
        if (!Objects.equals(that.getCapturedOrigin(), this.getCapturedOrigin())) {
            return false;
        }
        this.captured = that;
        return true;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("this is a test only object which should only be used for equals");
    }

    @Override
    public String toString() {
        return this.captured == null ? "unbound capture matcher of (" + this.wild + ")" : "bound(" + this.captured + ")";
    }
}

