/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.alert;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.enums.AlertStatus;
import org.apache.dolphinscheduler.common.enums.ListenerEventType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ListenerEvent;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelationLog;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.ProjectUser;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.event.AbstractListenerEvent;
import org.apache.dolphinscheduler.dao.entity.event.ProcessDefinitionCreatedListenerEvent;
import org.apache.dolphinscheduler.dao.entity.event.ProcessDefinitionDeletedListenerEvent;
import org.apache.dolphinscheduler.dao.entity.event.ProcessDefinitionUpdatedListenerEvent;
import org.apache.dolphinscheduler.dao.entity.event.ProcessEndListenerEvent;
import org.apache.dolphinscheduler.dao.entity.event.ProcessFailListenerEvent;
import org.apache.dolphinscheduler.dao.entity.event.ProcessStartListenerEvent;
import org.apache.dolphinscheduler.dao.entity.event.ServerDownListenerEvent;
import org.apache.dolphinscheduler.dao.entity.event.TaskEndListenerEvent;
import org.apache.dolphinscheduler.dao.entity.event.TaskFailListenerEvent;
import org.apache.dolphinscheduler.dao.entity.event.TaskStartListenerEvent;
import org.apache.dolphinscheduler.dao.mapper.AlertPluginInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.ListenerEventMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ListenerEventAlertManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ListenerEventAlertManager.class);
    @Value(value="${alert.alarm-suppression.crash:60}")
    private int crashAlarmSuppression;
    @Autowired
    private ListenerEventMapper listenerEventMapper;
    @Autowired
    private AlertPluginInstanceMapper alertPluginInstanceMapper;

    public void publishServerDownListenerEvent(String host, String type) {
        ServerDownListenerEvent event = new ServerDownListenerEvent();
        event.setEventTime(new Date());
        event.setHost(host);
        event.setType(type);
        this.saveEvent((AbstractListenerEvent)event);
    }

    public void publishProcessDefinitionCreatedListenerEvent(User user, ProcessDefinition processDefinition, List<TaskDefinitionLog> taskDefinitionLogs, List<ProcessTaskRelationLog> processTaskRelationLogs) {
        ProcessDefinitionCreatedListenerEvent event = new ProcessDefinitionCreatedListenerEvent(processDefinition);
        event.setUserName(user.getUserName());
        event.setModifyBy(user.getUserName());
        event.setTaskDefinitionLogs(taskDefinitionLogs);
        event.setTaskRelationList(processTaskRelationLogs);
        this.saveEvent((AbstractListenerEvent)event);
    }

    public void publishProcessDefinitionUpdatedListenerEvent(User user, ProcessDefinition processDefinition, List<TaskDefinitionLog> taskDefinitionLogs, List<ProcessTaskRelationLog> processTaskRelationLogs) {
        ProcessDefinitionUpdatedListenerEvent event = new ProcessDefinitionUpdatedListenerEvent(processDefinition);
        event.setTaskDefinitionLogs(taskDefinitionLogs);
        event.setTaskRelationList(processTaskRelationLogs);
        event.setUserName(user.getUserName());
        event.setModifyBy(user.getUserName());
        this.saveEvent((AbstractListenerEvent)event);
    }

    public void publishProcessDefinitionDeletedListenerEvent(User user, Project project, ProcessDefinition processDefinition) {
        ProcessDefinitionDeletedListenerEvent event = new ProcessDefinitionDeletedListenerEvent();
        event.setProjectId(project.getId());
        event.setProjectCode(Long.valueOf(project.getCode()));
        event.setProjectName(project.getName());
        event.setOwner(processDefinition.getUserName());
        event.setId(processDefinition.getId());
        event.setCode(Long.valueOf(processDefinition.getCode()));
        event.setName(processDefinition.getName());
        event.setEventTime(new Date());
        event.setUserId(user.getId());
        event.setModifiedBy(user.getUserName());
        this.saveEvent((AbstractListenerEvent)event);
    }

    public void publishProcessStartListenerEvent(ProcessInstance processInstance, ProjectUser projectUser) {
        ProcessStartListenerEvent event = new ProcessStartListenerEvent();
        event.setProjectCode(Long.valueOf(projectUser.getProjectCode()));
        event.setProjectName(projectUser.getProjectName());
        event.setOwner(projectUser.getUserName());
        event.setProcessId(processInstance.getId());
        event.setProcessDefinitionCode(processInstance.getProcessDefinitionCode());
        event.setProcessName(processInstance.getName());
        event.setProcessType(processInstance.getCommandType());
        event.setProcessState(processInstance.getState());
        event.setRunTimes(Integer.valueOf(processInstance.getRunTimes()));
        event.setRecovery(processInstance.getRecovery());
        event.setProcessStartTime(processInstance.getStartTime());
        this.saveEvent((AbstractListenerEvent)event);
    }

    public void publishProcessEndListenerEvent(ProcessInstance processInstance, ProjectUser projectUser) {
        ProcessEndListenerEvent event = new ProcessEndListenerEvent();
        event.setProjectCode(Long.valueOf(projectUser.getProjectCode()));
        event.setProjectName(projectUser.getProjectName());
        event.setOwner(projectUser.getUserName());
        event.setProcessId(processInstance.getId());
        event.setProcessDefinitionCode(processInstance.getProcessDefinitionCode());
        event.setProcessName(processInstance.getName());
        event.setProcessType(processInstance.getCommandType());
        event.setProcessState(processInstance.getState());
        event.setRecovery(processInstance.getRecovery());
        event.setRunTimes(Integer.valueOf(processInstance.getRunTimes()));
        event.setProcessStartTime(processInstance.getStartTime());
        event.setProcessEndTime(processInstance.getEndTime());
        event.setProcessHost(processInstance.getHost());
        this.saveEvent((AbstractListenerEvent)event);
    }

    public void publishProcessFailListenerEvent(ProcessInstance processInstance, ProjectUser projectUser) {
        ProcessFailListenerEvent event = new ProcessFailListenerEvent();
        event.setProjectCode(Long.valueOf(projectUser.getProjectCode()));
        event.setProjectName(projectUser.getProjectName());
        event.setOwner(projectUser.getUserName());
        event.setProcessId(processInstance.getId());
        event.setProcessDefinitionCode(processInstance.getProcessDefinitionCode());
        event.setProcessName(processInstance.getName());
        event.setProcessType(processInstance.getCommandType());
        event.setProcessState(processInstance.getState());
        event.setRecovery(processInstance.getRecovery());
        event.setRunTimes(Integer.valueOf(processInstance.getRunTimes()));
        event.setProcessStartTime(processInstance.getStartTime());
        event.setProcessEndTime(processInstance.getEndTime());
        event.setProcessHost(processInstance.getHost());
        this.saveEvent((AbstractListenerEvent)event);
    }

    public void publishTaskStartListenerEvent(ProcessInstance processInstance, TaskInstance taskInstance, ProjectUser projectUser) {
        TaskStartListenerEvent event = new TaskStartListenerEvent();
        event.setProjectCode(projectUser.getProjectCode());
        event.setProjectName(projectUser.getProjectName());
        event.setOwner(projectUser.getUserName());
        event.setProcessId((long)processInstance.getId().intValue());
        event.setProcessDefinitionCode(processInstance.getProcessDefinitionCode().longValue());
        event.setProcessName(processInstance.getName());
        event.setTaskCode(taskInstance.getTaskCode());
        event.setTaskName(taskInstance.getName());
        event.setTaskType(taskInstance.getTaskType());
        event.setTaskState(taskInstance.getState());
        event.setTaskStartTime(taskInstance.getStartTime());
        event.setTaskEndTime(taskInstance.getEndTime());
        event.setTaskHost(taskInstance.getHost());
        event.setLogPath(taskInstance.getLogPath());
        this.saveEvent((AbstractListenerEvent)event);
    }

    public void publishTaskEndListenerEvent(ProcessInstance processInstance, TaskInstance taskInstance, ProjectUser projectUser) {
        TaskEndListenerEvent event = new TaskEndListenerEvent();
        event.setProjectCode(projectUser.getProjectCode());
        event.setProjectName(projectUser.getProjectName());
        event.setOwner(projectUser.getUserName());
        event.setProcessId((long)processInstance.getId().intValue());
        event.setProcessDefinitionCode(processInstance.getProcessDefinitionCode().longValue());
        event.setProcessName(processInstance.getName());
        event.setTaskCode(taskInstance.getTaskCode());
        event.setTaskName(taskInstance.getName());
        event.setTaskType(taskInstance.getTaskType());
        event.setTaskState(taskInstance.getState());
        event.setTaskStartTime(taskInstance.getStartTime());
        event.setTaskEndTime(taskInstance.getEndTime());
        event.setTaskHost(taskInstance.getHost());
        event.setLogPath(taskInstance.getLogPath());
        this.saveEvent((AbstractListenerEvent)event);
    }

    public void publishTaskFailListenerEvent(ProcessInstance processInstance, TaskInstance taskInstance, ProjectUser projectUser) {
        TaskFailListenerEvent event = new TaskFailListenerEvent();
        event.setProjectCode(projectUser.getProjectCode());
        event.setProjectName(projectUser.getProjectName());
        event.setOwner(projectUser.getUserName());
        event.setProcessId((long)processInstance.getId().intValue());
        event.setProcessDefinitionCode(processInstance.getProcessDefinitionCode().longValue());
        event.setProcessName(processInstance.getName());
        event.setTaskCode(taskInstance.getTaskCode());
        event.setTaskName(taskInstance.getName());
        event.setTaskType(taskInstance.getTaskType());
        event.setTaskState(taskInstance.getState());
        event.setTaskStartTime(taskInstance.getStartTime());
        event.setTaskEndTime(taskInstance.getEndTime());
        event.setTaskHost(taskInstance.getHost());
        event.setLogPath(taskInstance.getLogPath());
        this.saveEvent((AbstractListenerEvent)event);
    }

    private void saveEvent(AbstractListenerEvent event) {
        if (!this.needSendGlobalListenerEvent()) {
            return;
        }
        ListenerEvent listenerEvent = new ListenerEvent();
        String content = JSONUtils.toJsonString((Object)event);
        listenerEvent.setContent(content);
        listenerEvent.setPostStatus(AlertStatus.WAIT_EXECUTION);
        listenerEvent.setSign(this.generateSign(content));
        listenerEvent.setCreateTime(new Date());
        listenerEvent.setUpdateTime(new Date());
        listenerEvent.setEventType(event.getEventType());
        if (event.getEventType() == ListenerEventType.SERVER_DOWN) {
            this.saveServerDownEvent(listenerEvent);
        } else {
            this.saveNormalEvent(listenerEvent);
        }
    }

    private void saveNormalEvent(ListenerEvent listenerEvent) {
        int insert = this.listenerEventMapper.insert((Object)listenerEvent);
        if (insert < 1) {
            log.error("insert listener event failed: {}", (Object)listenerEvent);
        }
    }

    private void saveServerDownEvent(ListenerEvent listenerEvent) {
        Date crashAlarmSuppressionStartTime = Date.from(LocalDateTime.now().plusMinutes(-this.crashAlarmSuppression).atZone(ZoneId.systemDefault()).toInstant());
        this.listenerEventMapper.insertServerDownEvent(listenerEvent, crashAlarmSuppressionStartTime);
    }

    private String generateSign(String content) {
        return DigestUtils.sha256Hex((String)content).toLowerCase();
    }

    private boolean needSendGlobalListenerEvent() {
        List globalPluginInstanceList = this.alertPluginInstanceMapper.queryAllGlobalAlertPluginInstanceList();
        return CollectionUtils.isNotEmpty((Collection)globalPluginInstanceList);
    }
}

