/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.command;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import io.micrometer.core.annotation.Counted;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.ErrorCommand;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.ProcessInstanceMap;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.mapper.CommandMapper;
import org.apache.dolphinscheduler.dao.mapper.ErrorCommandMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.service.command.CommandService;
import org.apache.dolphinscheduler.service.utils.ParamUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommandServiceImpl
implements CommandService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommandServiceImpl.class);
    @Autowired
    private ErrorCommandMapper errorCommandMapper;
    @Autowired
    private CommandMapper commandMapper;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private ProcessDefinitionMapper processDefineMapper;

    @Override
    public void moveToErrorCommand(Command command, String message) {
        ErrorCommand errorCommand = new ErrorCommand(command, message);
        this.errorCommandMapper.insert((Object)errorCommand);
        this.commandMapper.deleteById((Serializable)command.getId());
    }

    @Override
    @Counted(value="ds.workflow.create.command.count")
    public int createCommand(Command command) {
        int result = 0;
        if (command == null) {
            return result;
        }
        Schedule schedule = this.scheduleMapper.queryByProcessDefinitionCode(command.getProcessDefinitionCode());
        if (schedule != null) {
            Map<String, String> commandParams = StringUtils.isNotBlank((CharSequence)command.getCommandParam()) ? JSONUtils.toMap((String)command.getCommandParam()) : new HashMap();
            commandParams.put("schedule_timezone", schedule.getTimezoneId());
            command.setCommandParam(JSONUtils.toJsonString(commandParams));
        }
        command.setId(null);
        result = this.commandMapper.insert((Object)command);
        return result;
    }

    @Override
    public List<Command> findCommandPageBySlot(int pageSize, int masterCount, int thisMasterSlot) {
        if (masterCount <= 0) {
            return Lists.newArrayList();
        }
        return this.commandMapper.queryCommandPageBySlot(pageSize, masterCount, thisMasterSlot);
    }

    @Override
    public boolean verifyIsNeedCreateCommand(Command command) {
        boolean isNeedCreate = true;
        EnumMap<CommandType, Integer> cmdTypeMap = new EnumMap<CommandType, Integer>(CommandType.class);
        cmdTypeMap.put(CommandType.REPEAT_RUNNING, 1);
        cmdTypeMap.put(CommandType.RECOVER_SUSPENDED_PROCESS, 1);
        cmdTypeMap.put(CommandType.START_FAILURE_TASK_PROCESS, 1);
        CommandType commandType = command.getCommandType();
        if (!cmdTypeMap.containsKey(commandType)) {
            return true;
        }
        ObjectNode cmdParamObj = JSONUtils.parseObject((String)command.getCommandParam());
        int processInstanceId = cmdParamObj.path("ProcessInstanceId").asInt();
        List commands = this.commandMapper.selectList(null);
        for (Command tmpCommand : commands) {
            ObjectNode tempObj;
            if (!cmdTypeMap.containsKey(tmpCommand.getCommandType()) || (tempObj = JSONUtils.parseObject((String)tmpCommand.getCommandParam())) == null || processInstanceId != tempObj.path("ProcessInstanceId").asInt()) continue;
            isNeedCreate = false;
            break;
        }
        return isNeedCreate;
    }

    @Override
    public void createRecoveryWaitingThreadCommand(Command originCommand, ProcessInstance processInstance) {
        if (processInstance.getIsSubProcess() == Flag.YES) {
            if (originCommand != null) {
                this.commandMapper.deleteById((Serializable)originCommand.getId());
            }
            return;
        }
        HashMap<String, String> cmdParam = new HashMap<String, String>();
        cmdParam.put("WaitingThreadInstanceId", String.valueOf(processInstance.getId()));
        if (originCommand == null) {
            Command command = new Command(CommandType.RECOVER_WAITING_THREAD, processInstance.getTaskDependType(), processInstance.getFailureStrategy(), processInstance.getExecutorId(), processInstance.getProcessDefinition().getCode(), JSONUtils.toJsonString(cmdParam), processInstance.getWarningType(), processInstance.getWarningGroupId().intValue(), processInstance.getScheduleTime(), processInstance.getWorkerGroup(), processInstance.getEnvironmentCode(), processInstance.getProcessInstancePriority(), processInstance.getDryRun(), processInstance.getId().intValue(), processInstance.getProcessDefinitionVersion(), processInstance.getTestFlag());
            this.upsertCommand(command);
            return;
        }
        if (originCommand.getCommandType() == CommandType.RECOVER_WAITING_THREAD) {
            originCommand.setUpdateTime(new Date());
            this.upsertCommand(originCommand);
        } else {
            this.commandMapper.deleteById((Serializable)originCommand.getId());
            originCommand.setId(Integer.valueOf(0));
            originCommand.setCommandType(CommandType.RECOVER_WAITING_THREAD);
            originCommand.setUpdateTime(new Date());
            originCommand.setCommandParam(JSONUtils.toJsonString(cmdParam));
            originCommand.setProcessInstancePriority(processInstance.getProcessInstancePriority());
            this.upsertCommand(originCommand);
        }
    }

    private int upsertCommand(@NotNull Command command) {
        if (command.getId() != null) {
            return this.commandMapper.updateById((Object)command);
        }
        return this.commandMapper.insert((Object)command);
    }

    @Override
    public Command createSubProcessCommand(ProcessInstance parentProcessInstance, ProcessInstance childInstance, ProcessInstanceMap instanceMap, TaskInstance task) {
        CommandType commandType = this.getSubCommandType(parentProcessInstance, childInstance);
        Map subProcessParam = JSONUtils.toMap((String)task.getTaskParams(), String.class, Object.class);
        long childDefineCode = 0L;
        if (subProcessParam.containsKey("processDefinitionCode")) {
            try {
                childDefineCode = Long.parseLong(String.valueOf(subProcessParam.get("processDefinitionCode")));
            }
            catch (NumberFormatException nfe) {
                log.error("processDefinitionCode is not a number", (Throwable)nfe);
                return null;
            }
        }
        ProcessDefinition subProcessDefinition = this.processDefineMapper.queryByCode(childDefineCode);
        Object localParams = subProcessParam.get("localParams");
        List allParam = JSONUtils.toList((String)JSONUtils.toJsonString(localParams), Property.class);
        Map<String, String> globalMap = ParamUtils.getGlobalParamMap(task.getVarPool());
        HashMap<String, String> fatherParams = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty((Collection)allParam)) {
            for (Property info : allParam) {
                if (Direct.OUT == info.getDirect()) continue;
                fatherParams.put(info.getProp(), globalMap.get(info.getProp()));
            }
        }
        String processParam = ParamUtils.getSubWorkFlowParam(instanceMap, parentProcessInstance, fatherParams);
        int subProcessInstanceId = childInstance == null ? 0 : (childInstance.getId() == null ? 0 : childInstance.getId());
        return new Command(commandType, TaskDependType.TASK_POST, parentProcessInstance.getFailureStrategy(), parentProcessInstance.getExecutorId(), subProcessDefinition.getCode(), processParam, parentProcessInstance.getWarningType(), parentProcessInstance.getWarningGroupId().intValue(), parentProcessInstance.getScheduleTime(), task.getWorkerGroup(), task.getEnvironmentCode(), parentProcessInstance.getProcessInstancePriority(), parentProcessInstance.getDryRun(), subProcessInstanceId, subProcessDefinition.getVersion(), parentProcessInstance.getTestFlag());
    }

    private CommandType getSubCommandType(ProcessInstance parentProcessInstance, ProcessInstance childInstance) {
        CommandType commandType = parentProcessInstance.getCommandType();
        if (childInstance == null) {
            String fatherHistoryCommand = parentProcessInstance.getHistoryCmd();
            commandType = CommandType.valueOf((String)fatherHistoryCommand.split(",")[0]);
        }
        return commandType;
    }
}

