/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.process;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.TaskGroupQueueStatus;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.DagData;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.DependentProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.DqComparisonType;
import org.apache.dolphinscheduler.dao.entity.DqExecuteResult;
import org.apache.dolphinscheduler.dao.entity.DqRule;
import org.apache.dolphinscheduler.dao.entity.DqRuleExecuteSql;
import org.apache.dolphinscheduler.dao.entity.DqRuleInputEntry;
import org.apache.dolphinscheduler.dao.entity.Environment;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelation;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelationLog;
import org.apache.dolphinscheduler.dao.entity.ProjectUser;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.TaskGroupQueue;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.UdfFunc;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.service.exceptions.CronParseException;
import org.apache.dolphinscheduler.service.model.TaskNode;
import org.springframework.transaction.annotation.Transactional;

public interface ProcessService {
    @Transactional
    @Nullable
    public ProcessInstance handleCommand(String var1, Command var2) throws CronParseException, CodeGenerateUtils.CodeGenerateException;

    public ProcessInstance constructProcessInstance(Command var1, String var2) throws CronParseException, CodeGenerateUtils.CodeGenerateException;

    public Optional<ProcessInstance> findProcessInstanceDetailById(int var1);

    public ProcessInstance findProcessInstanceById(int var1);

    public ProcessDefinition findProcessDefinition(Long var1, int var2);

    public ProcessDefinition findProcessDefinitionByCode(Long var1);

    public int deleteWorkProcessInstanceById(int var1);

    public int deleteAllSubWorkProcessByParentId(int var1);

    public void removeTaskLogFile(Integer var1);

    public List<Long> findAllSubWorkflowDefinitionCode(long var1);

    public String getTenantForProcess(String var1, int var2);

    public Environment findEnvironmentByCode(Long var1);

    public void setSubProcessParam(ProcessInstance var1);

    @Transactional
    public boolean submitTask(ProcessInstance var1, TaskInstance var2);

    public void createSubWorkProcess(ProcessInstance var1, TaskInstance var2);

    public void packageTaskInstance(TaskInstance var1, ProcessInstance var2);

    public void updateTaskDefinitionResources(TaskDefinition var1);

    public int deleteWorkProcessMapByParentId(int var1);

    public ProcessInstance findSubProcessInstance(Integer var1, Integer var2);

    public ProcessInstance findParentProcessInstance(Integer var1);

    public void changeOutParam(TaskInstance var1);

    public Schedule querySchedule(int var1);

    public List<Schedule> queryReleaseSchedulerListByProcessDefinitionCode(long var1);

    public List<DependentProcessDefinition> queryDependentProcessDefinitionByProcessDefinitionCode(long var1);

    public List<ProcessInstance> queryNeedFailoverProcessInstances(String var1);

    public List<String> queryNeedFailoverProcessInstanceHost();

    @Transactional
    public void processNeedFailoverProcessInstances(ProcessInstance var1);

    public DataSource findDataSourceById(int var1);

    public List<UdfFunc> queryUdfFunListByIds(Integer[] var1);

    public ProjectUser queryProjectWithUserByProcessInstanceId(int var1);

    public <T> List<T> listUnauthorized(int var1, T[] var2, AuthorizationType var3);

    public User getUserById(int var1);

    public String formatTaskAppId(TaskInstance var1);

    public int switchVersion(ProcessDefinition var1, ProcessDefinitionLog var2);

    public int switchProcessTaskRelationVersion(ProcessDefinition var1);

    public int switchTaskDefinitionVersion(long var1, int var3);

    public String getResourceIds(TaskDefinition var1);

    public int saveTaskDefine(User var1, long var2, List<TaskDefinitionLog> var4, Boolean var5);

    public int saveProcessDefine(User var1, ProcessDefinition var2, Boolean var3, Boolean var4);

    public int saveTaskRelation(User var1, long var2, long var4, int var6, List<ProcessTaskRelationLog> var7, List<TaskDefinitionLog> var8, Boolean var9);

    public boolean isTaskOnline(long var1);

    public DAG<Long, TaskNode, TaskNodeRelation> genDagGraph(ProcessDefinition var1);

    public DagData genDagData(ProcessDefinition var1);

    public List<ProcessTaskRelation> findRelationByCode(long var1, int var3);

    public List<TaskNode> transformTask(List<ProcessTaskRelation> var1, List<TaskDefinitionLog> var2);

    public DqExecuteResult getDqExecuteResultByTaskInstanceId(int var1);

    public int updateDqExecuteResultUserId(int var1);

    public int updateDqExecuteResultState(DqExecuteResult var1);

    public int deleteDqExecuteResultByTaskInstanceId(int var1);

    public int deleteTaskStatisticsValueByTaskInstanceId(int var1);

    public DqRule getDqRule(int var1);

    public List<DqRuleInputEntry> getRuleInputEntry(int var1);

    public List<DqRuleExecuteSql> getDqExecuteSql(int var1);

    public DqComparisonType getComparisonTypeById(int var1);

    public void changeTaskGroupQueueStatus(int var1, TaskGroupQueueStatus var2);

    public TaskGroupQueue insertIntoTaskGroupQueue(Integer var1, String var2, Integer var3, Integer var4, Integer var5, TaskGroupQueueStatus var6);

    public ProcessInstance loadNextProcess4Serial(long var1, int var3, int var4);

    public String findConfigYamlByName(String var1);

    public void forceProcessInstanceSuccessByTaskInstanceId(Integer var1);

    public void saveCommandTrigger(Integer var1, Integer var2);

    public void setGlobalParamIfCommanded(ProcessDefinition var1, Map<String, String> var2);
}

