/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.process;

import java.util.Date;
import org.apache.dolphinscheduler.common.enums.ApiTriggerType;
import org.apache.dolphinscheduler.dao.entity.TriggerRelation;
import org.apache.dolphinscheduler.dao.mapper.TriggerRelationMapper;
import org.apache.dolphinscheduler.service.process.TriggerRelationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TriggerRelationServiceImpl
implements TriggerRelationService {
    @Autowired
    private TriggerRelationMapper triggerRelationMapper;

    @Override
    public void saveTriggerToDb(ApiTriggerType type, Long triggerCode, Integer jobId) {
        TriggerRelation triggerRelation = new TriggerRelation();
        triggerRelation.setTriggerType(type.getCode());
        triggerRelation.setJobId(jobId);
        triggerRelation.setTriggerCode(triggerCode.longValue());
        triggerRelation.setCreateTime(new Date());
        triggerRelation.setUpdateTime(new Date());
        this.triggerRelationMapper.upsert(triggerRelation);
    }

    @Override
    public TriggerRelation queryByTypeAndJobId(ApiTriggerType apiTriggerType, int jobId) {
        return this.triggerRelationMapper.queryByTypeAndJobId(Integer.valueOf(apiTriggerType.getCode()), jobId);
    }

    @Override
    public int saveCommandTrigger(Integer commandId, Integer processInstanceId) {
        TriggerRelation exist = this.queryByTypeAndJobId(ApiTriggerType.PROCESS, processInstanceId);
        if (exist == null) {
            return 0;
        }
        this.saveTriggerToDb(ApiTriggerType.COMMAND, exist.getTriggerCode(), commandId);
        return 1;
    }

    @Override
    public int saveProcessInstanceTrigger(Integer commandId, Integer processInstanceId) {
        TriggerRelation exist = this.queryByTypeAndJobId(ApiTriggerType.COMMAND, commandId);
        if (exist == null) {
            return 0;
        }
        this.saveTriggerToDb(ApiTriggerType.PROCESS, exist.getTriggerCode(), processInstanceId);
        return 1;
    }
}

