/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.utils;

import java.net.URL;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
    private static final Base64 BASE64 = new Base64();

    protected CommonUtils() {
        throw new UnsupportedOperationException("Construct CommonUtils");
    }

    public static String getSystemEnvPath() {
        String envPath = PropertyUtils.getString((String)"dolphinscheduler.env.path");
        if (StringUtils.isEmpty((CharSequence)envPath)) {
            URL envDefaultPath = CommonUtils.class.getClassLoader().getResource("dolphinscheduler_env.sh");
            if (envDefaultPath != null) {
                envPath = envDefaultPath.getPath();
                log.debug("env path :{}", (Object)envPath);
            } else {
                envPath = "/etc/profile";
            }
        }
        return envPath;
    }

    public static String encodePassword(String password) {
        if (StringUtils.isEmpty((CharSequence)password)) {
            return "";
        }
        boolean encryptionEnable = PropertyUtils.getBoolean((String)"datasource.encryption.enable", (Boolean)false);
        if (!encryptionEnable) {
            return password;
        }
        String salt = PropertyUtils.getString((String)"datasource.encryption.salt", (String)"!@#$%^&*");
        String passwordWithSalt = salt + new String(BASE64.encode(password.getBytes(StandardCharsets.UTF_8)));
        return new String(BASE64.encode(passwordWithSalt.getBytes(StandardCharsets.UTF_8)));
    }

    public static String decodePassword(String password) {
        if (StringUtils.isEmpty((CharSequence)password)) {
            return "";
        }
        boolean encryptionEnable = PropertyUtils.getBoolean((String)"datasource.encryption.enable", (Boolean)false);
        if (!encryptionEnable) {
            return password;
        }
        String salt = PropertyUtils.getString((String)"datasource.encryption.salt", (String)"!@#$%^&*");
        String passwordWithSalt = new String(BASE64.decode(password), StandardCharsets.UTF_8);
        if (!passwordWithSalt.startsWith(salt)) {
            log.warn("There is a password and salt mismatch: {} ", (Object)password);
            return password;
        }
        return new String(BASE64.decode(passwordWithSalt.substring(salt.length())), StandardCharsets.UTF_8);
    }
}

