/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelation;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.plugin.task.api.model.SwitchResultVo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.ConditionsParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.SwitchParameters;
import org.apache.dolphinscheduler.service.model.TaskNode;
import org.apache.dolphinscheduler.service.process.ProcessDag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DagHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DagHelper.class);

    public static List<TaskNodeRelation> generateRelationListByFlowNodes(List<TaskNode> taskNodeList) {
        ArrayList<TaskNodeRelation> nodeRelationList = new ArrayList<TaskNodeRelation>();
        for (TaskNode taskNode : taskNodeList) {
            String preTasks = taskNode.getPreTasks();
            List preTaskList = JSONUtils.toList((String)preTasks, Long.class);
            if (preTaskList == null) continue;
            for (Long depNodeCode : preTaskList) {
                if (null == DagHelper.findNodeByCode(taskNodeList, depNodeCode)) continue;
                nodeRelationList.add(new TaskNodeRelation(depNodeCode, Long.valueOf(taskNode.getCode())));
            }
        }
        return nodeRelationList;
    }

    public static List<TaskNode> generateFlowNodeListByStartNode(List<TaskNode> taskNodeList, List<Long> startNodeNameList, List<Long> recoveryNodeCodeList, TaskDependType taskDependType) {
        ArrayList<TaskNode> destFlowNodeList = new ArrayList<TaskNode>();
        List<Long> startNodeList = startNodeNameList;
        if (taskDependType != TaskDependType.TASK_POST && CollectionUtils.isEmpty(startNodeList)) {
            log.error("start node list is empty! cannot continue run the process ");
            return destFlowNodeList;
        }
        ArrayList<TaskNode> destTaskNodeList = new ArrayList<TaskNode>();
        List<Object> tmpTaskNodeList = new ArrayList();
        if (taskDependType == TaskDependType.TASK_POST && CollectionUtils.isNotEmpty(recoveryNodeCodeList)) {
            startNodeList = recoveryNodeCodeList;
        }
        if (CollectionUtils.isEmpty(startNodeList)) {
            tmpTaskNodeList = taskNodeList;
        } else {
            for (Long l : startNodeList) {
                ArrayList<Long> visitedNodeCodeList;
                TaskNode startNode = DagHelper.findNodeByCode(taskNodeList, l);
                List<TaskNode> childNodeList = new ArrayList<TaskNode>();
                if (startNode == null) {
                    log.error("start node name [{}] is not in task node list [{}] ", (Object)l, taskNodeList);
                    continue;
                }
                if (TaskDependType.TASK_POST == taskDependType) {
                    visitedNodeCodeList = new ArrayList<Long>();
                    childNodeList = DagHelper.getFlowNodeListPost(startNode, taskNodeList, visitedNodeCodeList);
                } else if (TaskDependType.TASK_PRE == taskDependType) {
                    visitedNodeCodeList = new ArrayList();
                    childNodeList = DagHelper.getFlowNodeListPre(startNode, recoveryNodeCodeList, taskNodeList, visitedNodeCodeList);
                } else {
                    childNodeList.add(startNode);
                }
                tmpTaskNodeList.addAll(childNodeList);
            }
        }
        for (TaskNode taskNode : tmpTaskNodeList) {
            if (null != DagHelper.findNodeByCode(destTaskNodeList, taskNode.getCode())) continue;
            destTaskNodeList.add(taskNode);
        }
        return destTaskNodeList;
    }

    private static List<TaskNode> getFlowNodeListPost(TaskNode startNode, List<TaskNode> taskNodeList, List<Long> visitedNodeCodeList) {
        ArrayList<TaskNode> resultList = new ArrayList<TaskNode>();
        for (TaskNode taskNode : taskNodeList) {
            List<Long> depList = taskNode.getDepList();
            if (null == depList || null == startNode || !depList.contains(startNode.getCode()) || visitedNodeCodeList.contains(taskNode.getCode())) continue;
            resultList.addAll(DagHelper.getFlowNodeListPost(taskNode, taskNodeList, visitedNodeCodeList));
        }
        if (null != startNode) {
            visitedNodeCodeList.add(startNode.getCode());
        }
        resultList.add(startNode);
        return resultList;
    }

    private static List<TaskNode> getFlowNodeListPre(TaskNode startNode, List<Long> recoveryNodeCodeList, List<TaskNode> taskNodeList, List<Long> visitedNodeCodeList) {
        ArrayList<TaskNode> resultList = new ArrayList<TaskNode>();
        List<Object> depList = new ArrayList();
        if (null != startNode) {
            depList = startNode.getDepList();
            resultList.add(startNode);
        }
        if (CollectionUtils.isEmpty(depList)) {
            return resultList;
        }
        for (Long l : depList) {
            TaskNode start = DagHelper.findNodeByCode(taskNodeList, l);
            if (recoveryNodeCodeList.contains(l)) {
                resultList.add(start);
                continue;
            }
            if (visitedNodeCodeList.contains(l)) continue;
            resultList.addAll(DagHelper.getFlowNodeListPre(start, recoveryNodeCodeList, taskNodeList, visitedNodeCodeList));
        }
        if (null != startNode) {
            visitedNodeCodeList.add(startNode.getCode());
        }
        return resultList;
    }

    public static ProcessDag generateFlowDag(List<TaskNode> totalTaskNodeList, List<Long> startNodeNameList, List<Long> recoveryNodeCodeList, TaskDependType depNodeType) throws Exception {
        List<TaskNode> destTaskNodeList = DagHelper.generateFlowNodeListByStartNode(totalTaskNodeList, startNodeNameList, recoveryNodeCodeList, depNodeType);
        if (destTaskNodeList.isEmpty()) {
            return null;
        }
        List<TaskNodeRelation> taskNodeRelations = DagHelper.generateRelationListByFlowNodes(destTaskNodeList);
        ProcessDag processDag = new ProcessDag();
        processDag.setEdges(taskNodeRelations);
        processDag.setNodes(destTaskNodeList);
        return processDag;
    }

    public static TaskNode findNodeByName(List<TaskNode> nodeDetails, String nodeName) {
        for (TaskNode taskNode : nodeDetails) {
            if (!taskNode.getName().equals(nodeName)) continue;
            return taskNode;
        }
        return null;
    }

    public static TaskNode findNodeByCode(List<TaskNode> nodeDetails, Long nodeCode) {
        for (TaskNode taskNode : nodeDetails) {
            if (taskNode.getCode() != nodeCode.longValue()) continue;
            return taskNode;
        }
        return null;
    }

    public static boolean allDependsForbiddenOrEnd(TaskNode taskNode, DAG<Long, TaskNode, TaskNodeRelation> dag, Map<Long, TaskNode> skipTaskNodeList, Map<Long, TaskInstance> completeTaskList) {
        List<Long> dependList = taskNode.getDepList();
        if (dependList == null) {
            return true;
        }
        for (Long dependNodeCode : dependList) {
            TaskNode dependNode = (TaskNode)dag.getNode((Object)dependNodeCode);
            if (dependNode == null || completeTaskList.containsKey(dependNodeCode) || dependNode.isForbidden() || skipTaskNodeList.containsKey(dependNodeCode)) continue;
            return false;
        }
        return true;
    }

    public static Set<Long> parsePostNodes(Long preNodeCode, Map<Long, TaskNode> skipTaskNodeList, DAG<Long, TaskNode, TaskNodeRelation> dag, Map<Long, TaskInstance> completeTaskList) {
        List<Long> conditionTaskList;
        HashSet<Long> postNodeList = new HashSet<Long>();
        Collection<Long> startVertexes = new ArrayList();
        if (preNodeCode == null) {
            startVertexes = dag.getBeginNode();
        } else if (((TaskNode)dag.getNode((Object)preNodeCode)).isConditionsTask()) {
            conditionTaskList = DagHelper.parseConditionTask(preNodeCode, skipTaskNodeList, dag, completeTaskList);
            startVertexes.addAll(conditionTaskList);
        } else if (((TaskNode)dag.getNode((Object)preNodeCode)).isSwitchTask()) {
            conditionTaskList = DagHelper.parseSwitchTask(preNodeCode, skipTaskNodeList, dag, completeTaskList);
            startVertexes.addAll(conditionTaskList);
        } else {
            startVertexes = dag.getSubsequentNodes((Object)preNodeCode);
        }
        for (Long subsequent : startVertexes) {
            TaskNode taskNode = (TaskNode)dag.getNode((Object)subsequent);
            if (taskNode == null) {
                log.error("taskNode {} is null, please check dag", (Object)subsequent);
                continue;
            }
            if (DagHelper.isTaskNodeNeedSkip(taskNode, skipTaskNodeList)) {
                DagHelper.setTaskNodeSkip(subsequent, dag, completeTaskList, skipTaskNodeList);
                continue;
            }
            if (!DagHelper.allDependsForbiddenOrEnd(taskNode, dag, skipTaskNodeList, completeTaskList)) continue;
            if (taskNode.isForbidden() || completeTaskList.containsKey(subsequent)) {
                postNodeList.addAll(DagHelper.parsePostNodes(subsequent, skipTaskNodeList, dag, completeTaskList));
                continue;
            }
            postNodeList.add(subsequent);
        }
        return postNodeList;
    }

    private static boolean isTaskNodeNeedSkip(TaskNode taskNode, Map<Long, TaskNode> skipTaskNodeList) {
        if (CollectionUtils.isEmpty(taskNode.getDepList())) {
            return false;
        }
        for (Long depNode : taskNode.getDepList()) {
            if (skipTaskNodeList.containsKey(depNode)) continue;
            return false;
        }
        return true;
    }

    public static List<Long> parseConditionTask(Long nodeCode, Map<Long, TaskNode> skipTaskNodeList, DAG<Long, TaskNode, TaskNodeRelation> dag, Map<Long, TaskInstance> completeTaskList) {
        List<Long> conditionTaskList = new ArrayList<Long>();
        TaskNode taskNode = (TaskNode)dag.getNode((Object)nodeCode);
        if (!taskNode.isConditionsTask()) {
            return conditionTaskList;
        }
        if (!completeTaskList.containsKey(nodeCode)) {
            return conditionTaskList;
        }
        TaskInstance taskInstance = completeTaskList.get(nodeCode);
        ConditionsParameters conditionsParameters = (ConditionsParameters)JSONUtils.parseObject((String)taskNode.getConditionResult(), ConditionsParameters.class);
        List skipNodeList = new ArrayList();
        if (taskInstance.getState().isSuccess()) {
            conditionTaskList = conditionsParameters.getSuccessNode();
            skipNodeList = conditionsParameters.getFailedNode();
        } else if (taskInstance.getState().isFailure()) {
            conditionTaskList = conditionsParameters.getFailedNode();
            skipNodeList = conditionsParameters.getSuccessNode();
        } else {
            conditionTaskList.add(nodeCode);
        }
        skipNodeList = Optional.ofNullable(skipNodeList).orElse(new ArrayList());
        for (Long failedNode : skipNodeList) {
            DagHelper.setTaskNodeSkip(failedNode, dag, completeTaskList, skipTaskNodeList);
        }
        conditionTaskList = Optional.ofNullable(conditionTaskList).orElse(new ArrayList());
        return conditionTaskList;
    }

    public static List<Long> parseSwitchTask(Long nodeCode, Map<Long, TaskNode> skipTaskNodeList, DAG<Long, TaskNode, TaskNodeRelation> dag, Map<Long, TaskInstance> completeTaskList) {
        List<Long> conditionTaskList = new ArrayList<Long>();
        TaskNode taskNode = (TaskNode)dag.getNode((Object)nodeCode);
        if (!taskNode.isSwitchTask()) {
            return conditionTaskList;
        }
        if (!completeTaskList.containsKey(nodeCode)) {
            return conditionTaskList;
        }
        conditionTaskList = DagHelper.skipTaskNode4Switch(taskNode, skipTaskNodeList, completeTaskList, dag);
        return conditionTaskList;
    }

    public static List<Long> skipTaskNode4Switch(TaskNode taskNode, Map<Long, TaskNode> skipTaskNodeList, Map<Long, TaskInstance> completeTaskList, DAG<Long, TaskNode, TaskNodeRelation> dag) {
        SwitchParameters switchParameters = completeTaskList.get(taskNode.getCode()).getSwitchDependency();
        int resultConditionLocation = switchParameters.getResultConditionLocation();
        List conditionResultVoList = switchParameters.getDependTaskList();
        List switchTaskList = ((SwitchResultVo)conditionResultVoList.get(resultConditionLocation)).getNextNode();
        HashSet<Long> switchNeedWorkCodes = new HashSet<Long>();
        if (CollectionUtils.isEmpty((Collection)switchTaskList)) {
            return new ArrayList<Long>();
        }
        for (Long switchTaskCode : switchTaskList) {
            DagHelper.getSwitchNeedWorkCodes(switchTaskCode, dag, switchNeedWorkCodes);
        }
        for (SwitchResultVo info : conditionResultVoList) {
            if (CollectionUtils.isEmpty((Collection)info.getNextNode())) continue;
            for (Long nextNode : info.getNextNode()) {
                DagHelper.setSwitchTaskNodeSkip(nextNode, dag, completeTaskList, skipTaskNodeList, switchNeedWorkCodes);
            }
        }
        return switchTaskList;
    }

    public static void getSwitchNeedWorkCodes(Long taskCode, DAG<Long, TaskNode, TaskNodeRelation> dag, Set<Long> switchNeedWorkCodes) {
        switchNeedWorkCodes.add(taskCode);
        Set subsequentNodes = dag.getSubsequentNodes((Object)taskCode);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)subsequentNodes)) {
            for (Long subCode : subsequentNodes) {
                DagHelper.getSwitchNeedWorkCodes(subCode, dag, switchNeedWorkCodes);
            }
        }
    }

    private static void setSwitchTaskNodeSkip(Long skipNodeCode, DAG<Long, TaskNode, TaskNodeRelation> dag, Map<Long, TaskInstance> completeTaskList, Map<Long, TaskNode> skipTaskNodeList, Set<Long> switchNeedWorkCodes) {
        if (!dag.containsNode((Object)skipNodeCode) || switchNeedWorkCodes.contains(skipNodeCode)) {
            return;
        }
        skipTaskNodeList.putIfAbsent(skipNodeCode, (TaskNode)dag.getNode((Object)skipNodeCode));
        Set postNodeList = dag.getSubsequentNodes((Object)skipNodeCode);
        for (Long post : postNodeList) {
            TaskNode postNode = (TaskNode)dag.getNode((Object)post);
            if (!DagHelper.isTaskNodeNeedSkip(postNode, skipTaskNodeList)) continue;
            DagHelper.setTaskNodeSkip(post, dag, completeTaskList, skipTaskNodeList);
        }
    }

    private static void setTaskNodeSkip(Long skipNodeCode, DAG<Long, TaskNode, TaskNodeRelation> dag, Map<Long, TaskInstance> completeTaskList, Map<Long, TaskNode> skipTaskNodeList) {
        if (!dag.containsNode((Object)skipNodeCode)) {
            return;
        }
        skipTaskNodeList.putIfAbsent(skipNodeCode, (TaskNode)dag.getNode((Object)skipNodeCode));
        Set postNodeList = dag.getSubsequentNodes((Object)skipNodeCode);
        for (Long post : postNodeList) {
            TaskNode postNode = (TaskNode)dag.getNode((Object)post);
            if (!DagHelper.isTaskNodeNeedSkip(postNode, skipTaskNodeList)) continue;
            DagHelper.setTaskNodeSkip(post, dag, completeTaskList, skipTaskNodeList);
        }
    }

    public static DAG<Long, TaskNode, TaskNodeRelation> buildDagGraph(ProcessDag processDag) {
        DAG dag = new DAG();
        if (CollectionUtils.isNotEmpty(processDag.getNodes())) {
            for (TaskNode node : processDag.getNodes()) {
                dag.addNode((Object)node.getCode(), (Object)node);
            }
        }
        if (CollectionUtils.isNotEmpty(processDag.getEdges())) {
            for (TaskNodeRelation edge : processDag.getEdges()) {
                dag.addEdge((Object)edge.getStartNode(), (Object)edge.getEndNode());
            }
        }
        return dag;
    }

    public static ProcessDag getProcessDag(List<TaskNode> taskNodeList) {
        ArrayList<TaskNodeRelation> taskNodeRelations = new ArrayList<TaskNodeRelation>();
        for (TaskNode taskNode : taskNodeList) {
            String preTasks = taskNode.getPreTasks();
            List preTasksList = JSONUtils.toList((String)preTasks, Long.class);
            if (preTasksList == null) continue;
            for (Long depNode : preTasksList) {
                taskNodeRelations.add(new TaskNodeRelation(depNode, Long.valueOf(taskNode.getCode())));
            }
        }
        ProcessDag processDag = new ProcessDag();
        processDag.setEdges(taskNodeRelations);
        processDag.setNodes(taskNodeList);
        return processDag;
    }

    public static ProcessDag getProcessDag(List<TaskNode> taskNodeList, List<ProcessTaskRelation> processTaskRelations) {
        HashMap taskNodeMap = new HashMap();
        taskNodeList.forEach(taskNode -> taskNodeMap.putIfAbsent(taskNode.getCode(), taskNode));
        ArrayList<TaskNodeRelation> taskNodeRelations = new ArrayList<TaskNodeRelation>();
        for (ProcessTaskRelation processTaskRelation : processTaskRelations) {
            long preTaskCode = processTaskRelation.getPreTaskCode();
            long postTaskCode = processTaskRelation.getPostTaskCode();
            if (processTaskRelation.getPreTaskCode() == 0L || !taskNodeMap.containsKey(preTaskCode) || !taskNodeMap.containsKey(postTaskCode)) continue;
            TaskNode preNode = (TaskNode)taskNodeMap.get(preTaskCode);
            TaskNode postNode = (TaskNode)taskNodeMap.get(postTaskCode);
            taskNodeRelations.add(new TaskNodeRelation(Long.valueOf(preNode.getCode()), Long.valueOf(postNode.getCode())));
        }
        ProcessDag processDag = new ProcessDag();
        processDag.setEdges(taskNodeRelations);
        processDag.setNodes(taskNodeList);
        return processDag;
    }

    public static boolean haveConditionsAfterNode(Long parentNodeCode, DAG<Long, TaskNode, TaskNodeRelation> dag) {
        return DagHelper.haveSubAfterNode(parentNodeCode, dag, "CONDITIONS");
    }

    public static boolean haveConditionsAfterNode(Long parentNodeCode, List<TaskNode> taskNodes) {
        if (CollectionUtils.isEmpty(taskNodes)) {
            return false;
        }
        for (TaskNode taskNode : taskNodes) {
            List preTasksList = JSONUtils.toList((String)taskNode.getPreTasks(), Long.class);
            if (!preTasksList.contains(parentNodeCode) || !taskNode.isConditionsTask()) continue;
            return true;
        }
        return false;
    }

    public static boolean haveBlockingAfterNode(Long parentNodeCode, DAG<Long, TaskNode, TaskNodeRelation> dag) {
        return DagHelper.haveSubAfterNode(parentNodeCode, dag, "BLOCKING");
    }

    public static boolean haveAllNodeAfterNode(Long parentNodeCode, DAG<Long, TaskNode, TaskNodeRelation> dag) {
        return DagHelper.haveSubAfterNode(parentNodeCode, dag, null);
    }

    public static boolean haveSubAfterNode(Long parentNodeCode, DAG<Long, TaskNode, TaskNodeRelation> dag, String filterNodeType) {
        Set subsequentNodes = dag.getSubsequentNodes((Object)parentNodeCode);
        if (CollectionUtils.isEmpty((Collection)subsequentNodes)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)filterNodeType)) {
            return true;
        }
        for (Long nodeName : subsequentNodes) {
            TaskNode taskNode = (TaskNode)dag.getNode((Object)nodeName);
            if (!taskNode.getType().equalsIgnoreCase(filterNodeType)) continue;
            return true;
        }
        return false;
    }
}

