/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.storage.hdfs;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.ResUploadType;
import org.apache.dolphinscheduler.common.exception.BaseException;
import org.apache.dolphinscheduler.common.utils.HttpUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.KerberosHttpClient;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.CommonUtils;
import org.apache.dolphinscheduler.plugin.storage.api.StorageEntity;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperate;
import org.apache.dolphinscheduler.plugin.storage.hdfs.HdfsStorageProperties;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsStorageOperator
implements Closeable,
StorageOperate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HdfsStorageOperator.class);
    protected static HdfsStorageProperties hdfsProperties = new HdfsStorageProperties();
    private static final String HADOOP_UTILS_KEY = "HADOOP_UTILS_KEY";
    private volatile boolean yarnEnabled = false;
    private Configuration configuration;
    private FileSystem fs;

    public HdfsStorageOperator() {
        this(new HdfsStorageProperties());
    }

    public HdfsStorageOperator(HdfsStorageProperties hdfsStorageProperties) {
        hdfsProperties = hdfsStorageProperties;
        this.init();
        this.initHdfsPath();
    }

    private void initHdfsPath() {
        Path path = new Path(RESOURCE_UPLOAD_PATH);
        try {
            if (!this.fs.exists(path)) {
                this.fs.mkdirs(path);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void init() throws NullPointerException {
        try {
            String defaultFS;
            this.configuration = new HdfsConfiguration();
            String hdfsUser = hdfsProperties.getUser();
            if (CommonUtils.loadKerberosConf((Configuration)this.configuration)) {
                hdfsUser = "";
            }
            if (!StringUtils.isNotBlank((CharSequence)(defaultFS = this.getDefaultFS()))) {
                log.error("property:{} can not to be empty, please set!", (Object)"resource.hdfs.fs.defaultFS");
                throw new NullPointerException(String.format("property: %s can not to be empty, please set!", "resource.hdfs.fs.defaultFS"));
            }
            Map fsRelatedProps = PropertyUtils.getByPrefix((String)"fs.");
            this.configuration.set("fs.defaultFS", defaultFS);
            fsRelatedProps.forEach((key, value) -> this.configuration.set(key, value));
            if (!defaultFS.startsWith("file")) {
                log.info("get property:{} -> {}, from core-site.xml hdfs-site.xml ", (Object)"resource.hdfs.fs.defaultFS", (Object)defaultFS);
            }
            if (StringUtils.isNotEmpty((CharSequence)hdfsUser)) {
                UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)hdfsUser);
                ugi.doAs(() -> {
                    this.fs = FileSystem.get((Configuration)this.configuration);
                    return true;
                });
            } else {
                log.warn("resource.hdfs.root.user is not set value!");
                this.fs = FileSystem.get((Configuration)this.configuration);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getDefaultFS() {
        String defaultFS = hdfsProperties.getDefaultFS();
        if (StringUtils.isBlank((CharSequence)defaultFS)) {
            defaultFS = this.getConfiguration().get("fs.defaultFS");
        }
        return defaultFS;
    }

    public String getApplicationUrl(String applicationId) throws BaseException {
        String appUrl;
        this.yarnEnabled = true;
        String string = appUrl = StringUtils.isEmpty((CharSequence)hdfsProperties.getYarnResourceRmIds()) ? hdfsProperties.getYarnAppStatusAddress() : HdfsStorageOperator.getAppAddress(hdfsProperties.getYarnAppStatusAddress(), hdfsProperties.getYarnResourceRmIds());
        if (StringUtils.isBlank((CharSequence)appUrl)) {
            throw new BaseException("yarn application url generation failed");
        }
        log.debug("yarn application url:{}, applicationId:{}", (Object)appUrl, (Object)applicationId);
        return String.format(appUrl, hdfsProperties.getHadoopResourceManagerHttpAddressPort(), applicationId);
    }

    public String getJobHistoryUrl(String applicationId) {
        String jobId = applicationId.replace("application", "job");
        return String.format(hdfsProperties.getYarnJobHistoryStatusAddress(), jobId);
    }

    public byte[] catFile(String hdfsFilePath) throws IOException {
        if (StringUtils.isBlank((CharSequence)hdfsFilePath)) {
            log.error("hdfs file path:{} is blank", (Object)hdfsFilePath);
            return new byte[0];
        }
        try (FSDataInputStream fsDataInputStream = this.fs.open(new Path(hdfsFilePath));){
            byte[] byArray = IOUtils.toByteArray((InputStream)fsDataInputStream);
            return byArray;
        }
    }

    public List<String> catFile(String hdfsFilePath, int skipLineNums, int limit) throws IOException {
        if (StringUtils.isBlank((CharSequence)hdfsFilePath)) {
            log.error("hdfs file path:{} is blank", (Object)hdfsFilePath);
            return Collections.emptyList();
        }
        try (FSDataInputStream in = this.fs.open(new Path(hdfsFilePath));){
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));
            Stream<String> stream = br.lines().skip(skipLineNums).limit(limit);
            List<String> list = stream.collect(Collectors.toList());
            return list;
        }
    }

    public List<String> vimFile(String bucketName, String hdfsFilePath, int skipLineNums, int limit) throws IOException {
        return this.catFile(hdfsFilePath, skipLineNums, limit);
    }

    public void createTenantDirIfNotExists(String tenantCode) throws IOException {
        this.mkdir(tenantCode, HdfsStorageOperator.getHdfsResDir(tenantCode));
        this.mkdir(tenantCode, HdfsStorageOperator.getHdfsUdfDir(tenantCode));
    }

    public String getResDir(String tenantCode) {
        return HdfsStorageOperator.getHdfsResDir(tenantCode) + "/";
    }

    public String getUdfDir(String tenantCode) {
        return HdfsStorageOperator.getHdfsUdfDir(tenantCode) + "/";
    }

    public boolean mkdir(String tenantCode, String hdfsPath) throws IOException {
        return this.fs.mkdirs(new Path(this.addFolderSeparatorIfNotExisted(hdfsPath)));
    }

    public String getResourceFullName(String tenantCode, String fullName) {
        return HdfsStorageOperator.getHdfsResourceFileName(tenantCode, fullName);
    }

    public String getFileName(ResourceType resourceType, String tenantCode, String fileName) {
        return HdfsStorageOperator.getHdfsFileName(resourceType, tenantCode, fileName);
    }

    public void download(String srcHdfsFilePath, String dstFile, boolean overwrite) throws IOException {
        this.copyHdfsToLocal(srcHdfsFilePath, dstFile, false, overwrite);
    }

    public boolean copy(String srcPath, String dstPath, boolean deleteSource, boolean overwrite) throws IOException {
        return FileUtil.copy((FileSystem)this.fs, (Path)new Path(srcPath), (FileSystem)this.fs, (Path)new Path(dstPath), (boolean)deleteSource, (boolean)overwrite, (Configuration)this.fs.getConf());
    }

    public boolean copyLocalToHdfs(String srcFile, String dstHdfsPath, boolean deleteSource, boolean overwrite) throws IOException {
        Path srcPath = new Path(srcFile);
        Path dstPath = new Path(dstHdfsPath);
        this.fs.copyFromLocalFile(deleteSource, overwrite, srcPath, dstPath);
        return true;
    }

    public boolean upload(String buckName, String srcFile, String dstPath, boolean deleteSource, boolean overwrite) throws IOException {
        return this.copyLocalToHdfs(srcFile, dstPath, deleteSource, overwrite);
    }

    public boolean copyHdfsToLocal(String srcHdfsFilePath, String dstFile, boolean deleteSource, boolean overwrite) throws IOException {
        Path srcPath = new Path(srcHdfsFilePath);
        File dstPath = new File(dstFile);
        if (dstPath.exists()) {
            if (dstPath.isFile()) {
                if (overwrite) {
                    Files.delete(dstPath.toPath());
                }
            } else {
                log.error("destination file must be a file");
            }
        }
        if (!dstPath.getParentFile().exists() && !dstPath.getParentFile().mkdirs()) {
            return false;
        }
        return FileUtil.copy((FileSystem)this.fs, (Path)srcPath, (File)dstPath, (boolean)deleteSource, (Configuration)this.fs.getConf());
    }

    public boolean delete(String hdfsFilePath, boolean recursive) throws IOException {
        return this.fs.delete(new Path(hdfsFilePath), recursive);
    }

    public boolean delete(String filePath, List<String> childrenPathArray, boolean recursive) throws IOException {
        if (filePath.endsWith("/")) {
            return this.fs.delete(new Path(filePath), true);
        }
        return this.fs.delete(new Path(filePath), recursive);
    }

    public boolean exists(String hdfsFilePath) throws IOException {
        return this.fs.exists(new Path(hdfsFilePath));
    }

    public List<StorageEntity> listFilesStatus(String path, String defaultPath, String tenantCode, ResourceType type) throws IOException {
        ArrayList<StorageEntity> storageEntityList = new ArrayList<StorageEntity>();
        try {
            FileStatus[] fileStatuses;
            Path filePath = new Path(path);
            if (!this.fs.exists(filePath)) {
                return storageEntityList;
            }
            for (FileStatus fileStatus : fileStatuses = this.fs.listStatus(filePath)) {
                String fullName;
                if (fileStatus.isDirectory()) {
                    fullName = fileStatus.getPath().toString();
                    fullName = this.addFolderSeparatorIfNotExisted(fullName);
                    String suffix = StringUtils.difference((String)path, (String)fullName);
                    String fileName = StringUtils.difference((String)defaultPath, (String)fullName);
                    StorageEntity entity = new StorageEntity();
                    entity.setAlias(suffix);
                    entity.setFileName(fileName);
                    entity.setFullName(fullName);
                    entity.setDirectory(true);
                    entity.setUserName(tenantCode);
                    entity.setType(type);
                    entity.setSize(fileStatus.getLen());
                    entity.setCreateTime(new Date(fileStatus.getModificationTime()));
                    entity.setUpdateTime(new Date(fileStatus.getModificationTime()));
                    entity.setPfullName(path);
                    storageEntityList.add(entity);
                    continue;
                }
                fullName = fileStatus.getPath().toString();
                String[] aliasArr = fullName.split("/");
                String alias = aliasArr[aliasArr.length - 1];
                String fileName = StringUtils.difference((String)defaultPath, (String)fullName);
                StorageEntity entity = new StorageEntity();
                entity.setAlias(alias);
                entity.setFileName(fileName);
                entity.setFullName(fullName);
                entity.setDirectory(false);
                entity.setUserName(tenantCode);
                entity.setType(type);
                entity.setSize(fileStatus.getLen());
                entity.setCreateTime(new Date(fileStatus.getModificationTime()));
                entity.setUpdateTime(new Date(fileStatus.getModificationTime()));
                entity.setPfullName(path);
                storageEntityList.add(entity);
            }
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("The path does not exist.");
        }
        catch (IOException e) {
            throw new IOException("Get file list exception.", e);
        }
        return storageEntityList;
    }

    public StorageEntity getFileStatus(String path, String prefix, String tenantCode, ResourceType type) throws IOException {
        try {
            FileStatus fileStatus = this.fs.getFileStatus(new Path(path));
            String alias = "";
            String fileName = "";
            String fullName = fileStatus.getPath().toString();
            if (fileStatus.isDirectory()) {
                fullName = this.addFolderSeparatorIfNotExisted(fullName);
                alias = this.findDirAlias(fullName);
                fileName = StringUtils.difference((String)prefix, (String)fullName);
            } else {
                String[] aliasArr = fileStatus.getPath().toString().split("/");
                alias = aliasArr[aliasArr.length - 1];
                fileName = StringUtils.difference((String)prefix, (String)fileStatus.getPath().toString());
            }
            StorageEntity entity = new StorageEntity();
            entity.setAlias(alias);
            entity.setFileName(fileName);
            entity.setFullName(fullName);
            entity.setDirectory(fileStatus.isDirectory());
            entity.setUserName(tenantCode);
            entity.setType(type);
            entity.setSize(fileStatus.getLen());
            entity.setCreateTime(new Date(fileStatus.getModificationTime()));
            entity.setUpdateTime(new Date(fileStatus.getModificationTime()));
            entity.setPfullName(path);
            return entity;
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("The path does not exist.");
        }
        catch (IOException e) {
            throw new IOException("Get file exception.", e);
        }
    }

    public boolean rename(String src, String dst) throws IOException {
        return this.fs.rename(new Path(src), new Path(dst));
    }

    public boolean isYarnEnabled() {
        return this.yarnEnabled;
    }

    public static String getHdfsDataBasePath() {
        String defaultFS = hdfsProperties.getDefaultFS();
        String string = defaultFS = defaultFS.endsWith("/") ? StringUtils.chop((String)defaultFS) : defaultFS;
        if ("/".equals(RESOURCE_UPLOAD_PATH)) {
            return defaultFS + "";
        }
        return defaultFS + RESOURCE_UPLOAD_PATH;
    }

    public static String getHdfsDir(ResourceType resourceType, String tenantCode) {
        switch (resourceType) {
            case UDF: {
                return HdfsStorageOperator.getHdfsUdfDir(tenantCode);
            }
            case FILE: {
                return HdfsStorageOperator.getHdfsResDir(tenantCode);
            }
            case ALL: {
                return HdfsStorageOperator.getHdfsDataBasePath();
            }
        }
        return "";
    }

    public String getDir(ResourceType resourceType, String tenantCode) {
        return HdfsStorageOperator.getHdfsDir(resourceType, tenantCode);
    }

    public static String getHdfsResDir(String tenantCode) {
        return String.format("%s/resources", HdfsStorageOperator.getHdfsTenantDir(tenantCode));
    }

    public static String getHdfsUdfDir(String tenantCode) {
        return String.format("%s/udfs", HdfsStorageOperator.getHdfsTenantDir(tenantCode));
    }

    public static String getHdfsFileName(ResourceType resourceType, String tenantCode, String fileName) {
        if (fileName.startsWith("/")) {
            fileName = fileName.replaceFirst("/", "");
        }
        return String.format("%s/%s", HdfsStorageOperator.getHdfsDir(resourceType, tenantCode), fileName);
    }

    public static String getHdfsResourceFileName(String tenantCode, String fileName) {
        if (fileName.startsWith("/")) {
            fileName = fileName.replaceFirst("/", "");
        }
        return String.format("%s/%s", HdfsStorageOperator.getHdfsResDir(tenantCode), fileName);
    }

    public static String getHdfsUdfFileName(String tenantCode, String fileName) {
        if (fileName.startsWith("/")) {
            fileName = fileName.replaceFirst("/", "");
        }
        return String.format("%s/%s", HdfsStorageOperator.getHdfsUdfDir(tenantCode), fileName);
    }

    public static String getHdfsTenantDir(String tenantCode) {
        return String.format("%s/%s", HdfsStorageOperator.getHdfsDataBasePath(), tenantCode);
    }

    public static String getAppAddress(String appAddress, String rmHa) {
        String[] split1 = appAddress.split("//");
        if (split1.length != 2) {
            return null;
        }
        String start = split1[0] + "//";
        String[] split2 = split1[1].split(":");
        if (split2.length != 2) {
            return null;
        }
        String end = ":" + split2[1];
        String activeRM = YarnHAAdminUtils.getActiveRMName(start, rmHa);
        if (StringUtils.isEmpty((CharSequence)activeRM)) {
            return null;
        }
        return start + activeRM + end;
    }

    @Override
    public void close() throws IOException {
        if (this.fs != null) {
            try {
                this.fs.close();
            }
            catch (IOException e) {
                log.error("Close HadoopUtils instance failed", (Throwable)e);
                throw new IOException("Close HadoopUtils instance failed", e);
            }
        }
    }

    public void deleteTenant(String tenantCode) throws Exception {
        String tenantPath = HdfsStorageOperator.getHdfsDataBasePath() + "/" + tenantCode;
        if (this.exists(tenantPath)) {
            this.delete(tenantPath, true);
        }
    }

    public ResUploadType returnStorageType() {
        return ResUploadType.HDFS;
    }

    public List<StorageEntity> listFilesStatusRecursively(String path, String defaultPath, String tenantCode, ResourceType type) {
        ArrayList<StorageEntity> storageEntityList = new ArrayList<StorageEntity>();
        LinkedList<StorageEntity> foldersToFetch = new LinkedList<StorageEntity>();
        do {
            String pathToExplore = "";
            pathToExplore = foldersToFetch.size() == 0 ? path : ((StorageEntity)foldersToFetch.pop()).getFullName();
            try {
                List<StorageEntity> tempList = this.listFilesStatus(pathToExplore, defaultPath, tenantCode, type);
                for (StorageEntity temp : tempList) {
                    if (!temp.isDirectory()) continue;
                    foldersToFetch.add(temp);
                }
                storageEntityList.addAll(tempList);
            }
            catch (FileNotFoundException e) {
                log.error("Resource path: {}", (Object)pathToExplore, (Object)e);
                return storageEntityList;
            }
            catch (IOException e) {
                log.error("Resource path: {}", (Object)pathToExplore, (Object)e);
                return storageEntityList;
            }
        } while (foldersToFetch.size() != 0);
        return storageEntityList;
    }

    private String findDirAlias(String myStr) {
        if (!myStr.endsWith("/")) {
            return myStr;
        }
        int lastIndex = myStr.lastIndexOf("/");
        String subbedString = myStr.substring(0, lastIndex);
        int secondLastIndex = subbedString.lastIndexOf("/");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(myStr, secondLastIndex + 1, lastIndex + 1);
        return stringBuilder.toString();
    }

    private String addFolderSeparatorIfNotExisted(String fullName) {
        return fullName.endsWith("/") ? fullName : fullName + "/";
    }

    private static final class YarnHAAdminUtils {
        private YarnHAAdminUtils() {
        }

        public static String getActiveRMName(String protocol, String rmIds) {
            String[] rmIdArr = rmIds.split(",");
            String yarnUrl = protocol + "%s:" + hdfsProperties.getHadoopResourceManagerHttpAddressPort() + "/ws/v1/cluster/info";
            try {
                for (String rmId : rmIdArr) {
                    String state = YarnHAAdminUtils.getRMState(String.format(yarnUrl, rmId));
                    if (!"ACTIVE".equals(state)) continue;
                    return rmId;
                }
            }
            catch (Exception e) {
                log.error("yarn ha application url generation failed, message:{}", (Object)e.getMessage());
            }
            return null;
        }

        public static String getRMState(String url) {
            String retStr;
            String string = retStr = Boolean.TRUE.equals(hdfsProperties.isHadoopSecurityAuthStartupState()) ? KerberosHttpClient.get((String)url) : HttpUtils.get((String)url);
            if (StringUtils.isEmpty((CharSequence)retStr)) {
                return null;
            }
            ObjectNode jsonObject = JSONUtils.parseObject((String)retStr);
            if (!jsonObject.has("clusterInfo")) {
                return null;
            }
            return jsonObject.get("clusterInfo").path("haState").asText();
        }
    }
}

