/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.storage.hdfs;

import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HdfsStorageProperties {
    private String user = PropertyUtils.getString((String)"resource.hdfs.root.user");
    private String defaultFS = PropertyUtils.getString((String)"resource.hdfs.fs.defaultFS");
    private String yarnResourceRmIds = PropertyUtils.getString((String)"yarn.resourcemanager.ha.rm.ids");
    private String yarnAppStatusAddress = PropertyUtils.getString((String)"yarn.application.status.address");
    private String yarnJobHistoryStatusAddress = PropertyUtils.getString((String)"yarn.job.history.status.address");
    private String hadoopResourceManagerHttpAddressPort = PropertyUtils.getString((String)"resource.manager.httpaddress.port");
    private boolean hadoopSecurityAuthStartupState = PropertyUtils.getBoolean((String)"hadoop.security.authentication.startup.state", (Boolean)false);

    public static int getKerberosExpireTime() {
        return PropertyUtils.getInt((String)"kerberos.expire.time", (int)2);
    }

    @Generated
    public HdfsStorageProperties() {
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public String getDefaultFS() {
        return this.defaultFS;
    }

    @Generated
    public String getYarnResourceRmIds() {
        return this.yarnResourceRmIds;
    }

    @Generated
    public String getYarnAppStatusAddress() {
        return this.yarnAppStatusAddress;
    }

    @Generated
    public String getYarnJobHistoryStatusAddress() {
        return this.yarnJobHistoryStatusAddress;
    }

    @Generated
    public String getHadoopResourceManagerHttpAddressPort() {
        return this.hadoopResourceManagerHttpAddressPort;
    }

    @Generated
    public boolean isHadoopSecurityAuthStartupState() {
        return this.hadoopSecurityAuthStartupState;
    }

    @Generated
    public void setUser(String user) {
        this.user = user;
    }

    @Generated
    public void setDefaultFS(String defaultFS) {
        this.defaultFS = defaultFS;
    }

    @Generated
    public void setYarnResourceRmIds(String yarnResourceRmIds) {
        this.yarnResourceRmIds = yarnResourceRmIds;
    }

    @Generated
    public void setYarnAppStatusAddress(String yarnAppStatusAddress) {
        this.yarnAppStatusAddress = yarnAppStatusAddress;
    }

    @Generated
    public void setYarnJobHistoryStatusAddress(String yarnJobHistoryStatusAddress) {
        this.yarnJobHistoryStatusAddress = yarnJobHistoryStatusAddress;
    }

    @Generated
    public void setHadoopResourceManagerHttpAddressPort(String hadoopResourceManagerHttpAddressPort) {
        this.hadoopResourceManagerHttpAddressPort = hadoopResourceManagerHttpAddressPort;
    }

    @Generated
    public void setHadoopSecurityAuthStartupState(boolean hadoopSecurityAuthStartupState) {
        this.hadoopSecurityAuthStartupState = hadoopSecurityAuthStartupState;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HdfsStorageProperties)) {
            return false;
        }
        HdfsStorageProperties other = (HdfsStorageProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHadoopSecurityAuthStartupState() != other.isHadoopSecurityAuthStartupState()) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$defaultFS = this.getDefaultFS();
        String other$defaultFS = other.getDefaultFS();
        if (this$defaultFS == null ? other$defaultFS != null : !this$defaultFS.equals(other$defaultFS)) {
            return false;
        }
        String this$yarnResourceRmIds = this.getYarnResourceRmIds();
        String other$yarnResourceRmIds = other.getYarnResourceRmIds();
        if (this$yarnResourceRmIds == null ? other$yarnResourceRmIds != null : !this$yarnResourceRmIds.equals(other$yarnResourceRmIds)) {
            return false;
        }
        String this$yarnAppStatusAddress = this.getYarnAppStatusAddress();
        String other$yarnAppStatusAddress = other.getYarnAppStatusAddress();
        if (this$yarnAppStatusAddress == null ? other$yarnAppStatusAddress != null : !this$yarnAppStatusAddress.equals(other$yarnAppStatusAddress)) {
            return false;
        }
        String this$yarnJobHistoryStatusAddress = this.getYarnJobHistoryStatusAddress();
        String other$yarnJobHistoryStatusAddress = other.getYarnJobHistoryStatusAddress();
        if (this$yarnJobHistoryStatusAddress == null ? other$yarnJobHistoryStatusAddress != null : !this$yarnJobHistoryStatusAddress.equals(other$yarnJobHistoryStatusAddress)) {
            return false;
        }
        String this$hadoopResourceManagerHttpAddressPort = this.getHadoopResourceManagerHttpAddressPort();
        String other$hadoopResourceManagerHttpAddressPort = other.getHadoopResourceManagerHttpAddressPort();
        return !(this$hadoopResourceManagerHttpAddressPort == null ? other$hadoopResourceManagerHttpAddressPort != null : !this$hadoopResourceManagerHttpAddressPort.equals(other$hadoopResourceManagerHttpAddressPort));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HdfsStorageProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHadoopSecurityAuthStartupState() ? 79 : 97);
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $defaultFS = this.getDefaultFS();
        result = result * 59 + ($defaultFS == null ? 43 : $defaultFS.hashCode());
        String $yarnResourceRmIds = this.getYarnResourceRmIds();
        result = result * 59 + ($yarnResourceRmIds == null ? 43 : $yarnResourceRmIds.hashCode());
        String $yarnAppStatusAddress = this.getYarnAppStatusAddress();
        result = result * 59 + ($yarnAppStatusAddress == null ? 43 : $yarnAppStatusAddress.hashCode());
        String $yarnJobHistoryStatusAddress = this.getYarnJobHistoryStatusAddress();
        result = result * 59 + ($yarnJobHistoryStatusAddress == null ? 43 : $yarnJobHistoryStatusAddress.hashCode());
        String $hadoopResourceManagerHttpAddressPort = this.getHadoopResourceManagerHttpAddressPort();
        result = result * 59 + ($hadoopResourceManagerHttpAddressPort == null ? 43 : $hadoopResourceManagerHttpAddressPort.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HdfsStorageProperties(user=" + this.getUser() + ", defaultFS=" + this.getDefaultFS() + ", yarnResourceRmIds=" + this.getYarnResourceRmIds() + ", yarnAppStatusAddress=" + this.getYarnAppStatusAddress() + ", yarnJobHistoryStatusAddress=" + this.getYarnJobHistoryStatusAddress() + ", hadoopResourceManagerHttpAddressPort=" + this.getHadoopResourceManagerHttpAddressPort() + ", hadoopSecurityAuthStartupState=" + this.isHadoopSecurityAuthStartupState() + ")";
    }
}

