/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.emr;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduce;
import com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClientBuilder;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.util.TimeZone;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractRemoteTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.emr.EmrParameters;
import org.apache.dolphinscheduler.plugin.task.emr.EmrTaskException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEmrTask
extends AbstractRemoteTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractEmrTask.class);
    final TaskExecutionContext taskExecutionContext;
    EmrParameters emrParameters;
    AmazonElasticMapReduce emrClient;
    String clusterId;
    static final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true).configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true).configure(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS, true).setTimeZone(TimeZone.getDefault()).setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategy.UpperCamelCaseStrategy());

    protected AbstractEmrTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public void init() {
        String taskParams = this.taskExecutionContext.getTaskParams();
        this.emrParameters = (EmrParameters)((Object)JSONUtils.parseObject((String)taskParams, EmrParameters.class));
        log.info("Initialize emr task params:{}", (Object)JSONUtils.toPrettyJsonString((Object)taskParams));
        if (this.emrParameters == null || !this.emrParameters.checkParameters()) {
            throw new EmrTaskException("emr task params is not valid");
        }
        this.emrClient = this.createEmrClient();
    }

    public AbstractParameters getParameters() {
        return this.emrParameters;
    }

    protected AmazonElasticMapReduce createEmrClient() {
        String awsAccessKeyId = PropertyUtils.getString((String)"resource.aws.access.key.id");
        String awsSecretAccessKey = PropertyUtils.getString((String)"resource.aws.secret.access.key");
        String awsRegion = PropertyUtils.getString((String)"resource.aws.region");
        BasicAWSCredentials basicAWSCredentials = new BasicAWSCredentials(awsAccessKeyId, awsSecretAccessKey);
        AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)basicAWSCredentials);
        return (AmazonElasticMapReduce)((AmazonElasticMapReduceClientBuilder)((AmazonElasticMapReduceClientBuilder)AmazonElasticMapReduceClientBuilder.standard().withCredentials((AWSCredentialsProvider)awsCredentialsProvider)).withRegion(awsRegion)).build();
    }
}

