/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.definition.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.dubbo.metadata.definition.model.MethodDefinition;
import org.apache.dubbo.metadata.definition.model.TypeDefinition;

public class ServiceDefinition
implements Serializable {
    private String canonicalName;
    private String codeSource;
    private List<MethodDefinition> methods;
    private List<TypeDefinition> types;

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public String getCodeSource() {
        return this.codeSource;
    }

    public List<MethodDefinition> getMethods() {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodDefinition>();
        }
        return this.methods;
    }

    public List<TypeDefinition> getTypes() {
        if (this.types == null) {
            this.types = new ArrayList<TypeDefinition>();
        }
        return this.types;
    }

    public String getUniqueId() {
        return this.canonicalName + "@" + this.codeSource;
    }

    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    public void setCodeSource(String codeSource) {
        this.codeSource = codeSource;
    }

    public void setMethods(List<MethodDefinition> methods) {
        this.methods = methods;
    }

    public void setTypes(List<TypeDefinition> types) {
        this.types = types;
    }

    public String toString() {
        return "ServiceDefinition [canonicalName=" + this.canonicalName + ", codeSource=" + this.codeSource + ", methods=" + this.methods + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceDefinition)) {
            return false;
        }
        ServiceDefinition that = (ServiceDefinition)o;
        return Objects.equals(this.getCanonicalName(), that.getCanonicalName()) && Objects.equals(this.getCodeSource(), that.getCodeSource()) && Objects.equals(this.getMethods(), that.getMethods()) && Objects.equals(this.getTypes(), that.getTypes());
    }

    public int hashCode() {
        return Objects.hash(this.getCanonicalName(), this.getCodeSource(), this.getMethods(), this.getTypes());
    }
}

