/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.autoconfigure;

import javax.servlet.Filter;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.http2.Http2Protocol;
import org.apache.dubbo.rpc.protocol.tri.ServletExchanger;
import org.apache.dubbo.rpc.protocol.tri.servlet.TripleFilter;
import org.apache.dubbo.spring.boot.autoconfigure.SpringBoot12Condition;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.embedded.tomcat.ConfigurableTomcatWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@Conditional(value={SpringBoot12Condition.class})
public class DubboTripleAutoConfiguration {
    public static final String PREFIX = "dubbo.protocol.triple.servlet";

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Filter.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnProperty(prefix="dubbo.protocol.triple.servlet", name={"enabled"}, havingValue="true")
    public static class TripleServletConfiguration {
        @Bean
        public FilterRegistrationBean<TripleFilter> tripleProtocolFilter(@Value(value="${dubbo.protocol.triple.servlet.filter-url-patterns:/*}") String[] urlPatterns, @Value(value="${dubbo.protocol.triple.servlet.filter-order:-1000000}") int order, @Value(value="${server.port:8080}") int serverPort) {
            ServletExchanger.bindServerPort((int)serverPort);
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)new TripleFilter());
            registrationBean.addUrlPatterns(urlPatterns);
            registrationBean.setOrder(order);
            return registrationBean;
        }

        @Bean
        @ConditionalOnClass(value={Http2Protocol.class})
        @ConditionalOnProperty(prefix="dubbo.protocol.triple.servlet", name={"max-concurrent-streams"})
        public WebServerFactoryCustomizer<ConfigurableTomcatWebServerFactory> tripleTomcatHttp2Customizer(@Value(value="${dubbo.protocol.triple.servlet.max-concurrent-streams}") int maxConcurrentStreams) {
            return factory -> factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> {
                ProtocolHandler handler = connector.getProtocolHandler();
                for (UpgradeProtocol upgradeProtocol : handler.findUpgradeProtocols()) {
                    if (!(upgradeProtocol instanceof Http2Protocol)) continue;
                    Http2Protocol protocol = (Http2Protocol)upgradeProtocol;
                    int value = maxConcurrentStreams <= 0 ? Integer.MAX_VALUE : maxConcurrentStreams;
                    protocol.setMaxConcurrentStreams((long)value);
                    protocol.setMaxConcurrentStreamExecution(value);
                }
            }});
        }
    }
}

