/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.payload.response;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum PipeSubscribeResponseType {
    ACK(0),
    POLL_TABLETS(1);

    private final short type;
    private static final Map<Short, PipeSubscribeResponseType> TYPE_MAP;

    private PipeSubscribeResponseType(short type) {
        this.type = type;
    }

    public short getType() {
        return this.type;
    }

    public static boolean isValidatedRequestType(short type) {
        return TYPE_MAP.containsKey(type);
    }

    public static PipeSubscribeResponseType valueOf(short type) {
        return TYPE_MAP.get(type);
    }

    static {
        TYPE_MAP = Arrays.stream(PipeSubscribeResponseType.values()).collect(HashMap::new, (typeMap, pipeRequestType) -> typeMap.put(pipeRequestType.getType(), pipeRequestType), HashMap::putAll);
    }
}

