/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.mutable;

import java.util.Arrays;
import java.util.List;
import org.apache.kafka.server.mutable.BoundedList;
import org.apache.kafka.server.mutable.BoundedListTooLongException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class BoundedListTest {
    @Test
    public void testMaxLengthMustNotBeZero() {
        Assertions.assertEquals((Object)"Invalid non-positive maxLength of 0", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> BoundedList.newArrayBacked((int)0))).getMessage());
        Assertions.assertEquals((Object)"Invalid non-positive maxLength of 0", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> BoundedList.newArrayBacked((int)0, (int)100))).getMessage());
    }

    @Test
    public void testMaxLengthMustNotBeNegative() {
        Assertions.assertEquals((Object)"Invalid non-positive maxLength of -123", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> BoundedList.newArrayBacked((int)-123))).getMessage());
        Assertions.assertEquals((Object)"Invalid non-positive maxLength of -123", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> BoundedList.newArrayBacked((int)-123, (int)100))).getMessage());
    }

    @Test
    public void testInitialCapacityMustNotBeZero() {
        Assertions.assertEquals((Object)"Invalid non-positive initialCapacity of 0", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> BoundedList.newArrayBacked((int)100, (int)0))).getMessage());
    }

    @Test
    public void testInitialCapacityMustNotBeNegative() {
        Assertions.assertEquals((Object)"Invalid non-positive initialCapacity of -123", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> BoundedList.newArrayBacked((int)100, (int)-123))).getMessage());
    }

    @Test
    public void testAddingToBoundedList() {
        BoundedList list = BoundedList.newArrayBacked((int)2);
        Assertions.assertEquals((int)0, (int)list.size());
        Assertions.assertTrue((boolean)list.isEmpty());
        Assertions.assertTrue((boolean)list.add((Object)456));
        Assertions.assertTrue((boolean)list.contains((Object)456));
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertFalse((boolean)list.isEmpty());
        Assertions.assertTrue((boolean)list.add((Object)789));
        Assertions.assertEquals((Object)"Cannot add another element to the list because it would exceed the maximum length of 2", (Object)((BoundedListTooLongException)Assertions.assertThrows(BoundedListTooLongException.class, () -> list.add((Object)912))).getMessage());
        Assertions.assertEquals((Object)"Cannot add another element to the list because it would exceed the maximum length of 2", (Object)((BoundedListTooLongException)Assertions.assertThrows(BoundedListTooLongException.class, () -> list.add(0, (Object)912))).getMessage());
    }

    @Test
    public void testHashCodeAndEqualsForNonEmptyList() {
        BoundedList boundedList = BoundedList.newArrayBacked((int)7);
        List<Integer> otherList = Arrays.asList(1, 2, 3, 4, 5, 6, 7);
        boundedList.addAll(otherList);
        Assertions.assertEquals(otherList, (Object)boundedList);
        Assertions.assertEquals((int)otherList.hashCode(), (int)boundedList.hashCode());
    }

    @Test
    public void testSet() {
        BoundedList list = BoundedList.newArrayBacked((int)3);
        list.add((Object)1);
        list.add((Object)200);
        list.add((Object)3);
        Assertions.assertEquals(Arrays.asList(1, 200, 3), (Object)list);
        list.set(0, (Object)100);
        list.set(1, (Object)200);
        list.set(2, (Object)300);
        Assertions.assertEquals(Arrays.asList(100, 200, 300), (Object)list);
    }

    @Test
    public void testRemove() {
        BoundedList list = BoundedList.newArrayBacked((int)3);
        list.add((Object)"a");
        list.add((Object)"a");
        list.add((Object)"c");
        Assertions.assertEquals((int)0, (int)list.indexOf((Object)"a"));
        Assertions.assertEquals((int)1, (int)list.lastIndexOf((Object)"a"));
        list.remove((Object)"a");
        Assertions.assertEquals(Arrays.asList("a", "c"), (Object)list);
        list.remove(0);
        Assertions.assertEquals(Arrays.asList("c"), (Object)list);
    }

    @Test
    public void testClear() {
        BoundedList list = BoundedList.newArrayBacked((int)3);
        list.add((Object)"a");
        list.add((Object)"a");
        list.add((Object)"c");
        list.clear();
        Assertions.assertEquals(Arrays.asList(new Object[0]), (Object)list);
        Assertions.assertTrue((boolean)list.isEmpty());
    }

    @Test
    public void testGet() {
        BoundedList list = BoundedList.newArrayBacked((int)3);
        list.add((Object)1);
        list.add((Object)2);
        list.add((Object)3);
        Assertions.assertEquals((int)1, (Integer)((Integer)list.get(0)));
        Assertions.assertEquals((int)2, (Integer)((Integer)list.get(1)));
        Assertions.assertEquals((int)3, (Integer)((Integer)list.get(2)));
    }

    @Test
    public void testToArray() {
        BoundedList list = BoundedList.newArrayBacked((int)3);
        list.add((Object)1);
        list.add((Object)2);
        list.add((Object)3);
        Assertions.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])list.toArray());
        Assertions.assertArrayEquals((Object[])new Integer[]{1, 2, 3}, (Object[])list.toArray((Object[])new Integer[3]));
    }

    @Test
    public void testAddAll() {
        BoundedList list = BoundedList.newArrayBacked((int)5);
        list.add((Object)"a");
        list.add((Object)"b");
        list.add((Object)"c");
        Assertions.assertEquals((Object)"Cannot add another 3 element(s) to the list because it would exceed the maximum length of 5", (Object)((BoundedListTooLongException)Assertions.assertThrows(BoundedListTooLongException.class, () -> list.addAll(Arrays.asList("d", "e", "f")))).getMessage());
        Assertions.assertEquals((Object)"Cannot add another 3 element(s) to the list because it would exceed the maximum length of 5", (Object)((BoundedListTooLongException)Assertions.assertThrows(BoundedListTooLongException.class, () -> list.addAll(0, Arrays.asList("d", "e", "f")))).getMessage());
        list.addAll(Arrays.asList("d", "e"));
        Assertions.assertEquals(Arrays.asList("a", "b", "c", "d", "e"), (Object)list);
    }

    @Test
    public void testIterator() {
        BoundedList list = BoundedList.newArrayBacked((int)3);
        list.add((Object)1);
        list.add((Object)2);
        list.add((Object)3);
        Assertions.assertEquals((int)1, (Integer)((Integer)list.iterator().next()));
        Assertions.assertEquals((int)1, (Integer)((Integer)list.listIterator().next()));
        Assertions.assertEquals((int)3, (Integer)((Integer)list.listIterator(2).next()));
        Assertions.assertFalse((boolean)list.listIterator(3).hasNext());
    }

    @Test
    public void testIteratorIsImmutable() {
        BoundedList list = BoundedList.newArrayBacked((int)3);
        list.add((Object)1);
        list.add((Object)2);
        list.add((Object)3);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> list.iterator().remove());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> list.listIterator().remove());
    }

    @Test
    public void testSubList() {
        BoundedList list = BoundedList.newArrayBacked((int)3);
        list.add((Object)1);
        list.add((Object)2);
        list.add((Object)3);
        Assertions.assertEquals(Arrays.asList(2), (Object)list.subList(1, 2));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            Integer cfr_ignored_0 = (Integer)list.subList(1, 2).remove(2);
        });
    }
}

