/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.internals.StoreFactory;
import org.apache.kafka.streams.state.DslStoreSuppliers;

public abstract class AbstractConfigurableStoreFactory
implements StoreFactory {
    private final Set<String> connectedProcessorNames = new HashSet<String>();
    private DslStoreSuppliers dslStoreSuppliers;

    public AbstractConfigurableStoreFactory(DslStoreSuppliers initialStoreSuppliers) {
        this.dslStoreSuppliers = initialStoreSuppliers;
    }

    @Override
    public void configure(StreamsConfig config) {
        if (this.dslStoreSuppliers == null) {
            this.dslStoreSuppliers = (DslStoreSuppliers)Utils.newInstance((Class)config.getClass("dsl.store.suppliers.class"), DslStoreSuppliers.class);
        }
    }

    @Override
    public Set<String> connectedProcessorNames() {
        return this.connectedProcessorNames;
    }

    protected DslStoreSuppliers dslStoreSuppliers() {
        if (this.dslStoreSuppliers == null) {
            throw new IllegalStateException("Expected configure() to be called before using dslStoreSuppliers");
        }
        return this.dslStoreSuppliers;
    }
}

