/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import kafka.admin.BrokerApiVersionsCommand$;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005y3A\u0001B\u0003\u0001\u0015!)\u0011\u0003\u0001C\u0001%!)Q\u0003\u0001C\u0001-!)Q\u0005\u0001C\u0001M\ta\"I]8lKJ\f\u0005/\u001b,feNLwN\\:D_6l\u0017M\u001c3UKN$(B\u0001\u0004\b\u0003\u0015\tG-\\5o\u0015\u0005A\u0011!B6bM.\f7\u0001A\n\u0003\u0001-\u0001\"\u0001D\b\u000e\u00035Q!AD\u0004\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003!5\u0011acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"\u0001\u0006\u0001\u000e\u0003\u0015\tqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002/A\u0019\u0001$H\u0010\u000e\u0003eQ!AG\u000e\u0002\u0015\r|G\u000e\\3di&|gNC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq\u0012DA\u0002TKF\u0004\"\u0001I\u0012\u000e\u0003\u0005R!AI\u0004\u0002\rM,'O^3s\u0013\t!\u0013EA\u0006LC\u001a\\\u0017mQ8oM&<\u0017AI2iK\u000e\\'I]8lKJ\f\u0005/\u001b,feNLwN\\\"p[6\fg\u000eZ(viB,H\u000f\u0006\u0002(WA\u0011\u0001&K\u0007\u00027%\u0011!f\u0007\u0002\u0005+:LG\u000fC\u0003-\u0007\u0001\u0007Q&\u0001\u0004rk>\u0014X/\u001c\t\u0003]Ur!aL\u001a\u0011\u0005AZR\"A\u0019\u000b\u0005IJ\u0011A\u0002\u001fs_>$h(\u0003\u000257\u00051\u0001K]3eK\u001aL!AN\u001c\u0003\rM#(/\u001b8h\u0015\t!4\u0004\u000b\u0003\u0004s\u001dC\u0005C\u0001\u001eF\u001b\u0005Y$B\u0001\u001f>\u0003!\u0001(o\u001c<jI\u0016\u0014(B\u0001 @\u0003\u0019\u0001\u0018M]1ng*\u0011\u0001)Q\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u00115)A\u0003kk:LGOC\u0001E\u0003\ry'oZ\u0005\u0003\rn\u00121BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cHFA%LC\u0005Q\u0015A\u0001>lC\u0005a\u0015!B6sC\u001a$\b\u0006B\u0002O%N\u0003\"a\u0014)\u000e\u0003uJ!!U\u001f\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017%\u0001+\u00021m$\u0017n\u001d9mCft\u0015-\\3~]E,xN];n{m\u0004T\u0010\u000b\u0003\u0004-rk\u0006CA,[\u001b\u0005A&BA-@\u0003\r\t\u0007/[\u0005\u00037b\u0013q\u0001V5nK>,H/A\u0003wC2,XMH\u0001y\u0001")
public class BrokerApiVersionsCommandTest
extends KafkaServerTestHarness {
    @Override
    public Seq<KafkaConfig> generateConfigs() {
        if (this.isKRaftTest()) {
            return (Seq)((IterableOps)TestUtils$.MODULE$.createBrokerConfigs(1, null, true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)props -> {
                props.setProperty(KafkaConfig$.MODULE$.UnstableApiVersionsEnableProp(), "true");
                return props;
            })).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
        }
        return (Seq)((IterableOps)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)props -> {
            props.setProperty(KafkaConfig$.MODULE$.ControlPlaneListenerNameProp(), "CONTROLLER");
            props.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            props.setProperty("listeners", "PLAINTEXT://localhost:0,CONTROLLER://localhost:0");
            props.setProperty(KafkaConfig$.MODULE$.AdvertisedListenersProp(), "PLAINTEXT://localhost:0,CONTROLLER://localhost:0");
            props.setProperty(KafkaConfig$.MODULE$.UnstableApiVersionsEnableProp(), "true");
            return props;
        })).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
    }

    @Timeout(value=120L)
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void checkBrokerApiVersionCommandOutput(String quorum) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream((OutputStream)byteArrayOutputStream, false, StandardCharsets.UTF_8.name());
        BrokerApiVersionsCommand$.MODULE$.execute(new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1())}, printStream);
        String content = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
        Iterator lineIter = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])content.split("\n")));
        Assertions.assertTrue((boolean)lineIter.hasNext());
        Assertions.assertEquals((Object)new StringBuilder(24).append(this.bootstrapServers(this.bootstrapServers$default$1())).append(" (id: 0 rack: null) -> (").toString(), (Object)lineIter.next());
        ApiMessageType.ListenerType listenerType = this.isKRaftTest() ? ApiMessageType.ListenerType.BROKER : ApiMessageType.ListenerType.ZK_BROKER;
        scala.collection.mutable.Set clientApis = CollectionConverters$.MODULE$.SetHasAsScala((Set)ApiKeys.clientApis()).asScala();
        NodeApiVersions nodeApiVersions = new NodeApiVersions((Collection)CollectionConverters$.MODULE$.MutableSetHasAsJava((scala.collection.mutable.Set)clientApis.map((Function1 & Serializable)x$1 -> ApiVersionsResponse.toApiVersion((ApiKeys)x$1))).asJava(), Collections.emptyList(), false);
        clientApis.foreach((Function1 & Serializable)apiKey -> {
            BrokerApiVersionsCommandTest.$anonfun$checkBrokerApiVersionCommandOutput$2(clientApis, listenerType, nodeApiVersions, lineIter, apiKey);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)lineIter.hasNext());
        Assertions.assertEquals((Object)")", (Object)lineIter.next());
        Assertions.assertFalse((boolean)lineIter.hasNext());
    }

    public static final /* synthetic */ void $anonfun$checkBrokerApiVersionCommandOutput$2(scala.collection.mutable.Set clientApis$1, ApiMessageType.ListenerType listenerType$1, NodeApiVersions nodeApiVersions$1, Iterator lineIter$1, ApiKeys apiKey) {
        String terminator;
        ApiKeys apiKeys = apiKey;
        Object object = clientApis$1.last();
        String string = !(apiKeys != null ? !apiKeys.equals(object) : object != null) ? "" : (terminator = ",");
        if (apiKey.inScope(listenerType$1)) {
            ApiVersionsResponseData.ApiVersion apiVersion = nodeApiVersions$1.apiVersion(apiKey);
            Assertions.assertNotNull((Object)apiVersion);
            String versionRangeStr = apiVersion.minVersion() == apiVersion.maxVersion() ? Short.toString(apiVersion.minVersion()) : new StringBuilder(4).append(apiVersion.minVersion()).append(" to ").append(apiVersion.maxVersion()).toString();
            short usableVersion = nodeApiVersions$1.latestUsableVersion(apiKey);
            String line = new StringBuilder(16).append("\t").append(apiKey.name).append("(").append(apiKey.id).append("): ").append(versionRangeStr).append(" [usable: ").append(usableVersion).append("]").append(terminator).toString();
            Assertions.assertTrue((boolean)lineIter$1.hasNext());
            Assertions.assertEquals((Object)line, (Object)lineIter$1.next());
            return;
        }
        String line = new StringBuilder(16).append("\t").append(apiKey.name).append("(").append(apiKey.id).append("): UNSUPPORTED").append(terminator).toString();
        Assertions.assertTrue((boolean)lineIter$1.hasNext());
        Assertions.assertEquals((Object)line, (Object)lineIter$1.next());
    }
}

