/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.AbstractConsumerTest;
import kafka.api.BaseConsumerTest$;
import kafka.server.KafkaServer;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005=b!\u0002\u000b\u0016\u0003\u0003Q\u0002\"B\u0010\u0001\t\u0003\u0001\u0003\"\u0002\u0012\u0001\t\u0003\u0019\u0003\"\u0002\u001c\u0001\t\u0003\u0019\u0003\"\u0002\u001d\u0001\t\u0003\u0019s!\u0002\u001e\u0016\u0011\u0003Yd!\u0002\u000b\u0016\u0011\u0003a\u0004\"B\u0010\u0007\t\u0003\u0001\u0005bB!\u0007\u0005\u0004%\tA\u0011\u0005\u0007\u001f\u001a\u0001\u000b\u0011B\"\t\u000fA3!\u0019!C\u0001\u0005\"1\u0011K\u0002Q\u0001\n\r3AA\u0015\u0004\u0001'\")q\u0004\u0004C\u0001_\")!\u000f\u0004C!g\")\u0011\u0010\u0004C!u\u001a1\u0011Q\u0003\u0004\u0001\u0003/Aaa\b\t\u0005\u0002\u0005}\u0001B\u0002:\u0011\t\u0003\n\u0019\u0003C\u0004\u0002(A!\t%!\u000b\u0003!\t\u000b7/Z\"p]N,X.\u001a:UKN$(B\u0001\f\u0018\u0003\r\t\u0007/\u001b\u0006\u00021\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001c!\taR$D\u0001\u0016\u0013\tqRC\u0001\u000bBEN$(/Y2u\u0007>t7/^7feR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0002\"\u0001\b\u0001\u0002+Q,7\u000f^*j[BdWmQ8ogVl\u0007\u000f^5p]R\tA\u0005\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0003V]&$\bF\u0001\u0002,!\taC'D\u0001.\u0015\t1bF\u0003\u00020a\u00059!.\u001e9ji\u0016\u0014(BA\u00193\u0003\u0015QWO\\5u\u0015\u0005\u0019\u0014aA8sO&\u0011Q'\f\u0002\u0005)\u0016\u001cH/A\u000euKN$8\t\\;ti\u0016\u0014(+Z:pkJ\u001cW\rT5ti\u0016tWM\u001d\u0015\u0003\u0007-\nq\u0003^3ti\u000e{wN\u001d3j]\u0006$xN\u001d$bS2|g/\u001a:)\u0005\u0011Y\u0013\u0001\u0005\"bg\u0016\u001cuN\\:v[\u0016\u0014H+Z:u!\taba\u0005\u0002\u0007{A\u0011QEP\u0005\u0003\u007f\u0019\u0012a!\u00118z%\u00164G#A\u001e\u0002'U\u0004H-\u0019;f!J|G-^2fe\u000e{WO\u001c;\u0016\u0003\r\u0003\"\u0001R'\u000e\u0003\u0015S!AR$\u0002\r\u0005$x.\\5d\u0015\tA\u0015*\u0001\u0006d_:\u001cWO\u001d:f]RT!AS&\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0019\u0006!!.\u0019<b\u0013\tqUIA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\u0015kB$\u0017\r^3Qe>$WoY3s\u0007>,h\u000e\u001e\u0011\u0002'U\u0004H-\u0019;f\u0007>t7/^7fe\u000e{WO\u001c;\u0002)U\u0004H-\u0019;f\u0007>t7/^7fe\u000e{WO\u001c;!\u0005\u0015\"Vm\u001d;DYV\u001cH/\u001a:SKN|WO]2f\u0019&\u001cH/\u001a8feN+'/[1mSj,'o\u0005\u0003\r)j[\u0007CA+Y\u001b\u00051&BA,L\u0003\u0011a\u0017M\\4\n\u0005e3&AB(cU\u0016\u001cG\u000fE\u0002\\G\u0016l\u0011\u0001\u0018\u0006\u0003;z\u000bQb]3sS\u0006d\u0017N_1uS>t'BA0a\u0003\u0019\u0019w.\\7p]*\u0011\u0001$\u0019\u0006\u0003EJ\na!\u00199bG\",\u0017B\u00013]\u0005)\u0019VM]5bY&TXM\u001d\t\u0004K\u0019D\u0017BA4'\u0005\u0015\t%O]1z!\t)\u0013.\u0003\u0002kM\t!!)\u001f;f!\taW.D\u0001_\u0013\tqgLA\fDYV\u001cH/\u001a:SKN|WO]2f\u0019&\u001cH/\u001a8feR\t\u0001\u000f\u0005\u0002r\u00195\ta!\u0001\u0005p]V\u0003H-\u0019;f)\t!C\u000fC\u0003v\u001d\u0001\u0007a/A\bdYV\u001cH/\u001a:SKN|WO]2f!\taw/\u0003\u0002y=\ny1\t\\;ti\u0016\u0014(+Z:pkJ\u001cW-A\u0005tKJL\u0017\r\\5{KR!Qm_A\t\u0011\u0015ax\u00021\u0001~\u0003\u0015!x\u000e]5d!\rq\u00181\u0002\b\u0004\u007f\u0006\u001d\u0001cAA\u0001M5\u0011\u00111\u0001\u0006\u0004\u0003\u000bI\u0012A\u0002\u001fs_>$h(C\u0002\u0002\n\u0019\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0007\u0003\u001f\u0011aa\u0015;sS:<'bAA\u0005M!1\u00111C\bA\u0002\u0015\fA\u0001Z1uC\n9C+Z:u\u00072,8\u000f^3s%\u0016\u001cx.\u001e:dK2K7\u000f^3oKJ$Um]3sS\u0006d\u0017N_3s'\u0015\u0001B+!\u0007l!\u0011Y\u00161D3\n\u0007\u0005uAL\u0001\u0007EKN,'/[1mSj,'\u000f\u0006\u0002\u0002\"A\u0011\u0011\u000f\u0005\u000b\u0004I\u0005\u0015\u0002\"B;\u0013\u0001\u00041\u0018a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016$R!ZA\u0016\u0003[AQ\u0001`\nA\u0002uDa!a\u0005\u0014\u0001\u0004)\u0007")
public abstract class BaseConsumerTest
extends AbstractConsumerTest {
    public static AtomicInteger updateConsumerCount() {
        return BaseConsumerTest$.MODULE$.updateConsumerCount();
    }

    public static AtomicInteger updateProducerCount() {
        return BaseConsumerTest$.MODULE$.updateProducerCount();
    }

    @Test
    public void testSimpleConsumption() {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((int)1, (int)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$5, startingTimestamp, x$6, x$7, x$8);
        this.sendAndAwaitAsyncCommit(consumer, this.sendAndAwaitAsyncCommit$default$2());
    }

    @Test
    public void testClusterResourceListener() {
        int numRecords = 100;
        Properties producerProps = new Properties();
        producerProps.put("key.serializer", TestClusterResourceListenerSerializer.class);
        producerProps.put("value.serializer", TestClusterResourceListenerSerializer.class);
        KafkaProducer producer = this.createProducer(null, null, producerProps);
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        Properties consumerProps = new Properties();
        consumerProps.put("key.deserializer", TestClusterResourceListenerDeserializer.class);
        consumerProps.put("value.deserializer", TestClusterResourceListenerDeserializer.class);
        Consumer consumer = this.createConsumer(null, null, consumerProps, this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp().topic(), (List)Nil$.MODULE$)).asJava());
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$5, startingTimestamp, x$6, x$7, x$8);
        Assertions.assertNotEquals((int)0, (int)BaseConsumerTest$.MODULE$.updateProducerCount().get());
        Assertions.assertNotEquals((int)0, (int)BaseConsumerTest$.MODULE$.updateConsumerCount().get());
    }

    @Test
    public void testCoordinatorFailover() {
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener();
        this.consumerConfig().setProperty("session.timeout.ms", "5001");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("max.poll.interval.ms", "15000");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned());
        Buffer parts = null;
        while (parts == null) {
            parts = CollectionConverters$.MODULE$.ListHasAsScala(consumer.partitionsFor("__consumer_offsets")).asScala();
        }
        Assertions.assertEquals((int)1, (int)parts.size());
        Assertions.assertNotNull((Object)((PartitionInfo)parts.head()).leader());
        int coordinator = ((PartitionInfo)parts.head()).leader().id();
        ((KafkaServer)this.servers().apply(coordinator)).shutdown();
        this.ensureNoRebalance(consumer, listener);
    }

    public static class TestClusterResourceListenerDeserializer
    implements Deserializer<byte[]>,
    ClusterResourceListener {
        public void configure(Map<String, ?> x$1, boolean x$2) {
            super.configure(x$1, x$2);
        }

        public Object deserialize(String x$1, Headers x$2, byte[] x$3) {
            return super.deserialize(x$1, x$2, x$3);
        }

        public Object deserialize(String x$1, Headers x$2, ByteBuffer x$3) {
            return super.deserialize(x$1, x$2, x$3);
        }

        public void close() {
            super.close();
        }

        public void onUpdate(ClusterResource clusterResource) {
            BaseConsumerTest$.MODULE$.updateConsumerCount().incrementAndGet();
        }

        public byte[] deserialize(String topic, byte[] data) {
            return data;
        }
    }

    public static class TestClusterResourceListenerSerializer
    implements Serializer<byte[]>,
    ClusterResourceListener {
        public void configure(Map<String, ?> x$1, boolean x$2) {
            super.configure(x$1, x$2);
        }

        public byte[] serialize(String x$1, Headers x$2, Object x$3) {
            return super.serialize(x$1, x$2, x$3);
        }

        public void close() {
            super.close();
        }

        public void onUpdate(ClusterResource clusterResource) {
            BaseConsumerTest$.MODULE$.updateProducerCount().incrementAndGet();
        }

        public byte[] serialize(String topic, byte[] data) {
            return data;
        }
    }
}

