/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Broker;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerContext;
import kafka.controller.StateChangeLogger;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogManager$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zookeeper.ZooKeeperClientTimeoutException;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction0;

@Timeout(value=60L)
@ScalaSignature(bytes="\u0006\u0005\tub\u0001B\u0011#\u0001\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001C\u0002\u0013\u00051\u0007\u0003\u0004=\u0001\u0001\u0006I\u0001\u000e\u0005\b{\u0001\u0011\r\u0011\"\u00014\u0011\u0019q\u0004\u0001)A\u0005i!9q\b\u0001b\u0001\n\u0003\u0001\u0005BB&\u0001A\u0003%\u0011\tC\u0004M\u0001\t\u0007I\u0011\u0001!\t\r5\u0003\u0001\u0015!\u0003B\u0011\u001dq\u0005A1A\u0005\u0002=CaA\u0016\u0001!\u0002\u0013\u0001\u0006bB,\u0001\u0001\u0004%\t\u0001\u0017\u0005\bA\u0002\u0001\r\u0011\"\u0001b\u0011\u00199\u0007\u0001)Q\u00053\")\u0001\u000e\u0001C!S\")a\u000e\u0001C!_\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA(\u0001\u0011\u0005\u0011\u0011\u000b\u0005\b\u00037\u0002A\u0011AA/\u0011\u001d\t9\u0007\u0001C\u0001\u0003SBq!a\u001d\u0001\t\u0003\t)\bC\u0004\u0002\b\u0002!I!!#\t\u000f\u0005}\u0006\u0001\"\u0003\u0002B\"A\u0011q\u001d\u0001!\n\u0013\tI\u000fC\u0004\u0002|\u0002!\t!!@\t\u000f\u0005}\b\u0001\"\u0001\u0003\u0002!9!1\u0002\u0001\u0005\u0002\t5\u0001b\u0002B\f\u0001\u0011%!\u0011\u0004\u0005\b\u00057\u0001A\u0011\u0002B\u000f\u0011\u001d\u0011)\u0003\u0001C\u0005\u0003{DqAa\n\u0001\t\u0013\ti\u0010C\u0004\u0003*\u0001!IAa\u000b\u0003%M+'O^3s'\",H\u000fZ8x]R+7\u000f\u001e\u0006\u0003G\u0011\naa]3sm\u0016\u0014(\"A\u0013\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u000b\t\u0003S1j\u0011A\u000b\u0006\u0003W\u0011\n1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u0011QF\u000b\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012\u0001\r\t\u0003c\u0001i\u0011AI\u0001\u0005Q>\u001cH/F\u00015!\t)$(D\u00017\u0015\t9\u0004(\u0001\u0003mC:<'\"A\u001d\u0002\t)\fg/Y\u0005\u0003wY\u0012aa\u0015;sS:<\u0017!\u00025pgR\u0004\u0013!\u0002;pa&\u001c\u0017A\u0002;pa&\u001c\u0007%A\u0003tK:$\u0018'F\u0001B!\r\u0011\u0015\nN\u0007\u0002\u0007*\u0011A)R\u0001\nS6lW\u000f^1cY\u0016T!AR$\u0002\u0015\r|G\u000e\\3di&|gNC\u0001I\u0003\u0015\u00198-\u00197b\u0013\tQ5I\u0001\u0003MSN$\u0018AB:f]R\f\u0004%A\u0003tK:$('\u0001\u0004tK:$(\u0007I\u0001\u0019aJ|\u0007o\u001d+p\u0007\"\fgnZ3Va>t'+Z:uCJ$X#\u0001)\u0011\u0005E#V\"\u0001*\u000b\u0005MC\u0014\u0001B;uS2L!!\u0016*\u0003\u0015A\u0013x\u000e]3si&,7/A\rqe>\u00048\u000fV8DQ\u0006tw-Z+q_:\u0014Vm\u001d;beR\u0004\u0013a\u00039sS>\u00148i\u001c8gS\u001e,\u0012!\u0017\t\u00045nkV\"A$\n\u0005q;%AB(qi&|g\u000e\u0005\u00022=&\u0011qL\t\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\bqe&|'oQ8oM&<w\fJ3r)\t\u0011W\r\u0005\u0002[G&\u0011Am\u0012\u0002\u0005+:LG\u000fC\u0004g\u001b\u0005\u0005\t\u0019A-\u0002\u0007a$\u0013'\u0001\u0007qe&|'oQ8oM&<\u0007%A\bhK:,'/\u0019;f\u0007>tg-[4t+\u0005Q\u0007cA6m;6\tQ)\u0003\u0002n\u000b\n\u00191+Z9\u0002\u000bM,G/\u00169\u0015\u0005\t\u0004\b\"B9\u0011\u0001\u0004\u0011\u0018\u0001\u0003;fgRLeNZ8\u0011\u0005MdX\"\u0001;\u000b\u0005U4\u0018aA1qS*\u0011q\u000f_\u0001\bUV\u0004\u0018\u000e^3s\u0015\tI(0A\u0003kk:LGOC\u0001|\u0003\ry'oZ\u0005\u0003{R\u0014\u0001\u0002V3ti&sgm\u001c\u0015\u0003!}\u00042a]A\u0001\u0013\r\t\u0019\u0001\u001e\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017!\u0005;fgR\u001cE.Z1o'\",H\u000fZ8x]R\u0019!-!\u0003\t\u000f\u0005-\u0011\u00031\u0001\u0002\u000e\u00051\u0011/^8sk6\u0004B!a\u0004\u0002\u001e9!\u0011\u0011CA\r!\r\t\u0019bR\u0007\u0003\u0003+Q1!a\u0006'\u0003\u0019a$o\\8u}%\u0019\u00111D$\u0002\rA\u0013X\rZ3g\u0013\rY\u0014q\u0004\u0006\u0004\u000379\u0005fB\t\u0002$\u0005M\u0012Q\u0007\t\u0005\u0003K\ty#\u0004\u0002\u0002()!\u0011\u0011FA\u0016\u0003!\u0001(o\u001c<jI\u0016\u0014(bAA\u0017m\u00061\u0001/\u0019:b[NLA!!\r\u0002(\tYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONdC!a\u000e\u0002<\u0005\u0012\u0011\u0011H\u0001\u0003u.\f#!!\u0010\u0002\u000b-\u0014\u0018M\u001a;)\u000fE\t\t%!\u0013\u0002LA!\u00111IA#\u001b\t\tY#\u0003\u0003\u0002H\u0005-\"!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\t\ti%\u0001\r|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018rk>\u0014X/\\\u001f|au\f1\u0005^3ti\u000ecW-\u00198TQV$Hm\\<o\u0003\u001a$XM\u001d$bS2,Gm\u0015;beR,\b\u000fF\u0002c\u0003'Bq!a\u0003\u0013\u0001\u0004\ti\u0001K\u0004\u0013\u0003G\t\u0019$a\u0016-\t\u0005]\u00121\b\u0015\b%\u0005\u0005\u0013\u0011JA&\u0003U\"Xm\u001d;O_\u000ecW-\u00198TQV$Hm\\<o\u0003\u001a$XM\u001d$bS2,Gm\u0015;beR,\b\u000fR;f)>\u001cuN\u001d:vaRdunZ:\u0015\u0007\t\fy\u0006C\u0004\u0002\fM\u0001\r!!\u0004)\u000fM\t\u0019#a\r\u0002d1\"\u0011qGA\u001eQ\u001d\u0019\u0012\u0011IA%\u0003\u0017\n!\u0005^3ti\u000ecW-\u00198TQV$Hm\\<o/&$\bNW6V]\u00064\u0018-\u001b7bE2,Gc\u00012\u0002l!9\u00111\u0002\u000bA\u0002\u00055\u0001f\u0002\u000b\u0002$\u0005M\u0012q\u000e\u0017\u0003\u0003oAs\u0001FA!\u0003\u0013\nY%A\u0018uKN$8\t\\3b]NCW\u000f\u001e3po:<\u0016\u000e\u001e5L%\u00064GoQ8oiJ|G\u000e\\3s+:\fg/Y5mC\ndW\rF\u0002c\u0003oBq!a\u0003\u0016\u0001\u0004\ti\u0001K\u0004\u0016\u0003G\t\u0019$a\u001f-\u0005\u0005m\u0002fB\u000b\u0002B\u0005%\u00131\n\u0015\u0004+\u0005\u0005\u0005cA:\u0002\u0004&\u0019\u0011Q\u0011;\u0003\u0011\u0011K7/\u00192mK\u0012\fQE^3sS\u001aL8\t\\3b]NCW\u000f\u001e3po:\fe\r^3s\r\u0006LG.\u001a3Ti\u0006\u0014H/\u001e9\u0016\t\u0005-\u0015\u0011\u0015\u000b\u0004E\u00065\u0005bBAH-\u0001\u000f\u0011\u0011S\u0001\u0012Kb\u001cW\r\u001d;j_:\u001cE.Y:t)\u0006<\u0007CBAJ\u00033\u000bi*\u0004\u0002\u0002\u0016*\u0019\u0011qS$\u0002\u000fI,g\r\\3di&!\u00111TAK\u0005!\u0019E.Y:t)\u0006<\u0007\u0003BAP\u0003Cc\u0001\u0001B\u0004\u0002$Z\u0011\r!!*\u0003\u0003\u0015\u000bB!a*\u0002.B\u0019!,!+\n\u0007\u0005-vIA\u0004O_RD\u0017N\\4\u0011\t\u0005=\u0016\u0011\u0018\b\u0005\u0003c\u000b)L\u0004\u0003\u0002\u0014\u0005M\u0016\"\u0001%\n\u0007\u0005]v)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0016Q\u0018\u0002\n\u000bb\u001cW\r\u001d;j_:T1!a.H\u0003-\t7o]3si\u000e\u000bWo]3\u0015\u000b\t\f\u0019-!8\t\u000f\u0005\u0015w\u00031\u0001\u0002H\u0006iQ\r\u001f9fGR,Gm\u00117bgN\u0004D!!3\u0002RB1\u0011qBAf\u0003\u001fLA!!4\u0002 \t)1\t\\1tgB!\u0011qTAi\t1\t\u0019.a1\u0002\u0002\u0003\u0005)\u0011AAk\u0005\ryF%M\t\u0005\u0003O\u000b9\u000eE\u0002[\u00033L1!a7H\u0005\r\te.\u001f\u0005\b\u0003?<\u0002\u0019AAq\u0003\u0005)\u0007\u0003BAX\u0003GLA!!:\u0002>\nIA\u000b\u001b:po\u0006\u0014G.Z\u0001\u0017SNtuN\u001c#bK6|gnS1gW\u0006$\u0006N]3bIR!\u00111^Ay!\rQ\u0016Q^\u0005\u0004\u0003_<%a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003gD\u0002\u0019AA{\u0003\u0005!\bcA\u001b\u0002x&\u0019\u0011\u0011 \u001c\u0003\rQC'/Z1e\u0003q1XM]5gs:{g\u000eR1f[>tG\u000b\u001b:fC\u0012\u001c8\u000b^1ukN$\u0012AY\u0001\u0018i\u0016\u001cHoQ8og\u0016\u001cW\u000f^5wKNCW\u000f\u001e3po:$2A\u0019B\u0002\u0011\u001d\tYA\u0007a\u0001\u0003\u001bAsAGA\u0012\u0003g\u00119\u0001\f\u0003\u00028\u0005m\u0002f\u0002\u000e\u0002B\u0005%\u00131J\u0001!i\u0016\u001cHoQ8oiJ|G\u000e\\3s'\",H\u000fZ8x]\u0012+(/\u001b8h'\u0016tG\rF\u0002c\u0005\u001fAq!a\u0003\u001c\u0001\u0004\ti\u0001K\u0004\u001c\u0003G\t\u0019Da\u0005-\u0005\u0005]\u0002fB\u000e\u0002B\u0005%\u00131J\u0001\u0007G>tg-[4\u0016\u0003u\u000baA\u0019:pW\u0016\u0014XC\u0001B\u0010!\r\t$\u0011E\u0005\u0004\u0005G\u0011#aC&bM.\f'I]8lKJ\fab\u001d5vi\u0012|wO\u001c\"s_.,'/A\u0007sKN$\u0018M\u001d;Ce>\\WM]\u0001\u000fe\u0016\u001c'/Z1uK\n\u0013xn[3s)\r\u0011'Q\u0006\u0005\b\u0005_\u0001\u0003\u0019AAv\u0003\u001d\u0019H/\u0019:ukBDs\u0001\u0001B\u001a\u0005s\u0011Y\u0004E\u0002t\u0005kI1Aa\u000eu\u0005\u001d!\u0016.\\3pkR\fQA^1mk\u0016t\u0012\u0001\u0010")
public class ServerShutdownTest
extends KafkaServerTestHarness {
    private final String host;
    private final String topic;
    private final List<String> sent1 = new .colon.colon((Object)"hello", (List)new .colon.colon((Object)"there", (List)Nil$.MODULE$));
    private final List<String> sent2 = new .colon.colon((Object)"more", (List)new .colon.colon((Object)"messages", (List)Nil$.MODULE$));
    private final Properties propsToChangeUponRestart = new Properties();
    private Option<KafkaConfig> priorConfig = None$.MODULE$;

    public String host() {
        return this.host;
    }

    public String topic() {
        return this.topic;
    }

    public List<String> sent1() {
        return this.sent1;
    }

    public List<String> sent2() {
        return this.sent2;
    }

    public Properties propsToChangeUponRestart() {
        return this.propsToChangeUponRestart;
    }

    public Option<KafkaConfig> priorConfig() {
        return this.priorConfig;
    }

    public void priorConfig_$eq(Option<KafkaConfig> x$1) {
        this.priorConfig = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        this.priorConfig().foreach((Function1 & Serializable)config -> {
            java.util.Map originals = config.originals();
            Object logDirsValue = originals.get(KafkaConfig$.MODULE$.LogDirsProp());
            if (logDirsValue != null) {
                return this.propsToChangeUponRestart().put(KafkaConfig$.MODULE$.LogDirsProp(), logDirsValue);
            }
            return this.propsToChangeUponRestart().put(KafkaConfig$.MODULE$.LogDirProp(), originals.get(KafkaConfig$.MODULE$.LogDirProp()));
        });
        this.priorConfig_$eq((Option<KafkaConfig>)new Some((Object)KafkaConfig$.MODULE$.fromProps((Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head(), this.propsToChangeUponRestart(), true)));
        return new .colon.colon((Object)((KafkaConfig)this.priorConfig().get()), (List)Nil$.MODULE$);
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.priorConfig_$eq((Option<KafkaConfig>)None$.MODULE$);
        this.propsToChangeUponRestart().clear();
        super.setUp(testInfo);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCleanShutdown(String quorum) {
        ObjectRef producer = ObjectRef.create((Object)this.createProducer$1());
        this.createTopic(this.topic(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sent1().map((Function1 & Serializable)value -> ((KafkaProducer)producer$1.elem).send(new ProducerRecord(this.topic(), (Object)Predef$.MODULE$.int2Integer(0), value))).foreach((Function1 & Serializable)x$1 -> (RecordMetadata)x$1.get());
        this.killBroker(0);
        this.config().logDirs().foreach((Function1 & Serializable)logDir -> {
            ServerShutdownTest.$anonfun$testCleanShutdown$3(logDir);
            return BoxedUnit.UNIT;
        });
        ((KafkaProducer)producer.elem).close();
        this.restartBroker();
        TestUtils$.MODULE$.waitForPartitionMetadata(new .colon.colon((Object)this.broker(), (List)Nil$.MODULE$), this.topic(), 0, 15000L);
        producer.elem = this.createProducer$1();
        Consumer consumer = this.createConsumer$1();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        Seq consumerRecords = TestUtils$.MODULE$.consumeRecords(consumer, this.sent1().size(), 15000L);
        Assertions.assertEquals(this.sent1(), (Object)consumerRecords.map((Function1 & Serializable)x$2 -> (String)x$2.value()));
        this.sent2().map((Function1 & Serializable)value -> ((KafkaProducer)producer$1.elem).send(new ProducerRecord(this.topic(), (Object)Predef$.MODULE$.int2Integer(0), value))).foreach((Function1 & Serializable)x$3 -> (RecordMetadata)x$3.get());
        Seq consumerRecords2 = TestUtils$.MODULE$.consumeRecords(consumer, this.sent2().size(), 15000L);
        Assertions.assertEquals(this.sent2(), (Object)consumerRecords2.map((Function1 & Serializable)x$4 -> (String)x$4.value()));
        consumer.close();
        ((KafkaProducer)producer.elem).close();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCleanShutdownAfterFailedStartup(String quorum) {
        if (this.isKRaftTest()) {
            this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.InitialBrokerRegistrationTimeoutMsProp(), "1000");
            this.killBroker(0);
            this.shutdownKRaftController();
            this.verifyCleanShutdownAfterFailedStartup(ClassTag$.MODULE$.apply(CancellationException.class));
            return;
        }
        this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.ZkConnectionTimeoutMsProp(), "50");
        this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.ZkConnectProp(), "some.invalid.hostname.foo.bar.local:65535");
        this.verifyCleanShutdownAfterFailedStartup(ClassTag$.MODULE$.apply(ZooKeeperClientTimeoutException.class));
    }

    /*
     * Unable to fully structure code
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testNoCleanShutdownAfterFailedStartupDueToCorruptLogs(String quorum) {
        this.createTopic(this.topic(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.killBroker(0);
        this.config().logDirs().foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$1$adapted(kafka.server.ServerShutdownTest java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)((ServerShutdownTest)this));
        expectedStatusCode = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        receivedStatusCode = VolatileObjectRef.create((Object)Option$.MODULE$.empty());
        hasHaltProcedureCalled = VolatileBooleanRef.create((boolean)false);
        setHaltProcedure_haltProcedure = (Function2 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$3$adapted(scala.runtime.VolatileBooleanRef scala.runtime.VolatileObjectRef java.lang.Object scala.Option ), (Ljava/lang/Object;Lscala/Option;)Lscala/runtime/Nothing$;)((VolatileBooleanRef)hasHaltProcedureCalled, (VolatileObjectRef)receivedStatusCode);
        Exit.setHaltProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        var6_5 = null;
        try {
            Assertions.assertDoesNotThrow((Executable)(Executable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$4(kafka.server.ServerShutdownTest ), ()V)((ServerShutdownTest)this));
            var9_6 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                if (!hasHaltProcedureCalled.elem) ** GOTO lbl-1000
                v0 = expectedStatusCode;
                var13_9 = (Option)receivedStatusCode.elem;
                if (!(v0 != null ? v0.equals(var13_9) == false : var13_9 != null)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                var13_9 = null;
                if (!v1) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)new StringBuilder(117).append("Expected to halt directly with the expected status code:").append(expectedStatusCode.get()).append(", ").append("but got hasHaltProcedureCalled: ").append(hasHaltProcedureCalled.elem).append(" and received status code: ").append(((Option)receivedStatusCode.elem).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).toString());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                    continue;
                }
                break;
            }
        }
        finally {
            Exit.resetHaltProcedure();
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testCleanShutdownWithZkUnavailable(String quorum) {
        this.shutdownZooKeeper();
        this.killBroker(0);
        CoreUtils$.MODULE$.delete(this.broker().config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testCleanShutdownWithKRaftControllerUnavailable(String quorum) {
        this.shutdownKRaftController();
        this.killBroker(0);
        CoreUtils$.MODULE$.delete(this.broker().config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    private <E extends Exception> void verifyCleanShutdownAfterFailedStartup(ClassTag<E> exceptionClassTag) {
        try {
            try {
                this.recreateBroker(true);
                Assertions.fail((String)"Expected KafkaServer setup to fail and throw exception");
            }
            catch (Exception e) {
                this.assertCause(exceptionClassTag.runtimeClass(), e);
                Assertions.assertEquals((Object)(this.isKRaftTest() ? BrokerState.SHUTTING_DOWN : BrokerState.NOT_RUNNING), (Object)((KafkaBroker)this.brokers().head()).brokerState());
            }
        }
        finally {
            this.killBroker(0);
        }
    }

    private void assertCause(Class<?> expectedClass, Throwable e) {
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (!expectedClass.isInstance(cause)) continue;
            return;
        }
        Assertions.fail((String)new StringBuilder(43).append("Failed to assert cause of ").append(e).append(", expected cause ").append(expectedClass).toString());
    }

    private boolean isNonDaemonKafkaThread(Thread t) {
        return !t.isDaemon() && t.isAlive() && t.getName().startsWith(this.getClass().getName());
    }

    public void verifyNonDaemonThreadsStatus() {
        Assertions.assertEquals((int)0, (int)ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(Thread.getAllStackTraces().keySet().toArray()), (Function1 & Serializable)x$6 -> (Thread)x$6, ClassTag$.MODULE$.apply(Thread.class))), (Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)this.isNonDaemonKafkaThread(t))));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testConsecutiveShutdown(String quorum) {
        this.killBroker(0);
        ((KafkaBroker)this.brokers().head()).shutdown();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testControllerShutdownDuringSend(String quorum) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        int controllerId = 2;
        Metrics metrics = new Metrics();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        ObjectRef serverSocket = ObjectRef.create(null);
        ObjectRef controllerChannelManager = ObjectRef.create(null);
        try {
            serverSocket.elem = new ServerSocket(0);
            Future<?> receiveFuture = executor.submit(new Runnable(null, serverSocket){
                private final ObjectRef serverSocket$1;

                public void run() {
                    Socket socket = ((ServerSocket)this.serverSocket$1.elem).accept();
                    new DataInputStream(socket.getInputStream()).readByte();
                }
                {
                    this.serverSocket$1 = serverSocket$1;
                }
            });
            scala.collection.immutable.Map brokerAndEpochs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Broker(1, "localhost", ((ServerSocket)serverSocket.elem).getLocalPort(), listenerName, securityProtocol), (Object)BoxesRunTime.boxToLong((long)0L))}));
            KafkaConfig controllerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(controllerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
            ControllerContext controllerContext = new ControllerContext();
            controllerContext.setLiveBrokers((Map)brokerAndEpochs);
            controllerChannelManager.elem = new ControllerChannelManager((Function0)(JFunction0.mcI.sp & Serializable)() -> controllerContext.epoch(), controllerConfig, Time.SYSTEM, metrics, new StateChangeLogger(controllerId, true, (Option)None$.MODULE$), (Option)None$.MODULE$);
            ((ControllerChannelManager)controllerChannelManager.elem).startup(controllerContext.liveOrShuttingDownBrokers());
            LeaderAndIsrRequest.Builder requestBuilder = new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, 1, 0L, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava(), Collections.singletonMap(this.topic(), Uuid.randomUuid()), (Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)((IterableOnceOps)brokerAndEpochs.keys().map((Function1 & Serializable)x$7 -> x$7.node(listenerName))).toSet()).asJava());
            ControllerChannelManager qual$1 = (ControllerChannelManager)controllerChannelManager.elem;
            Function1 x$3 = qual$1.sendRequest$default$3();
            qual$1.sendRequest(1, (AbstractControlRequest.Builder)requestBuilder, x$3);
            receiveFuture.get(10L, TimeUnit.SECONDS);
            executor.submit(new Runnable(null, controllerChannelManager){
                private final ObjectRef controllerChannelManager$1;

                public void run() {
                    ((ControllerChannelManager)this.controllerChannelManager$1.elem).shutdown();
                }
                {
                    this.controllerChannelManager$1 = controllerChannelManager$1;
                }
            }).get(10L, TimeUnit.SECONDS);
        }
        finally {
            if ((ServerSocket)serverSocket.elem != null) {
                ((ServerSocket)serverSocket.elem).close();
            }
            if ((ControllerChannelManager)controllerChannelManager.elem != null) {
                ((ControllerChannelManager)controllerChannelManager.elem).shutdown();
            }
            executor.shutdownNow();
            metrics.close();
        }
    }

    private KafkaConfig config() {
        return (KafkaConfig)this.configs().head();
    }

    private KafkaBroker broker() {
        return (KafkaBroker)this.brokers().head();
    }

    private void shutdownBroker() {
        this.killBroker(0);
    }

    private void restartBroker() {
        this.killBroker(0);
        this.restartDeadBrokers(!this.propsToChangeUponRestart().isEmpty());
    }

    private void recreateBroker(boolean startup) {
        this.recreateBrokers(!this.propsToChangeUponRestart().isEmpty(), startup);
    }

    private final KafkaProducer createProducer$1() {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        IntegerSerializer x$2 = new IntegerSerializer();
        StringSerializer x$3 = new StringSerializer();
        int x$4 = -1;
        long x$5 = 60000L;
        long x$6 = 0x100000L;
        int x$7 = Integer.MAX_VALUE;
        int x$8 = 30000;
        int x$9 = 0;
        int x$10 = 16384;
        String x$11 = "none";
        int x$12 = 20000;
        SecurityProtocol x$13 = SecurityProtocol.PLAINTEXT;
        None$ x$14 = None$.MODULE$;
        None$ x$15 = None$.MODULE$;
        boolean x$16 = false;
        return TestUtils$.MODULE$.createProducer(x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option<File>)x$14, (Option<Properties>)x$15, x$2, x$3, x$16);
    }

    private final Consumer createConsumer$1() {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        IntegerDeserializer x$3 = new IntegerDeserializer();
        StringDeserializer x$4 = new StringDeserializer();
        String x$5 = "group";
        String x$6 = "earliest";
        boolean x$7 = true;
        boolean x$8 = false;
        int x$9 = 500;
        None$ x$10 = None$.MODULE$;
        None$ x$11 = None$.MODULE$;
        return TestUtils$.MODULE$.createConsumer(x$1, x$5, x$6, x$7, x$8, x$9, SecurityProtocol.PLAINTEXT, (Option<File>)x$10, (Option<Properties>)x$11, x$3, x$4);
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdown$3(String logDir) {
        File OffsetCheckpointFile2 = new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile());
        Assertions.assertTrue((boolean)OffsetCheckpointFile2.exists());
        Assertions.assertTrue((OffsetCheckpointFile2.length() > 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$1(ServerShutdownTest $this, String dirName) {
        File partitionDir = new File(dirName, new StringBuilder(2).append($this.topic()).append("-0").toString());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])partitionDir.listFiles()), (Function1 & Serializable)f -> {
            TestUtils$.MODULE$.appendNonsenseToFile(f, TestUtils$.MODULE$.random().nextInt(1024) + 1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Nothing$ $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$3(VolatileBooleanRef hasHaltProcedureCalled$1, VolatileObjectRef receivedStatusCode$1, int statusCode, Option x$5) {
        hasHaltProcedureCalled$1.elem = true;
        receivedStatusCode$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)statusCode));
        return (Nothing$)BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$4(ServerShutdownTest $this) {
        $this.recreateBroker(true);
    }

    public static final /* synthetic */ boolean $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$5(VolatileBooleanRef hasHaltProcedureCalled$1, Some expectedStatusCode$1, VolatileObjectRef receivedStatusCode$1) {
        if (hasHaltProcedureCalled$1.elem) {
            Some some = expectedStatusCode$1;
            Option option = (Option)receivedStatusCode$1.elem;
            if (!(some != null ? !some.equals(option) : option != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$6(Some expectedStatusCode$1, VolatileBooleanRef hasHaltProcedureCalled$1, VolatileObjectRef receivedStatusCode$1) {
        return new StringBuilder(117).append("Expected to halt directly with the expected status code:").append(expectedStatusCode$1.get()).append(", ").append("but got hasHaltProcedureCalled: ").append(hasHaltProcedureCalled$1.elem).append(" and received status code: ").append(((Option)receivedStatusCode$1.elem).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).toString();
    }

    public ServerShutdownTest() {
        this.host = "localhost";
        this.topic = "test";
    }

    public static final /* synthetic */ Object $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$1$adapted(ServerShutdownTest $this, String dirName) {
        ServerShutdownTest.$anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$1($this, dirName);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Nothing$ $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$3$adapted(VolatileBooleanRef hasHaltProcedureCalled$1, VolatileObjectRef receivedStatusCode$1, Object statusCode, Option x$5) {
        return ServerShutdownTest.$anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$3(hasHaltProcedureCalled$1, receivedStatusCode$1, BoxesRunTime.unboxToInt((Object)statusCode), x$5);
    }
}

