/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.toolchain.jdk;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.toolchain.model.PersistedToolchains;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.apache.maven.toolchain.model.io.xpp3.MavenToolchainsXpp3Reader;
import org.apache.maven.toolchain.model.io.xpp3.MavenToolchainsXpp3Writer;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class ToolchainDiscoverer {
    public static final String JAVA = "java.";
    public static final String VERSION = "version";
    public static final String RUNTIME_NAME = "runtime.name";
    public static final String RUNTIME_VERSION = "runtime.version";
    public static final String VENDOR = "vendor";
    public static final String VENDOR_VERSION = "vendor.version";
    public static final String[] PROPERTIES = new String[]{"version", "runtime.name", "runtime.version", "vendor", "vendor.version"};
    public static final String CURRENT = "current";
    public static final String ENV = "env";
    public static final String LTS = "lts";
    public static final List<String> SORTED_PROVIDES = Collections.unmodifiableList(Arrays.asList("version", "runtime.name", "runtime.version", "vendor", "vendor.version", "current", "lts", "env"));
    public static final String DISCOVERED_TOOLCHAINS_CACHE_XML = ".m2/discovered-jdk-toolchains-cache.xml";
    public static final String JDK_HOME = "jdkHome";
    public static final String JAVA_HOME = "java.home";
    private static final String COMMA = ",";
    public static final String USER_HOME = "user.home";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile Map<Path, ToolchainModel> cache;
    private volatile boolean cacheModified;
    private volatile Set<Path> foundJdks;

    public Optional<ToolchainModel> getCurrentJdkToolchain() {
        Path currentJdkHome = ToolchainDiscoverer.getCanonicalPath(Paths.get(System.getProperty(JAVA_HOME), new String[0]));
        if (!ToolchainDiscoverer.hasJavaC(currentJdkHome)) {
            return Optional.empty();
        }
        ToolchainModel model = new ToolchainModel();
        model.setType("jdk");
        Stream.of(PROPERTIES).forEach(k -> {
            String v = System.getProperty(JAVA + k);
            if (v != null) {
                model.addProvide(k, v);
            }
        });
        model.addProvide(CURRENT, "true");
        Xpp3Dom config = new Xpp3Dom("configuration");
        Xpp3Dom jdkHome = new Xpp3Dom(JDK_HOME);
        jdkHome.setValue(currentJdkHome.toString());
        config.addChild(jdkHome);
        model.setConfiguration((Object)config);
        return Optional.of(model);
    }

    public PersistedToolchains discoverToolchains() {
        return this.discoverToolchains("lts,version,vendor");
    }

    public PersistedToolchains discoverToolchains(String comparator) {
        try {
            Set<Path> jdks = this.findJdks();
            this.log.info("Found " + jdks.size() + " possible jdks: " + jdks);
            this.readCache();
            HashMap<Path, Map> flags = new HashMap<Path, Map>();
            Path currentJdkHome = ToolchainDiscoverer.getCanonicalPath(Paths.get(System.getProperty(JAVA_HOME), new String[0]));
            flags.computeIfAbsent(currentJdkHome, p -> new HashMap()).put(CURRENT, "true");
            System.getenv().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("JAVA") && ((String)e.getKey()).endsWith("_HOME")).forEach(e -> {
                Path path = ToolchainDiscoverer.getCanonicalPath(Paths.get((String)e.getValue(), new String[0]));
                Map f = flags.computeIfAbsent(path, p -> new HashMap());
                String val = f.getOrDefault(ENV, "");
                f.put(ENV, (val.isEmpty() ? "" : val + COMMA) + (String)e.getKey());
            });
            List tcs = jdks.parallelStream().map(s -> {
                ToolchainModel tc = this.getToolchainModel((Path)s);
                flags.getOrDefault(s, Collections.emptyMap()).forEach((k, v) -> tc.getProvides().setProperty((String)k, (String)v));
                String version = tc.getProvides().getProperty(VERSION);
                if (ToolchainDiscoverer.isLts(version)) {
                    tc.getProvides().setProperty(LTS, "true");
                }
                return tc;
            }).sorted(this.getToolchainModelComparator(comparator)).collect(Collectors.toList());
            this.writeCache();
            PersistedToolchains ps = new PersistedToolchains();
            ps.setToolchains(tcs);
            return ps;
        }
        catch (Exception e2) {
            if (this.log.isDebugEnabled()) {
                this.log.warn("Error discovering toolchains: " + e2, (Throwable)e2);
            } else {
                this.log.warn("Error discovering toolchains (enable debug level for more information): " + e2);
            }
            return new PersistedToolchains();
        }
    }

    private static boolean isLts(String version) {
        return Stream.of("1.8", "8", "11", "17", "21", "25").anyMatch(v -> version.equals(v) || version.startsWith(v + "."));
    }

    private synchronized void readCache() {
        block15: {
            if (this.cache == null) {
                try {
                    this.cache = new ConcurrentHashMap<Path, ToolchainModel>();
                    this.cacheModified = false;
                    Path cacheFile = ToolchainDiscoverer.getCacheFile();
                    if (!Files.isRegularFile(cacheFile, new LinkOption[0])) break block15;
                    try (BufferedReader r = Files.newBufferedReader(cacheFile);){
                        PersistedToolchains pt = new MavenToolchainsXpp3Reader().read((Reader)r, false);
                        this.cache = pt.getToolchains().stream().filter(tc -> {
                            if (!ToolchainDiscoverer.hasJavaC(this.getJdkHome((ToolchainModel)tc))) {
                                this.cacheModified = true;
                                return false;
                            }
                            return true;
                        }).collect(Collectors.toConcurrentMap(this::getJdkHome, Function.identity()));
                    }
                }
                catch (IOException | XmlPullParserException e) {
                    this.log.debug("Error reading toolchains cache: " + e, e);
                }
            }
        }
    }

    private synchronized void writeCache() {
        if (this.cacheModified) {
            try {
                Path cacheFile = ToolchainDiscoverer.getCacheFile();
                Files.createDirectories(cacheFile.getParent(), new FileAttribute[0]);
                try (BufferedWriter w = Files.newBufferedWriter(cacheFile, new OpenOption[0]);){
                    PersistedToolchains pt = new PersistedToolchains();
                    pt.setToolchains(this.cache.values().stream().map(tc -> {
                        ToolchainModel model = tc.clone();
                        model.getProvides().remove(CURRENT);
                        model.getProvides().remove(ENV);
                        return model;
                    }).sorted(this.version().thenComparing(this.vendor())).collect(Collectors.toList()));
                    new MavenToolchainsXpp3Writer().write((Writer)w, pt);
                }
            }
            catch (IOException e) {
                this.log.debug("Error writing toolchains cache: " + e, (Throwable)e);
            }
            this.cacheModified = false;
        }
    }

    ToolchainModel getToolchainModel(Path jdk) {
        ToolchainModel model = this.cache.get(jdk);
        if (model == null) {
            model = this.doGetToolchainModel(jdk);
            this.cache.put(jdk, model);
            this.cacheModified = true;
        }
        return model;
    }

    private static Path getCacheFile() {
        return Paths.get(System.getProperty(USER_HOME), new String[0]).resolve(DISCOVERED_TOOLCHAINS_CACHE_XML);
    }

    public Path getJdkHome(ToolchainModel toolchain) {
        Xpp3Dom dom = (Xpp3Dom)toolchain.getConfiguration();
        Xpp3Dom javahome = dom != null ? dom.getChild(JDK_HOME) : null;
        String jdk = javahome != null ? javahome.getValue() : null;
        return Paths.get(Objects.requireNonNull(jdk), new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ToolchainModel doGetToolchainModel(Path jdk) {
        List<String> lines;
        Path java = jdk.resolve("bin").resolve("java");
        if (!Files.exists(java, new LinkOption[0]) && !Files.exists(java = jdk.resolve("bin").resolve("java.exe"), new LinkOption[0])) {
            this.log.debug("JDK toolchain discovered at " + jdk + " will be ignored: unable to find bin/java or bin\\java.exe");
            return null;
        }
        if (!java.toFile().canExecute()) {
            this.log.debug("JDK toolchain discovered at " + jdk + " will be ignored: the bin/java or bin\\java.exe is not executable");
            return null;
        }
        try {
            Path temp = Files.createTempFile("jdk-opts-", ".out", new FileAttribute[0]);
            try {
                new ProcessBuilder(new String[0]).command(java.toString(), "-XshowSettings:properties", "-version").redirectError(temp.toFile()).start().waitFor();
                lines = Files.readAllLines(temp);
            }
            finally {
                Files.delete(temp);
            }
        }
        catch (IOException | InterruptedException e) {
            this.log.debug("JDK toolchain discovered at " + jdk + " will be ignored: error executing java: " + e);
            return null;
        }
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        Stream.of(PROPERTIES).forEach(name -> lines.stream().filter(l -> l.contains(JAVA + name)).map(l -> l.replaceFirst(".*=\\s*(.*)", "$1")).findFirst().ifPresent(value -> properties.put((String)name, (String)value)));
        if (!properties.containsKey(VERSION)) {
            this.log.debug("JDK toolchain discovered at " + jdk + " will be ignored: could not obtain " + JAVA + VERSION);
            return null;
        }
        ToolchainModel model = new ToolchainModel();
        model.setType("jdk");
        properties.forEach((arg_0, arg_1) -> ((ToolchainModel)model).addProvide(arg_0, arg_1));
        Xpp3Dom configuration = new Xpp3Dom("configuration");
        Xpp3Dom jdkHome = new Xpp3Dom(JDK_HOME);
        jdkHome.setValue(jdk.toString());
        configuration.addChild(jdkHome);
        model.setConfiguration((Object)configuration);
        return model;
    }

    private static Path getCanonicalPath(Path path) {
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return ToolchainDiscoverer.getCanonicalPath(path.getParent()).resolve(path.getFileName());
        }
    }

    Comparator<ToolchainModel> getToolchainModelComparator(String comparator) {
        Comparator<ToolchainModel> c = null;
        for (String part : comparator.split(COMMA)) {
            c = c == null ? this.getComparator(part) : c.thenComparing(this.getComparator(part));
        }
        return c;
    }

    private Comparator<ToolchainModel> getComparator(String part) {
        switch (part.trim().toLowerCase(Locale.ROOT)) {
            case "lts": {
                return this.lts();
            }
            case "vendor": {
                return this.vendor();
            }
            case "env": {
                return this.env();
            }
            case "current": {
                return this.current();
            }
            case "version": {
                return this.version();
            }
        }
        throw new IllegalArgumentException("Unsupported comparator: " + part + ". Supported comparators are: vendor, env, current, lts and version.");
    }

    Comparator<ToolchainModel> lts() {
        return Comparator.comparing(tc -> tc.getProvides().containsKey(LTS) ? -1 : 1);
    }

    Comparator<ToolchainModel> vendor() {
        return Comparator.comparing(tc -> tc.getProvides().getProperty(VENDOR));
    }

    Comparator<ToolchainModel> env() {
        return Comparator.comparing(tc -> tc.getProvides().containsKey(ENV) ? -1 : 1);
    }

    Comparator<ToolchainModel> current() {
        return Comparator.comparing(tc -> tc.getProvides().containsKey(CURRENT) ? -1 : 1);
    }

    Comparator<ToolchainModel> version() {
        return Comparator.comparing(tc -> tc.getProvides().getProperty(VERSION), (v1, v2) -> {
            String[] a = v1.split("\\.");
            String[] b = v2.split("\\.");
            int length = Math.min(a.length, b.length);
            for (int i = 0; i < length; ++i) {
                String oa = a[i];
                String ob = b[i];
                if (Objects.equals(oa, ob)) continue;
                if (oa == null || ob == null) {
                    return oa == null ? -1 : 1;
                }
                int v = oa.compareTo(ob);
                if (v == 0) continue;
                return v;
            }
            return a.length - b.length;
        }).reversed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Path> findJdks() {
        if (this.foundJdks == null) {
            ToolchainDiscoverer toolchainDiscoverer = this;
            synchronized (toolchainDiscoverer) {
                if (this.foundJdks == null) {
                    this.foundJdks = this.doFindJdks();
                }
            }
        }
        return this.foundJdks;
    }

    private Set<Path> doFindJdks() {
        ArrayList<Path> dirsToTest = new ArrayList<Path>();
        dirsToTest.add(Paths.get(System.getProperty(JAVA_HOME), new String[0]));
        System.getenv().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("JAVA") && ((String)e.getKey()).endsWith("_HOME")).map(e -> Paths.get((String)e.getValue(), new String[0])).forEach(dirsToTest::add);
        Path userHome = Paths.get(System.getProperty(USER_HOME), new String[0]);
        ArrayList<Path> installedDirs = new ArrayList<Path>();
        installedDirs.add(userHome.resolve(".jdks"));
        installedDirs.add(userHome.resolve(".m2").resolve("jdks"));
        installedDirs.add(userHome.resolve(".sdkman").resolve("candidates").resolve("java"));
        installedDirs.add(userHome.resolve(".gradle").resolve("jdks"));
        installedDirs.add(userHome.resolve(".jenv").resolve("versions"));
        installedDirs.add(userHome.resolve(".jbang").resolve("cache").resolve("jdks"));
        installedDirs.add(userHome.resolve(".asdf").resolve("installs"));
        installedDirs.add(userHome.resolve(".jabba").resolve("jdk"));
        String osname = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        boolean macos = osname.startsWith("mac");
        boolean win = osname.startsWith("win");
        if (macos) {
            installedDirs.add(Paths.get("/Library/Java/JavaVirtualMachines", new String[0]));
            installedDirs.add(userHome.resolve("Library/Java/JavaVirtualMachines"));
        } else if (win) {
            installedDirs.add(Paths.get("C:\\Program Files\\Java\\", new String[0]));
            Path scoop = userHome.resolve("scoop").resolve("apps");
            if (Files.isDirectory(scoop, new LinkOption[0])) {
                try (Stream<Path> stream2 = Files.list(scoop);){
                    stream2.forEach(installedDirs::add);
                }
                catch (IOException stream2) {}
            }
        } else {
            installedDirs.add(Paths.get("/usr/jdk", new String[0]));
            installedDirs.add(Paths.get("/usr/java", new String[0]));
            installedDirs.add(Paths.get("/opt/java", new String[0]));
            installedDirs.add(Paths.get("/usr/lib/jvm", new String[0]));
        }
        for (Path dest : installedDirs) {
            if (!Files.isDirectory(dest, new LinkOption[0])) continue;
            try {
                Stream<Path> stream = Files.list(dest);
                Throwable throwable = null;
                try {
                    stream.forEach(dir -> {
                        dirsToTest.add((Path)dir);
                        if (macos) {
                            dirsToTest.add(dir.resolve("Contents").resolve("Home"));
                        }
                    });
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return dirsToTest.stream().filter(ToolchainDiscoverer::hasJavaC).map(ToolchainDiscoverer::getCanonicalPath).collect(Collectors.toSet());
    }

    private static boolean hasJavaC(Path subdir) {
        return Files.exists(subdir.resolve(Paths.get("bin", "javac")), new LinkOption[0]) || Files.exists(subdir.resolve(Paths.get("bin", "javac.exe")), new LinkOption[0]);
    }
}

