/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.accurev.command;

import java.io.File;
import java.util.List;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.accurev.AccuRevException;
import org.apache.maven.scm.provider.accurev.AccuRevScmProviderRepository;
import org.apache.maven.scm.provider.accurev.AccuRevVersion;
import org.apache.maven.scm.provider.accurev.command.AbstractAccuRevCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAccuRevExtractSourceCommand
extends AbstractAccuRevCommand {
    public AbstractAccuRevExtractSourceCommand(ScmLogger logger) {
        super(logger);
    }

    @Override
    protected ScmResult executeAccurevCommand(AccuRevScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException, AccuRevException {
        ScmVersion scmVersion = parameters.getScmVersion(CommandParameter.SCM_VERSION, null);
        AccuRevVersion accuRevVersion = repository.getAccuRevVersion(scmVersion);
        String basisStream = accuRevVersion.getBasisStream();
        String transactionId = accuRevVersion.getTimeSpec();
        File basedir = fileSet.getBasedir();
        String outputDirectory = parameters.getString(CommandParameter.OUTPUT_DIRECTORY, null);
        if (outputDirectory != null) {
            basedir = new File(outputDirectory);
        }
        if (!basedir.exists()) {
            basedir.mkdirs();
        }
        if (!basedir.isDirectory() || basedir.list().length != 0) {
            throw new ScmException("Checkout directory " + basedir.getAbsolutePath() + " not empty");
        }
        List<File> checkedOutFiles = this.extractSource(repository, basedir, basisStream, transactionId);
        List<ScmFile> scmFiles = checkedOutFiles == null ? null : AbstractAccuRevExtractSourceCommand.getScmFiles(checkedOutFiles, ScmFileStatus.CHECKED_OUT);
        return this.getScmResult(repository, scmFiles);
    }

    protected abstract ScmResult getScmResult(AccuRevScmProviderRepository var1, List<ScmFile> var2);

    protected abstract List<File> extractSource(AccuRevScmProviderRepository var1, File var2, String var3, String var4) throws AccuRevException;
}

