/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.accurev.cli;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.accurev.Stream;
import org.apache.maven.scm.provider.accurev.cli.XppStreamConsumer;

public class StreamsConsumer
extends XppStreamConsumer {
    private List<Stream> streams;

    public StreamsConsumer(ScmLogger logger, List<Stream> streams) {
        super(logger);
        this.streams = streams;
    }

    @Override
    protected void startTag(List<String> tagPath, Map<String, String> attributes) {
        String tagName = StreamsConsumer.getTagName(tagPath);
        if ("stream".equals(tagName)) {
            String name = attributes.get("name");
            long streamId = Long.parseLong(attributes.get("streamNumber"));
            String basis = attributes.get("basis");
            String basisStreamNumber = attributes.get("basisStreamNumber");
            long basisStreamId = basisStreamNumber == null ? 0L : Long.parseLong(basisStreamNumber);
            String depot = attributes.get("depotName");
            Date startTime = new Date(Long.parseLong(attributes.get("startTime")) * 1000L);
            String streamType = attributes.get("type");
            this.streams.add(new Stream(name, streamId, basis, basisStreamId, depot, startTime, streamType));
        }
    }
}

