/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.broker.BrokerPathConfigHelper;
import org.apache.rocketmq.broker.client.ClientHousekeepingService;
import org.apache.rocketmq.broker.client.ConsumerIdsChangeListener;
import org.apache.rocketmq.broker.client.ConsumerManager;
import org.apache.rocketmq.broker.client.DefaultConsumerIdsChangeListener;
import org.apache.rocketmq.broker.client.ProducerManager;
import org.apache.rocketmq.broker.client.net.Broker2Client;
import org.apache.rocketmq.broker.client.rebalance.RebalanceLockManager;
import org.apache.rocketmq.broker.filtersrv.FilterServerManager;
import org.apache.rocketmq.broker.latency.BrokerFastFailure;
import org.apache.rocketmq.broker.latency.BrokerFixedThreadPoolExecutor;
import org.apache.rocketmq.broker.longpolling.NotifyMessageArrivingListener;
import org.apache.rocketmq.broker.longpolling.PullRequestHoldService;
import org.apache.rocketmq.broker.mqtrace.ConsumeMessageHook;
import org.apache.rocketmq.broker.mqtrace.SendMessageHook;
import org.apache.rocketmq.broker.offset.ConsumerOffsetManager;
import org.apache.rocketmq.broker.out.BrokerOuterAPI;
import org.apache.rocketmq.broker.plugin.MessageStoreFactory;
import org.apache.rocketmq.broker.plugin.MessageStorePluginContext;
import org.apache.rocketmq.broker.processor.AdminBrokerProcessor;
import org.apache.rocketmq.broker.processor.ClientManageProcessor;
import org.apache.rocketmq.broker.processor.ConsumerManageProcessor;
import org.apache.rocketmq.broker.processor.EndTransactionProcessor;
import org.apache.rocketmq.broker.processor.PullMessageProcessor;
import org.apache.rocketmq.broker.processor.QueryMessageProcessor;
import org.apache.rocketmq.broker.processor.SendMessageProcessor;
import org.apache.rocketmq.broker.slave.SlaveSynchronize;
import org.apache.rocketmq.broker.subscription.SubscriptionGroupManager;
import org.apache.rocketmq.broker.topic.TopicConfigManager;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.Configuration;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.namesrv.RegisterBrokerResult;
import org.apache.rocketmq.common.protocol.body.TopicConfigSerializeWrapper;
import org.apache.rocketmq.common.stats.MomentStatsItem;
import org.apache.rocketmq.remoting.ChannelEventListener;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.RemotingServer;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyRemotingServer;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.remoting.netty.RequestTask;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.MessageArrivingListener;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.stats.BrokerStats;
import org.apache.rocketmq.store.stats.BrokerStatsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerController {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private static final Logger LOG_PROTECTION = LoggerFactory.getLogger((String)"RocketmqProtection");
    private static final Logger LOG_WATER_MARK = LoggerFactory.getLogger((String)"RocketmqWaterMark");
    private final BrokerConfig brokerConfig;
    private final NettyServerConfig nettyServerConfig;
    private final NettyClientConfig nettyClientConfig;
    private final MessageStoreConfig messageStoreConfig;
    private final ConsumerOffsetManager consumerOffsetManager;
    private final ConsumerManager consumerManager;
    private final ProducerManager producerManager;
    private final ClientHousekeepingService clientHousekeepingService;
    private final PullMessageProcessor pullMessageProcessor;
    private final PullRequestHoldService pullRequestHoldService;
    private final MessageArrivingListener messageArrivingListener;
    private final Broker2Client broker2Client;
    private final SubscriptionGroupManager subscriptionGroupManager;
    private final ConsumerIdsChangeListener consumerIdsChangeListener;
    private final RebalanceLockManager rebalanceLockManager = new RebalanceLockManager();
    private final BrokerOuterAPI brokerOuterAPI;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("BrokerControllerScheduledThread"));
    private final SlaveSynchronize slaveSynchronize;
    private final BlockingQueue<Runnable> sendThreadPoolQueue;
    private final BlockingQueue<Runnable> pullThreadPoolQueue;
    private final BlockingQueue<Runnable> clientManagerThreadPoolQueue;
    private final BlockingQueue<Runnable> consumerManagerThreadPoolQueue;
    private final FilterServerManager filterServerManager;
    private final BrokerStatsManager brokerStatsManager;
    private final List<SendMessageHook> sendMessageHookList = new ArrayList<SendMessageHook>();
    private final List<ConsumeMessageHook> consumeMessageHookList = new ArrayList<ConsumeMessageHook>();
    private MessageStore messageStore;
    private RemotingServer remotingServer;
    private RemotingServer fastRemotingServer;
    private TopicConfigManager topicConfigManager;
    private ExecutorService sendMessageExecutor;
    private ExecutorService pullMessageExecutor;
    private ExecutorService adminBrokerExecutor;
    private ExecutorService clientManageExecutor;
    private ExecutorService consumerManageExecutor;
    private boolean updateMasterHAServerAddrPeriodically = false;
    private BrokerStats brokerStats;
    private InetSocketAddress storeHost;
    private BrokerFastFailure brokerFastFailure;
    private Configuration configuration;

    public BrokerController(BrokerConfig brokerConfig, NettyServerConfig nettyServerConfig, NettyClientConfig nettyClientConfig, MessageStoreConfig messageStoreConfig) {
        this.brokerConfig = brokerConfig;
        this.nettyServerConfig = nettyServerConfig;
        this.nettyClientConfig = nettyClientConfig;
        this.messageStoreConfig = messageStoreConfig;
        this.consumerOffsetManager = new ConsumerOffsetManager(this);
        this.topicConfigManager = new TopicConfigManager(this);
        this.pullMessageProcessor = new PullMessageProcessor(this);
        this.pullRequestHoldService = new PullRequestHoldService(this);
        this.messageArrivingListener = new NotifyMessageArrivingListener(this.pullRequestHoldService);
        this.consumerIdsChangeListener = new DefaultConsumerIdsChangeListener(this);
        this.consumerManager = new ConsumerManager(this.consumerIdsChangeListener);
        this.producerManager = new ProducerManager();
        this.clientHousekeepingService = new ClientHousekeepingService(this);
        this.broker2Client = new Broker2Client(this);
        this.subscriptionGroupManager = new SubscriptionGroupManager(this);
        this.brokerOuterAPI = new BrokerOuterAPI(nettyClientConfig);
        this.filterServerManager = new FilterServerManager(this);
        this.slaveSynchronize = new SlaveSynchronize(this);
        this.sendThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getSendThreadPoolQueueCapacity());
        this.pullThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getPullThreadPoolQueueCapacity());
        this.clientManagerThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getClientManagerThreadPoolQueueCapacity());
        this.consumerManagerThreadPoolQueue = new LinkedBlockingQueue<Runnable>(this.brokerConfig.getConsumerManagerThreadPoolQueueCapacity());
        this.brokerStatsManager = new BrokerStatsManager(this.brokerConfig.getBrokerClusterName());
        this.setStoreHost(new InetSocketAddress(this.getBrokerConfig().getBrokerIP1(), this.getNettyServerConfig().getListenPort()));
        this.brokerFastFailure = new BrokerFastFailure(this);
        this.configuration = new Configuration(log, BrokerPathConfigHelper.getBrokerConfigPath(), new Object[]{this.brokerConfig, this.nettyServerConfig, this.nettyClientConfig, this.messageStoreConfig});
    }

    public BrokerConfig getBrokerConfig() {
        return this.brokerConfig;
    }

    public NettyServerConfig getNettyServerConfig() {
        return this.nettyServerConfig;
    }

    public BlockingQueue<Runnable> getPullThreadPoolQueue() {
        return this.pullThreadPoolQueue;
    }

    public boolean initialize() throws CloneNotSupportedException {
        boolean result = true;
        result = result && this.topicConfigManager.load();
        result = result && this.consumerOffsetManager.load();
        boolean bl = result = result && this.subscriptionGroupManager.load();
        if (result) {
            try {
                this.messageStore = new DefaultMessageStore(this.messageStoreConfig, this.brokerStatsManager, this.messageArrivingListener, this.brokerConfig);
                this.brokerStats = new BrokerStats((DefaultMessageStore)this.messageStore);
                MessageStorePluginContext context = new MessageStorePluginContext(this.messageStoreConfig, this.brokerStatsManager, this.messageArrivingListener, this.brokerConfig);
                this.messageStore = MessageStoreFactory.build(context, this.messageStore);
            }
            catch (IOException e) {
                result = false;
                e.printStackTrace();
            }
        }
        boolean bl2 = result = result && this.messageStore.load();
        if (result) {
            this.remotingServer = new NettyRemotingServer(this.nettyServerConfig, (ChannelEventListener)this.clientHousekeepingService);
            NettyServerConfig fastConfig = (NettyServerConfig)this.nettyServerConfig.clone();
            fastConfig.setListenPort(this.nettyServerConfig.getListenPort() - 2);
            this.fastRemotingServer = new NettyRemotingServer(fastConfig, (ChannelEventListener)this.clientHousekeepingService);
            this.sendMessageExecutor = new BrokerFixedThreadPoolExecutor(this.brokerConfig.getSendMessageThreadPoolNums(), this.brokerConfig.getSendMessageThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.sendThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("SendMessageThread_"));
            this.pullMessageExecutor = new BrokerFixedThreadPoolExecutor(this.brokerConfig.getPullMessageThreadPoolNums(), this.brokerConfig.getPullMessageThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.pullThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("PullMessageThread_"));
            this.adminBrokerExecutor = Executors.newFixedThreadPool(this.brokerConfig.getAdminBrokerThreadPoolNums(), (ThreadFactory)new ThreadFactoryImpl("AdminBrokerThread_"));
            this.clientManageExecutor = new ThreadPoolExecutor(this.brokerConfig.getClientManageThreadPoolNums(), this.brokerConfig.getClientManageThreadPoolNums(), 60000L, TimeUnit.MILLISECONDS, this.clientManagerThreadPoolQueue, (ThreadFactory)new ThreadFactoryImpl("ClientManageThread_"));
            this.consumerManageExecutor = Executors.newFixedThreadPool(this.brokerConfig.getConsumerManageThreadPoolNums(), (ThreadFactory)new ThreadFactoryImpl("ConsumerManageThread_"));
            this.registerProcessor();
            long initialDelay = UtilAll.computNextMorningTimeMillis() - System.currentTimeMillis();
            long period = 86400000L;
            this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        BrokerController.this.getBrokerStats().record();
                    }
                    catch (Throwable e) {
                        log.error("schedule record error.", e);
                    }
                }
            }, initialDelay, 86400000L, TimeUnit.MILLISECONDS);
            this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        BrokerController.this.consumerOffsetManager.persist();
                    }
                    catch (Throwable e) {
                        log.error("schedule persist consumerOffset error.", e);
                    }
                }
            }, 10000L, this.brokerConfig.getFlushConsumerOffsetInterval(), TimeUnit.MILLISECONDS);
            this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        BrokerController.this.protectBroker();
                    }
                    catch (Exception e) {
                        log.error("protectBroker error.", (Throwable)e);
                    }
                }
            }, 3L, 3L, TimeUnit.MINUTES);
            this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        BrokerController.this.printWaterMark();
                    }
                    catch (Exception e) {
                        log.error("printWaterMark error.", (Throwable)e);
                    }
                }
            }, 10L, 1L, TimeUnit.SECONDS);
            this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        log.info("dispatch behind commit log {} bytes", (Object)BrokerController.this.getMessageStore().dispatchBehindBytes());
                    }
                    catch (Throwable e) {
                        log.error("schedule dispatchBehindBytes error.", e);
                    }
                }
            }, 10000L, 60000L, TimeUnit.MILLISECONDS);
            if (this.brokerConfig.getNamesrvAddr() != null) {
                this.brokerOuterAPI.updateNameServerAddressList(this.brokerConfig.getNamesrvAddr());
                log.info("Set user specified name server address: {}", (Object)this.brokerConfig.getNamesrvAddr());
            } else if (this.brokerConfig.isFetchNamesrvAddrByAddressServer()) {
                this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BrokerController.this.brokerOuterAPI.fetchNameServerAddr();
                        }
                        catch (Throwable e) {
                            log.error("ScheduledTask fetchNameServerAddr exception", e);
                        }
                    }
                }, 10000L, 120000L, TimeUnit.MILLISECONDS);
            }
            if (BrokerRole.SLAVE == this.messageStoreConfig.getBrokerRole()) {
                if (this.messageStoreConfig.getHaMasterAddress() != null && this.messageStoreConfig.getHaMasterAddress().length() >= 6) {
                    this.messageStore.updateHaMasterAddress(this.messageStoreConfig.getHaMasterAddress());
                    this.updateMasterHAServerAddrPeriodically = false;
                } else {
                    this.updateMasterHAServerAddrPeriodically = true;
                }
                this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BrokerController.this.slaveSynchronize.syncAll();
                        }
                        catch (Throwable e) {
                            log.error("ScheduledTask syncAll slave exception", e);
                        }
                    }
                }, 10000L, 60000L, TimeUnit.MILLISECONDS);
            } else {
                this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BrokerController.this.printMasterAndSlaveDiff();
                        }
                        catch (Throwable e) {
                            log.error("schedule printMasterAndSlaveDiff error.", e);
                        }
                    }
                }, 10000L, 60000L, TimeUnit.MILLISECONDS);
            }
        }
        return result;
    }

    public void registerProcessor() {
        SendMessageProcessor sendProcessor = new SendMessageProcessor(this);
        sendProcessor.registerSendMessageHook(this.sendMessageHookList);
        sendProcessor.registerConsumeMessageHook(this.consumeMessageHookList);
        this.remotingServer.registerProcessor(10, (NettyRequestProcessor)sendProcessor, this.sendMessageExecutor);
        this.remotingServer.registerProcessor(310, (NettyRequestProcessor)sendProcessor, this.sendMessageExecutor);
        this.remotingServer.registerProcessor(36, (NettyRequestProcessor)sendProcessor, this.sendMessageExecutor);
        this.fastRemotingServer.registerProcessor(10, (NettyRequestProcessor)sendProcessor, this.sendMessageExecutor);
        this.fastRemotingServer.registerProcessor(310, (NettyRequestProcessor)sendProcessor, this.sendMessageExecutor);
        this.fastRemotingServer.registerProcessor(36, (NettyRequestProcessor)sendProcessor, this.sendMessageExecutor);
        this.remotingServer.registerProcessor(11, (NettyRequestProcessor)this.pullMessageProcessor, this.pullMessageExecutor);
        this.pullMessageProcessor.registerConsumeMessageHook(this.consumeMessageHookList);
        QueryMessageProcessor queryProcessor = new QueryMessageProcessor(this);
        this.remotingServer.registerProcessor(12, (NettyRequestProcessor)queryProcessor, this.pullMessageExecutor);
        this.remotingServer.registerProcessor(33, (NettyRequestProcessor)queryProcessor, this.pullMessageExecutor);
        this.fastRemotingServer.registerProcessor(12, (NettyRequestProcessor)queryProcessor, this.pullMessageExecutor);
        this.fastRemotingServer.registerProcessor(33, (NettyRequestProcessor)queryProcessor, this.pullMessageExecutor);
        ClientManageProcessor clientProcessor = new ClientManageProcessor(this);
        this.remotingServer.registerProcessor(34, (NettyRequestProcessor)clientProcessor, this.clientManageExecutor);
        this.remotingServer.registerProcessor(35, (NettyRequestProcessor)clientProcessor, this.clientManageExecutor);
        this.fastRemotingServer.registerProcessor(34, (NettyRequestProcessor)clientProcessor, this.clientManageExecutor);
        this.fastRemotingServer.registerProcessor(35, (NettyRequestProcessor)clientProcessor, this.clientManageExecutor);
        ConsumerManageProcessor consumerManageProcessor = new ConsumerManageProcessor(this);
        this.remotingServer.registerProcessor(38, (NettyRequestProcessor)consumerManageProcessor, this.consumerManageExecutor);
        this.remotingServer.registerProcessor(15, (NettyRequestProcessor)consumerManageProcessor, this.consumerManageExecutor);
        this.remotingServer.registerProcessor(14, (NettyRequestProcessor)consumerManageProcessor, this.consumerManageExecutor);
        this.fastRemotingServer.registerProcessor(38, (NettyRequestProcessor)consumerManageProcessor, this.consumerManageExecutor);
        this.fastRemotingServer.registerProcessor(15, (NettyRequestProcessor)consumerManageProcessor, this.consumerManageExecutor);
        this.fastRemotingServer.registerProcessor(14, (NettyRequestProcessor)consumerManageProcessor, this.consumerManageExecutor);
        this.remotingServer.registerProcessor(37, (NettyRequestProcessor)new EndTransactionProcessor(this), this.sendMessageExecutor);
        this.fastRemotingServer.registerProcessor(37, (NettyRequestProcessor)new EndTransactionProcessor(this), this.sendMessageExecutor);
        AdminBrokerProcessor adminProcessor = new AdminBrokerProcessor(this);
        this.remotingServer.registerDefaultProcessor((NettyRequestProcessor)adminProcessor, this.adminBrokerExecutor);
        this.fastRemotingServer.registerDefaultProcessor((NettyRequestProcessor)adminProcessor, this.adminBrokerExecutor);
    }

    public BrokerStats getBrokerStats() {
        return this.brokerStats;
    }

    public void setBrokerStats(BrokerStats brokerStats) {
        this.brokerStats = brokerStats;
    }

    public void protectBroker() {
        if (this.brokerConfig.isDisableConsumeIfConsumerReadSlowly()) {
            for (Map.Entry next : this.brokerStatsManager.getMomentStatsItemSetFallSize().getStatsItemTable().entrySet()) {
                long fallBehindBytes = ((MomentStatsItem)next.getValue()).getValue().get();
                if (fallBehindBytes <= this.brokerConfig.getConsumerFallbehindThreshold()) continue;
                String[] split = ((MomentStatsItem)next.getValue()).getStatsKey().split("@");
                String group = split[2];
                LOG_PROTECTION.info("[PROTECT_BROKER] the consumer[{}] consume slowly, {} bytes, disable it", (Object)group, (Object)fallBehindBytes);
                this.subscriptionGroupManager.disableConsume(group);
            }
        }
    }

    public long headSlowTimeMills(BlockingQueue<Runnable> q) {
        long slowTimeMills = 0L;
        Runnable peek = (Runnable)q.peek();
        if (peek != null) {
            RequestTask rt = BrokerFastFailure.castRunnable(peek);
            long l = slowTimeMills = rt == null ? 0L : this.messageStore.now() - rt.getCreateTimestamp();
        }
        if (slowTimeMills < 0L) {
            slowTimeMills = 0L;
        }
        return slowTimeMills;
    }

    public long headSlowTimeMills4SendThreadPoolQueue() {
        return this.headSlowTimeMills(this.sendThreadPoolQueue);
    }

    public long headSlowTimeMills4PullThreadPoolQueue() {
        return this.headSlowTimeMills(this.pullThreadPoolQueue);
    }

    public void printWaterMark() {
        LOG_WATER_MARK.info("[WATERMARK] Send Queue Size: {} SlowTimeMills: {}", (Object)this.sendThreadPoolQueue.size(), (Object)this.headSlowTimeMills4SendThreadPoolQueue());
        LOG_WATER_MARK.info("[WATERMARK] Pull Queue Size: {} SlowTimeMills: {}", (Object)this.pullThreadPoolQueue.size(), (Object)this.headSlowTimeMills4PullThreadPoolQueue());
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    public void setMessageStore(MessageStore messageStore) {
        this.messageStore = messageStore;
    }

    private void printMasterAndSlaveDiff() {
        long diff = this.messageStore.slaveFallBehindMuch();
        log.info("Slave fall behind master: {} bytes", (Object)diff);
    }

    public Broker2Client getBroker2Client() {
        return this.broker2Client;
    }

    public ConsumerManager getConsumerManager() {
        return this.consumerManager;
    }

    public ConsumerOffsetManager getConsumerOffsetManager() {
        return this.consumerOffsetManager;
    }

    public MessageStoreConfig getMessageStoreConfig() {
        return this.messageStoreConfig;
    }

    public ProducerManager getProducerManager() {
        return this.producerManager;
    }

    public void setFastRemotingServer(RemotingServer fastRemotingServer) {
        this.fastRemotingServer = fastRemotingServer;
    }

    public PullMessageProcessor getPullMessageProcessor() {
        return this.pullMessageProcessor;
    }

    public PullRequestHoldService getPullRequestHoldService() {
        return this.pullRequestHoldService;
    }

    public SubscriptionGroupManager getSubscriptionGroupManager() {
        return this.subscriptionGroupManager;
    }

    public void shutdown() {
        if (this.brokerStatsManager != null) {
            this.brokerStatsManager.shutdown();
        }
        if (this.clientHousekeepingService != null) {
            this.clientHousekeepingService.shutdown();
        }
        if (this.pullRequestHoldService != null) {
            this.pullRequestHoldService.shutdown();
        }
        if (this.remotingServer != null) {
            this.remotingServer.shutdown();
        }
        if (this.fastRemotingServer != null) {
            this.fastRemotingServer.shutdown();
        }
        if (this.messageStore != null) {
            this.messageStore.shutdown();
        }
        this.scheduledExecutorService.shutdown();
        try {
            this.scheduledExecutorService.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.unregisterBrokerAll();
        if (this.sendMessageExecutor != null) {
            this.sendMessageExecutor.shutdown();
        }
        if (this.pullMessageExecutor != null) {
            this.pullMessageExecutor.shutdown();
        }
        if (this.adminBrokerExecutor != null) {
            this.adminBrokerExecutor.shutdown();
        }
        if (this.brokerOuterAPI != null) {
            this.brokerOuterAPI.shutdown();
        }
        this.consumerOffsetManager.persist();
        if (this.filterServerManager != null) {
            this.filterServerManager.shutdown();
        }
        if (this.brokerFastFailure != null) {
            this.brokerFastFailure.shutdown();
        }
    }

    private void unregisterBrokerAll() {
        this.brokerOuterAPI.unregisterBrokerAll(this.brokerConfig.getBrokerClusterName(), this.getBrokerAddr(), this.brokerConfig.getBrokerName(), this.brokerConfig.getBrokerId());
    }

    public String getBrokerAddr() {
        return this.brokerConfig.getBrokerIP1() + ":" + this.nettyServerConfig.getListenPort();
    }

    public void start() throws Exception {
        if (this.messageStore != null) {
            this.messageStore.start();
        }
        if (this.remotingServer != null) {
            this.remotingServer.start();
        }
        if (this.fastRemotingServer != null) {
            this.fastRemotingServer.start();
        }
        if (this.brokerOuterAPI != null) {
            this.brokerOuterAPI.start();
        }
        if (this.pullRequestHoldService != null) {
            this.pullRequestHoldService.start();
        }
        if (this.clientHousekeepingService != null) {
            this.clientHousekeepingService.start();
        }
        if (this.filterServerManager != null) {
            this.filterServerManager.start();
        }
        this.registerBrokerAll(true, false);
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    BrokerController.this.registerBrokerAll(true, false);
                }
                catch (Throwable e) {
                    log.error("registerBrokerAll Exception", e);
                }
            }
        }, 10000L, 30000L, TimeUnit.MILLISECONDS);
        if (this.brokerStatsManager != null) {
            this.brokerStatsManager.start();
        }
        if (this.brokerFastFailure != null) {
            this.brokerFastFailure.start();
        }
    }

    public synchronized void registerBrokerAll(boolean checkOrderConfig, boolean oneway) {
        RegisterBrokerResult registerBrokerResult;
        TopicConfigSerializeWrapper topicConfigWrapper = this.getTopicConfigManager().buildTopicConfigSerializeWrapper();
        if (!PermName.isWriteable((int)this.getBrokerConfig().getBrokerPermission()) || !PermName.isReadable((int)this.getBrokerConfig().getBrokerPermission())) {
            ConcurrentHashMap<String, TopicConfig> topicConfigTable = new ConcurrentHashMap<String, TopicConfig>();
            for (TopicConfig topicConfig : topicConfigWrapper.getTopicConfigTable().values()) {
                TopicConfig tmp = new TopicConfig(topicConfig.getTopicName(), topicConfig.getReadQueueNums(), topicConfig.getWriteQueueNums(), this.brokerConfig.getBrokerPermission());
                topicConfigTable.put(topicConfig.getTopicName(), tmp);
            }
            topicConfigWrapper.setTopicConfigTable(topicConfigTable);
        }
        if ((registerBrokerResult = this.brokerOuterAPI.registerBrokerAll(this.brokerConfig.getBrokerClusterName(), this.getBrokerAddr(), this.brokerConfig.getBrokerName(), this.brokerConfig.getBrokerId(), this.getHAServerAddr(), topicConfigWrapper, this.filterServerManager.buildNewFilterServerList(), oneway, this.brokerConfig.getRegisterBrokerTimeoutMills())) != null) {
            if (this.updateMasterHAServerAddrPeriodically && registerBrokerResult.getHaServerAddr() != null) {
                this.messageStore.updateHaMasterAddress(registerBrokerResult.getHaServerAddr());
            }
            this.slaveSynchronize.setMasterAddr(registerBrokerResult.getMasterAddr());
            if (checkOrderConfig) {
                this.getTopicConfigManager().updateOrderTopicConfig(registerBrokerResult.getKvTable());
            }
        }
    }

    public TopicConfigManager getTopicConfigManager() {
        return this.topicConfigManager;
    }

    public void setTopicConfigManager(TopicConfigManager topicConfigManager) {
        this.topicConfigManager = topicConfigManager;
    }

    public String getHAServerAddr() {
        return this.brokerConfig.getBrokerIP2() + ":" + this.messageStoreConfig.getHaListenPort();
    }

    public RebalanceLockManager getRebalanceLockManager() {
        return this.rebalanceLockManager;
    }

    public SlaveSynchronize getSlaveSynchronize() {
        return this.slaveSynchronize;
    }

    public ExecutorService getPullMessageExecutor() {
        return this.pullMessageExecutor;
    }

    public void setPullMessageExecutor(ExecutorService pullMessageExecutor) {
        this.pullMessageExecutor = pullMessageExecutor;
    }

    public BlockingQueue<Runnable> getSendThreadPoolQueue() {
        return this.sendThreadPoolQueue;
    }

    public FilterServerManager getFilterServerManager() {
        return this.filterServerManager;
    }

    public BrokerStatsManager getBrokerStatsManager() {
        return this.brokerStatsManager;
    }

    public List<SendMessageHook> getSendMessageHookList() {
        return this.sendMessageHookList;
    }

    public void registerSendMessageHook(SendMessageHook hook) {
        this.sendMessageHookList.add(hook);
        log.info("register SendMessageHook Hook, {}", (Object)hook.hookName());
    }

    public List<ConsumeMessageHook> getConsumeMessageHookList() {
        return this.consumeMessageHookList;
    }

    public void registerConsumeMessageHook(ConsumeMessageHook hook) {
        this.consumeMessageHookList.add(hook);
        log.info("register ConsumeMessageHook Hook, {}", (Object)hook.hookName());
    }

    public void registerServerRPCHook(RPCHook rpcHook) {
        this.getRemotingServer().registerRPCHook(rpcHook);
    }

    public RemotingServer getRemotingServer() {
        return this.remotingServer;
    }

    public void setRemotingServer(RemotingServer remotingServer) {
        this.remotingServer = remotingServer;
    }

    public void registerClientRPCHook(RPCHook rpcHook) {
        this.getBrokerOuterAPI().registerRPCHook(rpcHook);
    }

    public BrokerOuterAPI getBrokerOuterAPI() {
        return this.brokerOuterAPI;
    }

    public InetSocketAddress getStoreHost() {
        return this.storeHost;
    }

    public void setStoreHost(InetSocketAddress storeHost) {
        this.storeHost = storeHost;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

