/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.longpolling.PullRequest;
import org.apache.rocketmq.broker.mqtrace.ConsumeMessageContext;
import org.apache.rocketmq.broker.mqtrace.ConsumeMessageHook;
import org.apache.rocketmq.broker.pagecache.ManyMessageTransfer;
import org.apache.rocketmq.common.TopicFilterType;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.filter.FilterAPI;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.protocol.header.PullMessageRequestHeader;
import org.apache.rocketmq.common.protocol.header.PullMessageResponseHeader;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.common.protocol.topic.OffsetMovedEvent;
import org.apache.rocketmq.common.sysflag.PullSysFlag;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.common.RemotingUtil;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.RequestTask;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.GetMessageStatus;
import org.apache.rocketmq.store.MessageExtBrokerInner;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.stats.BrokerStatsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullMessageProcessor
implements NettyRequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final BrokerController brokerController;
    private List<ConsumeMessageHook> consumeMessageHookList;

    public PullMessageProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        return this.processRequest(ctx.channel(), request, true);
    }

    public boolean rejectRequest() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private RemotingCommand processRequest(final Channel channel, RemotingCommand request, boolean brokerAllowSuspend) throws RemotingCommandException {
        block60: {
            block59: {
                response = RemotingCommand.createResponseCommand(PullMessageResponseHeader.class);
                responseHeader = (PullMessageResponseHeader)response.readCustomHeader();
                requestHeader = (PullMessageRequestHeader)request.decodeCommandCustomHeader(PullMessageRequestHeader.class);
                response.setOpaque(request.getOpaque());
                if (PullMessageProcessor.LOG.isDebugEnabled()) {
                    PullMessageProcessor.LOG.debug("receive PullMessage request command, {}", (Object)request);
                }
                if (!PermName.isReadable((int)this.brokerController.getBrokerConfig().getBrokerPermission())) {
                    response.setCode(16);
                    response.setRemark(String.format("the broker[%s] pulling message is forbidden", new Object[]{this.brokerController.getBrokerConfig().getBrokerIP1()}));
                    return response;
                }
                subscriptionGroupConfig = this.brokerController.getSubscriptionGroupManager().findSubscriptionGroupConfig(requestHeader.getConsumerGroup());
                if (null == subscriptionGroupConfig) {
                    response.setCode(26);
                    response.setRemark(String.format("subscription group [%s] does not exist, %s", new Object[]{requestHeader.getConsumerGroup(), FAQUrl.suggestTodo((String)"http://rocketmq.apache.org/docs/faq/")}));
                    return response;
                }
                if (!subscriptionGroupConfig.isConsumeEnable()) {
                    response.setCode(16);
                    response.setRemark("subscription group no permission, " + requestHeader.getConsumerGroup());
                    return response;
                }
                hasSuspendFlag = PullSysFlag.hasSuspendFlag((int)requestHeader.getSysFlag());
                hasCommitOffsetFlag = PullSysFlag.hasCommitOffsetFlag((int)requestHeader.getSysFlag());
                hasSubscriptionFlag = PullSysFlag.hasSubscriptionFlag((int)requestHeader.getSysFlag());
                suspendTimeoutMillisLong = hasSuspendFlag != false ? requestHeader.getSuspendTimeoutMillis() : 0L;
                topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(requestHeader.getTopic());
                if (null == topicConfig) {
                    PullMessageProcessor.LOG.error("The topic {} not exist, consumer: {} ", (Object)requestHeader.getTopic(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)channel));
                    response.setCode(17);
                    response.setRemark(String.format("topic[%s] not exist, apply first please! %s", new Object[]{requestHeader.getTopic(), FAQUrl.suggestTodo((String)"http://rocketmq.apache.org/docs/faq/")}));
                    return response;
                }
                if (!PermName.isReadable((int)topicConfig.getPerm())) {
                    response.setCode(16);
                    response.setRemark("the topic[" + requestHeader.getTopic() + "] pulling message is forbidden");
                    return response;
                }
                if (requestHeader.getQueueId() < 0 || requestHeader.getQueueId() >= topicConfig.getReadQueueNums()) {
                    errorInfo = String.format("queueId[%d] is illagal, topic:[%s] topicConfig.readQueueNums:[%d] consumer:[%s]", new Object[]{requestHeader.getQueueId(), requestHeader.getTopic(), topicConfig.getReadQueueNums(), channel.remoteAddress()});
                    PullMessageProcessor.LOG.warn(errorInfo);
                    response.setCode(1);
                    response.setRemark(errorInfo);
                    return response;
                }
                subscriptionData = null;
                if (hasSubscriptionFlag) {
                    try {
                        subscriptionData = FilterAPI.buildSubscriptionData((String)requestHeader.getConsumerGroup(), (String)requestHeader.getTopic(), (String)requestHeader.getSubscription());
                    }
                    catch (Exception e) {
                        PullMessageProcessor.LOG.warn("Parse the consumer's subscription[{}] failed, group: {}", (Object)requestHeader.getSubscription(), (Object)requestHeader.getConsumerGroup());
                        response.setCode(23);
                        response.setRemark("parse the consumer's subscription failed");
                        return response;
                    }
                } else {
                    consumerGroupInfo = this.brokerController.getConsumerManager().getConsumerGroupInfo(requestHeader.getConsumerGroup());
                    if (null == consumerGroupInfo) {
                        PullMessageProcessor.LOG.warn("The consumer's group info not exist, group: {}", (Object)requestHeader.getConsumerGroup());
                        response.setCode(24);
                        response.setRemark("the consumer's group info not exist" + FAQUrl.suggestTodo((String)"http://rocketmq.apache.org/docs/faq/"));
                        return response;
                    }
                    if (!subscriptionGroupConfig.isConsumeBroadcastEnable() && consumerGroupInfo.getMessageModel() == MessageModel.BROADCASTING) {
                        response.setCode(16);
                        response.setRemark("the consumer group[" + requestHeader.getConsumerGroup() + "] can not consume by broadcast way");
                        return response;
                    }
                    subscriptionData = consumerGroupInfo.findSubscriptionData(requestHeader.getTopic());
                    if (null == subscriptionData) {
                        PullMessageProcessor.LOG.warn("The consumer's subscription not exist, group: {}, topic:{}", (Object)requestHeader.getConsumerGroup(), (Object)requestHeader.getTopic());
                        response.setCode(24);
                        response.setRemark("the consumer's subscription not exist" + FAQUrl.suggestTodo((String)"http://rocketmq.apache.org/docs/faq/"));
                        return response;
                    }
                    if (subscriptionData.getSubVersion() < requestHeader.getSubVersion()) {
                        PullMessageProcessor.LOG.warn("The broker's subscription is not latest, group: {} {}", (Object)requestHeader.getConsumerGroup(), (Object)subscriptionData.getSubString());
                        response.setCode(25);
                        response.setRemark("the consumer's subscription not latest");
                        return response;
                    }
                }
                getMessageResult = this.brokerController.getMessageStore().getMessage(requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId().intValue(), requestHeader.getQueueOffset().longValue(), requestHeader.getMaxMsgNums().intValue(), subscriptionData);
                if (getMessageResult == null) break block59;
                response.setRemark(getMessageResult.getStatus().name());
                responseHeader.setNextBeginOffset(Long.valueOf(getMessageResult.getNextBeginOffset()));
                responseHeader.setMinOffset(Long.valueOf(getMessageResult.getMinOffset()));
                responseHeader.setMaxOffset(Long.valueOf(getMessageResult.getMaxOffset()));
                if (getMessageResult.isSuggestPullingFromSlave()) {
                    responseHeader.setSuggestWhichBrokerId(Long.valueOf(subscriptionGroupConfig.getWhichBrokerWhenConsumeSlowly()));
                } else {
                    responseHeader.setSuggestWhichBrokerId(Long.valueOf(0L));
                }
                switch (3.$SwitchMap$org$apache$rocketmq$store$config$BrokerRole[this.brokerController.getMessageStoreConfig().getBrokerRole().ordinal()]) {
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        if (this.brokerController.getBrokerConfig().isSlaveReadEnable()) break;
                        response.setCode(20);
                        responseHeader.setSuggestWhichBrokerId(Long.valueOf(0L));
                    }
                }
                if (this.brokerController.getBrokerConfig().isSlaveReadEnable()) {
                    if (getMessageResult.isSuggestPullingFromSlave()) {
                        responseHeader.setSuggestWhichBrokerId(Long.valueOf(subscriptionGroupConfig.getWhichBrokerWhenConsumeSlowly()));
                    } else {
                        responseHeader.setSuggestWhichBrokerId(Long.valueOf(subscriptionGroupConfig.getBrokerId()));
                    }
                } else {
                    responseHeader.setSuggestWhichBrokerId(Long.valueOf(0L));
                }
                switch (3.$SwitchMap$org$apache$rocketmq$store$GetMessageStatus[getMessageResult.getStatus().ordinal()]) {
                    case 1: {
                        response.setCode(0);
                        break;
                    }
                    case 2: {
                        response.setCode(20);
                        break;
                    }
                    case 3: 
                    case 4: {
                        if (0L != requestHeader.getQueueOffset()) {
                            response.setCode(21);
                            PullMessageProcessor.LOG.info("the broker store no queue data, fix the request offset {} to {}, Topic: {} QueueId: {} Consumer Group: {}", new Object[]{requestHeader.getQueueOffset(), getMessageResult.getNextBeginOffset(), requestHeader.getTopic(), requestHeader.getQueueId(), requestHeader.getConsumerGroup()});
                            break;
                        }
                        response.setCode(19);
                        break;
                    }
                    case 5: {
                        response.setCode(20);
                        break;
                    }
                    case 6: {
                        response.setCode(19);
                        break;
                    }
                    case 7: {
                        response.setCode(21);
                        PullMessageProcessor.LOG.info("The request offset:{} over flow badly, broker max offset:{} , consumer: {}", new Object[]{requestHeader.getQueueOffset(), getMessageResult.getMaxOffset(), channel.remoteAddress()});
                        break;
                    }
                    case 8: {
                        response.setCode(19);
                        break;
                    }
                    case 9: {
                        response.setCode(21);
                        PullMessageProcessor.LOG.info("The request offset is too small. group={}, topic={}, requestOffset={}, brokerMinOffset={}, clientIp={}", new Object[]{requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueOffset(), getMessageResult.getMinOffset(), channel.remoteAddress()});
                        break;
                    }
                    default: {
                        if (!PullMessageProcessor.$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
                if (this.hasConsumeMessageHook()) {
                    context = new ConsumeMessageContext();
                    context.setConsumerGroup(requestHeader.getConsumerGroup());
                    context.setTopic(requestHeader.getTopic());
                    context.setQueueId(requestHeader.getQueueId());
                    owner = (String)request.getExtFields().get("Owner");
                    switch (response.getCode()) {
                        case 0: {
                            commercialBaseCount = this.brokerController.getBrokerConfig().getCommercialBaseCount();
                            incValue = getMessageResult.getMsgCount4Commercial() * commercialBaseCount;
                            context.setCommercialRcvStats(BrokerStatsManager.StatsType.RCV_SUCCESS);
                            context.setCommercialRcvTimes(incValue);
                            context.setCommercialRcvSize(getMessageResult.getBufferTotalSize());
                            context.setCommercialOwner(owner);
                            break;
                        }
                        case 19: {
                            if (brokerAllowSuspend) break;
                            context.setCommercialRcvStats(BrokerStatsManager.StatsType.RCV_EPOLLS);
                            context.setCommercialRcvTimes(1);
                            context.setCommercialOwner(owner);
                            break;
                        }
                        case 20: 
                        case 21: {
                            context.setCommercialRcvStats(BrokerStatsManager.StatsType.RCV_EPOLLS);
                            context.setCommercialRcvTimes(1);
                            context.setCommercialOwner(owner);
                            break;
                        }
                        default: {
                            if (!PullMessageProcessor.$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            break;
                        }
                    }
                    this.executeConsumeMessageHookBefore(context);
                }
                switch (response.getCode()) {
                    case 0: {
                        this.brokerController.getBrokerStatsManager().incGroupGetNums(requestHeader.getConsumerGroup(), requestHeader.getTopic(), getMessageResult.getMessageCount());
                        this.brokerController.getBrokerStatsManager().incGroupGetSize(requestHeader.getConsumerGroup(), requestHeader.getTopic(), getMessageResult.getBufferTotalSize());
                        this.brokerController.getBrokerStatsManager().incBrokerGetNums(getMessageResult.getMessageCount());
                        if (this.brokerController.getBrokerConfig().isTransferMsgByHeap()) {
                            beginTimeMills = this.brokerController.getMessageStore().now();
                            r = this.readGetMessageResult(getMessageResult, requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId());
                            this.brokerController.getBrokerStatsManager().incGroupGetLatency(requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId().intValue(), (int)(this.brokerController.getMessageStore().now() - beginTimeMills));
                            response.setBody(r);
                        } else {
                            try {
                                fileRegion = new ManyMessageTransfer(response.encodeHeader(getMessageResult.getBufferTotalSize()), getMessageResult);
                                channel.writeAndFlush((Object)fileRegion).addListener((GenericFutureListener)new ChannelFutureListener(){

                                    public void operationComplete(ChannelFuture future) throws Exception {
                                        getMessageResult.release();
                                        if (!future.isSuccess()) {
                                            LOG.error("Fail to transfer messages from page cache to {}", (Object)channel.remoteAddress(), (Object)future.cause());
                                        }
                                    }
                                });
                            }
                            catch (Throwable e) {
                                PullMessageProcessor.LOG.error("Error occurred when transferring messages from page cache", e);
                                getMessageResult.release();
                            }
                            response = null;
                        }
                        break block60;
                    }
                    case 19: {
                        if (!brokerAllowSuspend || !hasSuspendFlag) ** GOTO lbl194
                        pollingTimeMills = suspendTimeoutMillisLong;
                        if (!this.brokerController.getBrokerConfig().isLongPollingEnable()) {
                            pollingTimeMills = this.brokerController.getBrokerConfig().getShortPollingTimeMills();
                        }
                        topic = requestHeader.getTopic();
                        offset = requestHeader.getQueueOffset();
                        queueId = requestHeader.getQueueId();
                        pullRequest = new PullRequest(request, channel, pollingTimeMills, this.brokerController.getMessageStore().now(), offset, subscriptionData);
                        this.brokerController.getPullRequestHoldService().suspendPullRequest(topic, queueId, pullRequest);
                        response = null;
                        break block60;
                    }
lbl194:
                    // 2 sources

                    case 20: {
                        break block60;
                    }
                    case 21: {
                        if (this.brokerController.getMessageStoreConfig().getBrokerRole() != BrokerRole.SLAVE || this.brokerController.getMessageStoreConfig().isOffsetCheckInSlave()) {
                            mq = new MessageQueue();
                            mq.setTopic(requestHeader.getTopic());
                            mq.setQueueId(requestHeader.getQueueId().intValue());
                            mq.setBrokerName(this.brokerController.getBrokerConfig().getBrokerName());
                            event = new OffsetMovedEvent();
                            event.setConsumerGroup(requestHeader.getConsumerGroup());
                            event.setMessageQueue(mq);
                            event.setOffsetRequest(requestHeader.getQueueOffset().longValue());
                            event.setOffsetNew(getMessageResult.getNextBeginOffset());
                            this.generateOffsetMovedEvent(event);
                            PullMessageProcessor.LOG.warn("PULL_OFFSET_MOVED:correction offset. topic={}, groupId={}, requestOffset={}, newOffset={}, suggestBrokerId={}", new Object[]{requestHeader.getTopic(), requestHeader.getConsumerGroup(), event.getOffsetRequest(), event.getOffsetNew(), responseHeader.getSuggestWhichBrokerId()});
                        } else {
                            responseHeader.setSuggestWhichBrokerId(Long.valueOf(subscriptionGroupConfig.getBrokerId()));
                            response.setCode(20);
                            PullMessageProcessor.LOG.warn("PULL_OFFSET_MOVED:none correction. topic={}, groupId={}, requestOffset={}, suggestBrokerId={}", new Object[]{requestHeader.getTopic(), requestHeader.getConsumerGroup(), requestHeader.getQueueOffset(), responseHeader.getSuggestWhichBrokerId()});
                        }
                        break block60;
                    }
                    default: {
                        if (!PullMessageProcessor.$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break block60;
                    }
                }
            }
            response.setCode(1);
            response.setRemark("store getMessage return null");
        }
        storeOffsetEnable = brokerAllowSuspend;
        storeOffsetEnable = storeOffsetEnable != false && hasCommitOffsetFlag != false;
        v0 = storeOffsetEnable = storeOffsetEnable != false && this.brokerController.getMessageStoreConfig().getBrokerRole() != BrokerRole.SLAVE;
        if (storeOffsetEnable) {
            this.brokerController.getConsumerOffsetManager().commitOffset(RemotingHelper.parseChannelRemoteAddr((Channel)channel), requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId(), requestHeader.getCommitOffset());
        }
        return response;
    }

    public boolean hasConsumeMessageHook() {
        return this.consumeMessageHookList != null && !this.consumeMessageHookList.isEmpty();
    }

    public void executeConsumeMessageHookBefore(ConsumeMessageContext context) {
        if (this.hasConsumeMessageHook()) {
            for (ConsumeMessageHook hook : this.consumeMessageHookList) {
                try {
                    hook.consumeMessageBefore(context);
                }
                catch (Throwable e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readGetMessageResult(GetMessageResult getMessageResult, String group, String topic, int queueId) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(getMessageResult.getBufferTotalSize());
        long storeTimestamp = 0L;
        try {
            List messageBufferList = getMessageResult.getMessageBufferList();
            for (ByteBuffer bb : messageBufferList) {
                byteBuffer.put(bb);
                storeTimestamp = bb.getLong(56);
            }
        }
        finally {
            getMessageResult.release();
        }
        this.brokerController.getBrokerStatsManager().recordDiskFallBehindTime(group, topic, queueId, this.brokerController.getMessageStore().now() - storeTimestamp);
        return byteBuffer.array();
    }

    private void generateOffsetMovedEvent(OffsetMovedEvent event) {
        try {
            MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
            msgInner.setTopic("OFFSET_MOVED_EVENT");
            msgInner.setTags(event.getConsumerGroup());
            msgInner.setDelayTimeLevel(0);
            msgInner.setKeys(event.getConsumerGroup());
            msgInner.setBody(event.encode());
            msgInner.setFlag(0);
            msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
            msgInner.setTagsCode(MessageExtBrokerInner.tagsString2tagsCode((TopicFilterType)TopicFilterType.SINGLE_TAG, (String)msgInner.getTags()));
            msgInner.setQueueId(0);
            msgInner.setSysFlag(0);
            msgInner.setBornTimestamp(System.currentTimeMillis());
            msgInner.setBornHost(RemotingUtil.string2SocketAddress((String)this.brokerController.getBrokerAddr()));
            msgInner.setStoreHost(msgInner.getBornHost());
            msgInner.setReconsumeTimes(0);
            PutMessageResult putMessageResult = this.brokerController.getMessageStore().putMessage(msgInner);
        }
        catch (Exception e) {
            LOG.warn(String.format("GenerateOffsetMovedEvent Exception, %s", event.toString()), (Throwable)e);
        }
    }

    public void executeRequestWhenWakeup(final Channel channel, final RemotingCommand request) throws RemotingCommandException {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    final RemotingCommand response = PullMessageProcessor.this.processRequest(channel, request, false);
                    if (response != null) {
                        response.setOpaque(request.getOpaque());
                        response.markResponseType();
                        try {
                            channel.writeAndFlush((Object)response).addListener((GenericFutureListener)new ChannelFutureListener(){

                                public void operationComplete(ChannelFuture future) throws Exception {
                                    if (!future.isSuccess()) {
                                        LOG.error("ProcessRequestWrapper response to {} failed", (Object)future.channel().remoteAddress(), (Object)future.cause());
                                        LOG.error(request.toString());
                                        LOG.error(response.toString());
                                    }
                                }
                            });
                        }
                        catch (Throwable e) {
                            LOG.error("ProcessRequestWrapper process request over, but response failed", e);
                            LOG.error(request.toString());
                            LOG.error(response.toString());
                        }
                    }
                }
                catch (RemotingCommandException e1) {
                    LOG.error("ExecuteRequestWhenWakeup run", (Throwable)e1);
                }
            }
        };
        this.brokerController.getPullMessageExecutor().submit((Runnable)new RequestTask(run, channel, request));
    }

    public void registerConsumeMessageHook(List<ConsumeMessageHook> sendMessageHookList) {
        this.consumeMessageHookList = sendMessageHookList;
    }

    static class 3 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$rocketmq$store$config$BrokerRole;
        static final /* synthetic */ int[] $SwitchMap$org$apache$rocketmq$store$GetMessageStatus;

        static {
            $SwitchMap$org$apache$rocketmq$store$GetMessageStatus = new int[GetMessageStatus.values().length];
            try {
                3.$SwitchMap$org$apache$rocketmq$store$GetMessageStatus[GetMessageStatus.FOUND.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$apache$rocketmq$store$GetMessageStatus[GetMessageStatus.MESSAGE_WAS_REMOVING.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$apache$rocketmq$store$GetMessageStatus[GetMessageStatus.NO_MATCHED_LOGIC_QUEUE.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$apache$rocketmq$store$GetMessageStatus[GetMessageStatus.NO_MESSAGE_IN_QUEUE.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$apache$rocketmq$store$GetMessageStatus[GetMessageStatus.NO_MATCHED_MESSAGE.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$apache$rocketmq$store$GetMessageStatus[GetMessageStatus.OFFSET_FOUND_NULL.ordinal()] = 6;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$apache$rocketmq$store$GetMessageStatus[GetMessageStatus.OFFSET_OVERFLOW_BADLY.ordinal()] = 7;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$apache$rocketmq$store$GetMessageStatus[GetMessageStatus.OFFSET_OVERFLOW_ONE.ordinal()] = 8;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$apache$rocketmq$store$GetMessageStatus[GetMessageStatus.OFFSET_TOO_SMALL.ordinal()] = 9;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            $SwitchMap$org$apache$rocketmq$store$config$BrokerRole = new int[BrokerRole.values().length];
            try {
                3.$SwitchMap$org$apache$rocketmq$store$config$BrokerRole[BrokerRole.ASYNC_MASTER.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$apache$rocketmq$store$config$BrokerRole[BrokerRole.SYNC_MASTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$apache$rocketmq$store$config$BrokerRole[BrokerRole.SLAVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

