/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.timer;

import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.rocketmq.common.message.MessageExt;

public class TimerRequest {
    private final long offsetPy;
    private final int sizePy;
    private final long delayTime;
    private final int magic;
    private long enqueueTime;
    private MessageExt msg;
    private CountDownLatch latch;
    private boolean released;
    private boolean succ;
    private Set<String> deleteList;

    public TimerRequest(long offsetPy, int sizePy, long delayTime, long enqueueTime, int magic) {
        this(offsetPy, sizePy, delayTime, enqueueTime, magic, null);
    }

    public TimerRequest(long offsetPy, int sizePy, long delayTime, long enqueueTime, int magic, MessageExt msg) {
        this.offsetPy = offsetPy;
        this.sizePy = sizePy;
        this.delayTime = delayTime;
        this.enqueueTime = enqueueTime;
        this.magic = magic;
        this.msg = msg;
    }

    public long getOffsetPy() {
        return this.offsetPy;
    }

    public int getSizePy() {
        return this.sizePy;
    }

    public long getDelayTime() {
        return this.delayTime;
    }

    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    public MessageExt getMsg() {
        return this.msg;
    }

    public void setMsg(MessageExt msg) {
        this.msg = msg;
    }

    public int getMagic() {
        return this.magic;
    }

    public Set<String> getDeleteList() {
        return this.deleteList;
    }

    public void setDeleteList(Set<String> deleteList) {
        this.deleteList = deleteList;
    }

    public void setLatch(CountDownLatch latch) {
        this.latch = latch;
    }

    public void setEnqueueTime(long enqueueTime) {
        this.enqueueTime = enqueueTime;
    }

    public void idempotentRelease() {
        this.idempotentRelease(true);
    }

    public void idempotentRelease(boolean succ) {
        this.succ = succ;
        if (!this.released && this.latch != null) {
            this.released = true;
            this.latch.countDown();
        }
    }

    public boolean isSucc() {
        return this.succ;
    }

    public String toString() {
        return "TimerRequest{offsetPy=" + this.offsetPy + ", sizePy=" + this.sizePy + ", delayTime=" + this.delayTime + ", enqueueTime=" + this.enqueueTime + ", magic=" + this.magic + ", msg=" + this.msg + ", latch=" + this.latch + ", released=" + this.released + ", succ=" + this.succ + ", deleteList=" + this.deleteList + '}';
    }
}

