/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.broker;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.SubCommand;

public class CleanExpiredCQSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "cleanExpiredCQ";
    }

    @Override
    public String commandDesc() {
        return "Clean expired ConsumeQueue on broker.";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("b", "brokerAddr", true, "Broker address");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("c", "cluster", true, "clustername");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            boolean result = false;
            defaultMQAdminExt.start();
            if (commandLine.hasOption('b')) {
                String addr = commandLine.getOptionValue('b').trim();
                result = defaultMQAdminExt.cleanExpiredConsumerQueueByAddr(addr);
            } else {
                String cluster = commandLine.getOptionValue('c');
                if (null != cluster) {
                    cluster = cluster.trim();
                }
                result = defaultMQAdminExt.cleanExpiredConsumerQueue(cluster);
            }
            System.out.printf(result ? "success" : "false", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }
}

